/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.IPField;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGSplitPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.RangeIfacePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class IPNServiceConfigAddress
extends ServiceConfigTabbedPanel
implements Printable {
    private boolean loadList = true;
    private String ifaces = null;
    private IPField ip = new IPField();
    private IntTextField port = new IntTextField();
    private BGTable tableAddress = new BGTable();
    private JButton findButton = new JButton();
    private BGButton copyButton = new BGButton();
    private BGButton pasteButton = new BGButton();
    private BGButton cutButton = new BGButton();
    private BGButton printButton = new BGButton();
    private JComboBox<String> mask = new JComboBox();
    private RangeIfacePanel sourceTree = new RangeIfacePanel(false);
    private JLabel recordsCount = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelPeriod bGControlPanel_07 = new BGControlPanelPeriod();
    private BGTextField commentFilter = new BGTextField();

    public IPNServiceConfigAddress() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        ActionListener al = e -> {
            Transferable content;
            String actionCommand = e.getActionCommand();
            Clipboard theClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (actionCommand.equals("copy")) {
                String ipValue = this.ip.getIP();
                if (ipValue != null && ipValue.length() > 0) {
                    StringSelection buffer = new StringSelection(ipValue);
                    theClipboard.setContents(buffer, buffer);
                }
            } else if (actionCommand.equals("cut")) {
                String ipValue = this.ip.getIP();
                if (ipValue != null && ipValue.length() > 0) {
                    StringSelection buffer = new StringSelection(ipValue);
                    theClipboard.setContents(buffer, buffer);
                }
                this.ip.setIP("0.0.0.0");
            } else if (actionCommand.equals("paste") && (content = theClipboard.getContents(this)) != null) {
                try {
                    this.ip.setIP((String)content.getTransferData(DataFlavor.stringFlavor));
                }
                catch (Exception ex) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        };
        this.copyButton.addActionListener(al);
        this.pasteButton.addActionListener(al);
        this.cutButton.addActionListener(al);
        for (int i = 32; i > 7; --i) {
            this.mask.addItem(String.valueOf(i));
        }
        this.tableAddress.setHeader(this.rb_name, this.moduleDoc, "address");
    }

    private void jbInit() throws Exception {
        this.ip.setMinimumSize(new Dimension(160, 24));
        this.ip.setPreferredSize(new Dimension(160, 24));
        this.ip.setHorizontalAlignment(0);
        this.port.setMaxValue(65535L);
        this.port.setColumns(7);
        this.port.setMinimumSize(new Dimension(50, 24));
        this.port.setPreferredSize(new Dimension(50, 24));
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder((Border)new BGTitleBorder(" \u0410\u0434\u0440\u0435\u0441 : \u043f\u043e\u0440\u0442 / \u043c\u0430\u0441\u043a\u0430 "));
        jPanel5.add((Component)this.ip, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        jPanel5.add((Component)new JLabel(" : "), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel5.add((Component)this.port, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel5.add((Component)new JLabel(" / "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add(this.mask, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.pagePanel.addPropertyChangeListener(e -> {
            if (e.getPropertyName() != null && e.getPropertyName().startsWith("to")) {
                this.setData();
            }
        });
        this.findButton.setText("\u041f\u043e\u0438\u0441\u043a   >>>");
        this.findButton.addActionListener(e -> {
            this.pagePanel.init();
            this.findButton_actionPerformed(e);
        });
        this.tableAddress.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IPNServiceConfigAddress.this.tableAddress_mouseClicked(e);
            }
        });
        this.pasteButton.setToolTipText("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c");
        this.pasteButton.setIcon((Icon)ClientUtils.getIcon((String)"paste"));
        this.pasteButton.setActionCommand("paste");
        this.pasteButton.setMargin(new Insets(0, 0, 0, 0));
        this.copyButton.setToolTipText("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.copyButton.setIcon((Icon)ClientUtils.getIcon((String)"copy"));
        this.copyButton.setActionCommand("copy");
        this.copyButton.setMargin(new Insets(0, 0, 0, 0));
        this.cutButton.setToolTipText("\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c");
        this.cutButton.setIcon((Icon)ClientUtils.getIcon((String)"cut"));
        this.cutButton.setActionCommand("cut");
        this.cutButton.setMargin(new Insets(0, 0, 0, 0));
        this.printButton.setToolTipText("\u041f\u0435\u0447\u0430\u0442\u044c");
        this.printButton.setIcon((Icon)ClientUtils.getIcon((String)"print"));
        this.printButton.setActionCommand("print");
        this.printButton.setMargin(new Insets(0, 0, 0, 0));
        this.printButton.addActionListener(e -> this.printButton_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        panel.add((Component)this.commentFilter, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        jPanel8.add((Component)this.pasteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel8.add((Component)this.copyButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel8.add((Component)this.cutButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel8.add((Component)this.printButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel8.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel8.add((Component)this.findButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder((Border)new BGTitleBorder(" \u041f\u043e\u0438\u0441\u043a \u0430\u0434\u0440\u0435\u0441\u0430 "));
        jPanel3.add((Component)jPanel8, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jPanel5, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)panel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this.bGControlPanel_07, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 "));
        jPanel4.setPreferredSize(new Dimension(281, 164));
        jPanel4.add((Component)new JScrollPane((Component)((Object)this.sourceTree)), new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)jPanel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u043e\u0438\u0441\u043a\u0430 "));
        jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        jPanel2.add((Component)this.recordsCount, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        jPanel2.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        jPanel2.add((Component)new JScrollPane((Component)this.tableAddress), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPane(1, (Component)jPanel1, (Component)jPanel2), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("FindAddress");
        request.setModuleId(this.getModuleId());
        request.setPage(this.pagePanel);
        if (this.loadList) {
            this.sourceTree.init(this.module, this.getModuleId());
            this.sourceTree.setData();
            this.sourceTree.updateUI();
            this.loadList = false;
        }
        if (Utils.isBlankString((String)this.ifaces)) {
            long addr = this.ip.getIPValue();
            if (addr > 0L) {
                request.setAttribute("addr", addr);
                request.setAttribute("port", this.port.getText());
                request.setAttribute("mask", (String)this.mask.getSelectedItem());
            }
            request.setAttribute("date1", this.bGControlPanel_07.getDateString1());
            request.setAttribute("date2", this.bGControlPanel_07.getDateString2());
            request.setAttribute("comment", this.commentFilter.getText());
        } else {
            request.setAttribute("ifaces", this.ifaces);
        }
        this.setDocument(this.getDocument(request));
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element table = XMLUtils.getElement((Document)doc, (String)"table");
            this.tableAddress.updateData((Node)table);
            this.pagePanel.setPageInfo(table);
            this.recordsCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + table.getAttribute("recordCount"));
        }
    }

    void findButton_actionPerformed(ActionEvent e) {
        this.ifaces = this.sourceTree.getIfaces();
        this.setData();
    }

    void tableAddress_mouseClicked(MouseEvent e) {
        String tmp;
        int cid;
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (cid = Utils.parseInt((String)(tmp = ClientUtils.getRowId((BGTable)this.tableAddress)), (int)-1)) > 0) {
            BGClientBase.getFrame().getTabbedPane().addContractEditorTab(cid);
        }
    }

    void printButton_actionPerformed(ActionEvent e) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = pj.defaultPage();
        pf.setOrientation(1);
        Book bk = new Book();
        bk.append(this, pf);
        pj.setPageable(bk);
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        this.tableAddress.print(g);
        return 0;
    }
}

