/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.constructor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.modules.reports.client.constructor.FilterPanel;
import ru.bitel.bgbilling.modules.reports.client.include.FillableFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterCache;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterParameterName;
import ru.bitel.common.Utils;

public final class GenerateReportOptions {
    private String reportTitle;
    private String reportFileName;
    private String processingClass;
    private List<FilterPanel> filters;
    private Map<String, String> fields;
    private boolean needScroll;
    private boolean isNewReport;

    private GenerateReportOptions() {
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public String getProcessingClass() {
        return this.processingClass;
    }

    public List<FilterPanel> getFilters() {
        return this.filters;
    }

    public boolean isNeedScroll() {
        return this.needScroll;
    }

    public boolean isNewReport() {
        return this.isNewReport;
    }

    public static Builder builder() {
        return new GenerateReportOptions().new Builder();
    }

    public static XmlReportParser xmlParser(Element reportEl) {
        return new GenerateReportOptions().new XmlReportParser(reportEl);
    }

    public final class Builder {
        private GenerateReportOptions options = new GenerateReportOptions();

        private Builder() {
        }

        public GenerateReportOptions build() {
            return this.options;
        }

        public Builder setReportTitle(String title) {
            this.options.reportTitle = title;
            return this;
        }

        public Builder setReportFileName(String fileName) {
            this.options.reportFileName = fileName;
            return this;
        }

        public Builder setProcessingClass(String processingClass) {
            this.options.processingClass = processingClass;
            return this;
        }

        public Builder setFilters(List<FilterPanel> filters) {
            this.options.filters = filters;
            return this;
        }

        public Builder setFields(Map<String, String> fields) {
            this.options.fields = fields;
            return this;
        }

        public Builder setNeedScroll(boolean needScroll) {
            this.options.needScroll = needScroll;
            return this;
        }
    }

    public final class XmlReportParser {
        private Element reportEl;

        private XmlReportParser(Element reportEl) {
            this.reportEl = reportEl;
        }

        public List<FilterPanel> parseFilters() {
            ArrayList<FilterPanel> filters = new ArrayList<FilterPanel>();
            ReportFilterCache reportFilterCache = ReportFilterCache.getInstance();
            NodeList childs = this.reportEl.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node reportFilterNode = childs.item(i);
                ReportFilter reportFilter = reportFilterCache.getReportFilterByFilterName(reportFilterNode.getNodeName());
                if (reportFilter == null) continue;
                NodeList items = reportFilterNode.getChildNodes();
                for (Field parameterNameField : reportFilter.getClass().getDeclaredFields()) {
                    String nameAttr;
                    if (parameterNameField.getAnnotation(ReportFilterParameterName.class) == null || !Utils.notBlankString((String)(nameAttr = ((Element)reportFilterNode).getAttribute("name")))) continue;
                    try {
                        parameterNameField.setAccessible(true);
                        parameterNameField.set(reportFilter, nameAttr);
                        break;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                FilterPanel filterPanel = new FilterPanel(reportFilter);
                if (reportFilter instanceof FillableFilter) {
                    for (int j = 0; j < items.getLength(); ++j) {
                        Node itemNode = items.item(j);
                        if (!"item".equals(itemNode.getNodeName()) || itemNode.getNodeType() != 1) continue;
                        Element item = (Element)items.item(j);
                        filterPanel.addFillableParameter(item.getAttribute("id"), item.getAttribute("title"));
                    }
                }
                filters.add(filterPanel);
            }
            return filters;
        }

        public Map<String, String> parseFields() {
            HashMap<String, String> fields = new HashMap<String, String>();
            NodeList childs = this.reportEl.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!"fields".equals(node.getNodeName())) continue;
                NodeList reportFields = node.getChildNodes();
                for (int j = 0; j < reportFields.getLength(); ++j) {
                    Node n = reportFields.item(j);
                    if (!n.getNodeName().equals("item") || n.getNodeType() != 1) continue;
                    Element field = (Element)n;
                    String id = field.getAttribute("id");
                    String title = field.getAttribute("title");
                    if (!Utils.notBlankString((String)id) || !Utils.notBlankString((String)title)) continue;
                    fields.put(id, title);
                }
            }
            return fields;
        }

        public boolean parseScrollSetting() {
            return "true".equals(this.reportEl.getAttribute("scroll"));
        }
    }
}

