/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.TarifficationTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceHourSessionProcessor;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionAccount;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionAccountLogDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.event.LogProcessInterrupted;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;

public class SessionFlusher
implements Callable<Object> {
    private final VoiceHourSessionProcessor sessionProcessor;
    private final int index;
    private static final Logger logger = LogManager.getLogger();

    public SessionFlusher(VoiceHourSessionProcessor sessionProcessor, int index) {
        this.sessionProcessor = sessionProcessor;
        this.index = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        ServerContext workerContext = (ServerContext)ServerContext.get();
        int moduleId = workerContext.getModuleId();
        Date hour = this.sessionProcessor.getHour();
        try {
            Connection con = workerContext.getConnection();
            logger.debug("con.getAutoCommit() = " + con.getAutoCommit());
            Class<SessionFlusher> clazz = SessionFlusher.class;
            synchronized (SessionFlusher.class) {
                VoiceSessionLogDao.checkTables(con, moduleId, hour);
                // ** MonitorExit[var5_7] (shouldn't be in output)
                try (VoiceSessionLogDao voiceSessionDao = new VoiceSessionLogDao(con, moduleId, hour);
                     VoiceSessionAccountLogDao voiceSessionAccountDAO = new VoiceSessionAccountLogDao(con, moduleId, hour);){
                    TarifficationTask task;
                    while ((task = this.sessionProcessor.takeNextFlushTask(this.index)) != null) {
                        logger.trace("start flush(" + this.index + "): task " + task.getIndex() + ";" + task.getSessions().size() + " sessions");
                        logger.trace("first contractId = " + (Serializable)(task.getSessions().size() > 0 ? Integer.valueOf(task.getSessions().get(0).getContractId()) : "null"));
                        voiceSessionDao.insertSessions(task.getSessions().stream().map(s -> s.getSession()).collect(Collectors.toList()));
                        SessionFlusher.insertAccount(voiceSessionAccountDAO, task.getSessions());
                        logger.trace("end flush(" + this.index + "): task " + task.getIndex());
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            logger.error(this.getClass().getName() + " was interrupted", (Throwable)ex);
        }
        catch (Exception e) {
            logger.error("fatal error in  " + this.getClass().getName(), (Throwable)e);
            EventProcessor.getInstance().request((QueueEvent)new LogProcessInterrupted(moduleId, 0));
        }
        {
            return null;
        }
    }

    public static void insertAccount(VoiceSessionAccountLogDao voiceSessionAccountDao, List<VoiceSessionRuntime> sessions) throws BGException {
        ArrayList<VoiceSessionAccount> accounts = new ArrayList<VoiceSessionAccount>();
        for (VoiceSessionRuntime session : sessions) {
            accounts.addAll(session.getAccountAmountMap().entrySet().stream().map(e -> new VoiceSessionAccount(session.getSession(), ((Integer)e.getKey()).intValue(), ((SessionAccountAmount)e.getValue()).getAccount(), ((SessionAccountAmount)e.getValue()).getAmount())).collect(Collectors.toList()));
        }
        voiceSessionAccountDao.insertAccount(accounts);
    }
}

