/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDao;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNas;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasConnection;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CopyOnWriteSetMap;

public class VoiceSessionRuntimeMap
extends BGLogger {
    private Map<Long, VoiceSessionRuntime> sessionMap = new HashMap<Long, VoiceSessionRuntime>();
    private final CopyOnWriteSetMap<Integer, VoiceSessionRuntime> accountIdSet;
    private int moduleId;

    public VoiceSessionRuntimeMap(int moduleId) {
        this.moduleId = moduleId;
        this.accountIdSet = new CopyOnWriteSetMap(512, 2);
    }

    public void add(VoiceSessionRuntime runtime) {
        this.sessionMap.put(runtime.getSession().getId(), runtime);
        VoiceAbtractAccountRuntime<?> accountRuntime = runtime.getAccountRuntime();
        if (accountRuntime != null) {
            this.accountIdSet.add((Object)accountRuntime.getAccountId(), (Object)runtime);
        }
    }

    public VoiceSessionRuntime getBySessionId(long sessionId) {
        return this.sessionMap.get(sessionId);
    }

    public VoiceSessionRuntime removeSession(VoiceSessionRuntime session) {
        VoiceSessionRuntime result = null;
        if (session != null) {
            VoiceAbtractAccountRuntime<?> voiceAccount;
            VoiceSession voiceSession = session.getSession();
            if (voiceSession != null) {
                result = this.sessionMap.remove(voiceSession.getId());
            }
            if ((voiceAccount = session.getAccountRuntime()) != null) {
                this.accountIdSet.remove((Object)voiceAccount.getAccountId(), (Object)session);
            }
        }
        return result;
    }

    public Set<VoiceSessionRuntime> getByAccountId(int accountId) {
        Set<VoiceSessionRuntime> result = this.accountIdSet.get((Object)accountId);
        return result != null ? result : Collections.emptySet();
    }

    public void load(ConnectionSet connectionSet, VoiceAccountRuntimeMap voiceAccountRuntimeMap, NasList<VoiceNasConnection, VoiceNas> nasList) throws BGException {
        this.sessionMap.clear();
        try (VoiceSessionDao sessionDao = new VoiceSessionDao(connectionSet.getConnection(), this.moduleId);){
            List<VoiceSession> list = sessionDao.list();
            Map<Long, VoiceSession> sessionMap = list.stream().collect(Collectors.toMap(s -> s.getId(), s -> s));
            HashMap<Long, VoiceNasConnection> conMap = new HashMap<Long, VoiceNasConnection>();
            block9: for (VoiceSession s2 : list) {
                if (s2.getParentId() == 0L) {
                    this.getNasConnection(voiceAccountRuntimeMap, nasList, conMap, s2);
                    continue;
                }
                VoiceSession parent = sessionMap.get(s2.getParentId());
                VoiceNasConnection nasCon = this.getNasConnection(voiceAccountRuntimeMap, nasList, conMap, parent);
                VoiceSessionRuntime sessionRuntime = this.addSession(voiceAccountRuntimeMap, s2);
                switch (s2.getType()) {
                    case 1: {
                        nasCon.setOperSession(sessionRuntime);
                        continue block9;
                    }
                    case 2: {
                        nasCon.setAdditinalSession(sessionRuntime);
                        continue block9;
                    }
                }
                this.getLogger().error("unknown type" + s2.getType() + " for sessionId " + s2.getId());
            }
        }
    }

    private VoiceNasConnection getNasConnection(VoiceAccountRuntimeMap voiceAccountRuntimeMap, NasList<VoiceNasConnection, VoiceNas> nasList, Map<Long, VoiceNasConnection> conMap, VoiceSession s) {
        VoiceNasConnection nasCon = conMap.get(s.getId());
        if (nasCon == null) {
            VoiceNas nas = (VoiceNas)nasList.get(s.getDeviceId());
            if (nas == null) {
                this.getLogger().error("nas is null for  deviceId=" + s.getDeviceId());
                return null;
            }
            VoiceSessionRuntime sessionRuntime = this.addSession(voiceAccountRuntimeMap, s);
            nasCon = new VoiceNasConnection(sessionRuntime, nasList, s.getDeviceId());
            nas.setConnectionIfAbsent(nasCon);
            conMap.put(s.getId(), nasCon);
        }
        return nasCon;
    }

    private VoiceSessionRuntime addSession(VoiceAccountRuntimeMap voiceAccountRuntimeMap, VoiceSession voiceSession) {
        VoiceAccountRuntime voiceAccountRuntime = voiceAccountRuntimeMap.get(voiceSession.getAccountId());
        VoiceSessionRuntime sessionRuntime = new VoiceSessionRuntime(voiceSession, voiceAccountRuntime);
        this.add(sessionRuntime);
        return sessionRuntime;
    }
}

