/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Set;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.DealerDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionDealerInfo
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        int mid = this.getIntParameter("mid", -1);
        String selectedPaymentTypes = this.getParameter("selectedPaymentTypes", "");
        if (id < 0 || mid < 0) {
            this.buildPaymentTypeList(selectedPaymentTypes);
            return;
        }
        Element dealer = this.createElement(this.rootNode, "dealer");
        try (DealerDao dealerDao = new DealerDao(this.con, mid);){
            Dealer d = dealerDao.get(id);
            dealer.setAttribute("login", d.getLogin());
            dealer.setAttribute("card_percent", Utils.formatCost((float)d.getCardPercent()));
            dealer.setAttribute("pay_percent", Utils.formatCost((float)d.getPayPercent()));
            dealer.setAttribute("card_contract", d.getCardContract());
            dealer.setAttribute("error", String.valueOf(d.getError()));
            dealer.setAttribute("password", String.valueOf(d.getPassword() != null));
            Element selectedPayments = this.createElement(dealer, "selectedPayments");
            this.addSelectedPayments(d.getPt(), selectedPayments);
            this.buildPaymentTypeList(d.getPt());
            dealer.setAttribute("type", String.valueOf(d.getType()));
            dealer.setAttribute("title", d.getTitle());
            dealer.setAttribute("date1", TimeUtils.formatDate((Calendar)d.getDate1()));
            dealer.setAttribute("date2", TimeUtils.formatDate((Calendar)d.getDate2()));
            dealer.setAttribute("comment", d.getComment());
            dealer.setAttribute("params", String.valueOf(d.getParams()));
            dealer.setAttribute("findmodes", String.valueOf((d.getParams() & 0xFFFFFFF) > 0 ? (long)d.getParams() & 0x7FFFL : d.getFindmodes()));
            dealer.setAttribute("allowcontracts", String.valueOf((d.getParams() & 0xFFFFFFF) > 0 ? ((long)d.getParams() & 0x3FFF0000L) >> 16 : d.getAllowcontracts()));
            dealer.setAttribute("cansel_time", String.valueOf(d.getCanselTime()));
            dealer.setAttribute("st_request", String.valueOf(d.getStatRequest()));
            dealer.setAttribute("st_finded", String.valueOf(d.getStatFinded()));
            dealer.setAttribute("st_payed", String.valueOf(d.getStatPayed()));
            dealer.setAttribute("pay_comission_type", String.valueOf(d.getPayComissionType()));
            if (d.getContractId() > 0) {
                dealer.setAttribute("contract_id", String.valueOf(d.getContractId()));
                ContractUtils cu = new ContractUtils(this.con);
                String title = cu.getContractTitle(d.getContractId(), false, null);
                if (title != null) {
                    dealer.setAttribute("contract_title", title);
                }
            }
        }
    }

    protected void addSelectedPayments(String payments, Element elem) throws SQLException, BGException {
        if (payments != null && payments.matches("(\\s*\\d+\\s*,?)+")) {
            Set paymentsSet = Utils.toIntegerSet((String)payments);
            for (PaymentType type : new PaymentTypeDao(this.con).list(Integer.valueOf(1), Integer.valueOf(0))) {
                if (!paymentsSet.contains(type.getId())) continue;
                this.addListItem(elem, type.getId(), type.getTitle());
            }
        }
    }

    protected void buildPaymentTypeList(String selectedPaymentTypes) throws SQLException, BGException {
        Element payments = this.createElement(this.rootNode, "payments");
        this.addListItem(payments, "0", "---------");
        Set selectedPaymentTypesSet = Utils.toIntegerSet((String)selectedPaymentTypes);
        for (PaymentType type : new PaymentTypeDao(this.con).list(Integer.valueOf(1), Integer.valueOf(0))) {
            if (selectedPaymentTypesSet.contains(type.getId())) continue;
            this.addListItem(payments, type.getId(), type.getTitle());
        }
    }
}

