/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.plugins.im.client.PluginClientListener;
import ru.bitel.bgbilling.plugins.im.client.RosterTree;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNode;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeGroup;
import ru.bitel.bgbilling.plugins.im.common.IRosterItem;
import ru.bitel.bgbilling.plugins.im.common.RosterGroupItem;
import ru.bitel.bgbilling.plugins.im.common.RosterRootItem;

public class RosterTreeNodeRoot
extends RosterTreeNode {
    private String user;
    private int availableEntryCount;
    private int entryCount;
    private String name;

    public RosterTreeNodeRoot(RosterTree tree) {
        super(tree);
    }

    private String getCaption() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.user);
        if (this.availableEntryCount != -1 && this.entryCount != -1) {
            sb.append(" (").append(this.availableEntryCount).append("/").append(this.entryCount).append(")");
        }
        return sb.toString();
    }

    @Override
    public String getToolTipText() {
        StringBuilder text = new StringBuilder(128);
        text.append("<html>");
        text.append("<b>").append(this.getCaption()).append("</b>");
        if (this.name != null) {
            text.append("<br>").append(this.name);
        }
        if (this.user != null) {
            text.append("<br>").append("[").append(this.user).append("]");
        }
        text.append("</html>");
        return text.toString();
    }

    @Override
    public void loadNode(IRosterItem rosterI) {
        RosterRootItem roster = (RosterRootItem)rosterI;
        this.user = roster.user;
        this.name = roster.name;
        this.availableEntryCount = roster.AvailableEntryCount;
        this.entryCount = roster.EntryCount;
        for (RosterGroupItem groupEl : roster.getRosterGroupItems()) {
            this.insertGroupToRoot(groupEl);
        }
    }

    public void insertGroupToRoot(RosterGroupItem groupEl) {
        RosterTreeNodeGroup newGroupNode = new RosterTreeNodeGroup(this.tree);
        newGroupNode.loadNode((IRosterItem)groupEl);
        this.tree.getGroupMap().put(newGroupNode.getName(), newGroupNode);
        if (this.children == null) {
            this.add(newGroupNode);
        } else {
            ArrayList list = new ArrayList();
            this.children.forEach(e -> list.add(new RosterTreeNodeGroup((RosterTree)((Object)e))));
            int index = Collections.binarySearch(list, newGroupNode);
            this.insert(newGroupNode, index >= 0 ? index : -index - 1);
        }
    }

    public RosterTreeNodeGroup insertGroupToRoot(String groupName) {
        RosterTreeNodeGroup newGroupNode = new RosterTreeNodeGroup(this.tree);
        newGroupNode.setName(groupName);
        this.tree.getGroupMap().put(newGroupNode.getName(), newGroupNode);
        this.add(newGroupNode);
        return newGroupNode;
    }

    @Override
    public JLabel getView() {
        JLabel view = new JLabel();
        view.setPreferredSize(new Dimension(800, 20));
        if (this.user != null && PluginClientListener.imManager != null) {
            view.setIcon(PluginClientListener.statusIcon.get(PluginClientListener.imManager.getComboBoxStatus()));
            view.setText(this.getCaption());
        } else {
            view.setText("???");
        }
        return view;
    }

    public List<String> getExpandedGroupList() {
        ArrayList<String> r = new ArrayList<String>();
        Enumeration<TreeNode> e1 = this.children();
        while (e1.hasMoreElements()) {
            RosterTreeNode tmtn = (RosterTreeNode)e1.nextElement();
            if (!(tmtn instanceof RosterTreeNodeGroup) || this.tree.getViewableTree().isCollapsed(new TreePath(tmtn.getPath()))) continue;
            r.add(((RosterTreeNodeGroup)tmtn).getName());
        }
        return r;
    }

    public void setExpandedGroupList(List<String> save) {
        if (this.tree.getGroupMap() != null) {
            for (String i : save) {
                RosterTreeNode tn = this.tree.getGroupMap().get(i);
                if (tn == null) continue;
                this.tree.getViewableTree().expandPath(new TreePath(tn.getPath()));
            }
        }
    }

    @Override
    public String getJson() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        if (this.user != null) {
            sb.append("'user':'").append(this.user).append("',");
        }
        sb.append("'group':[");
        if (this.children != null) {
            for (Object g : this.children) {
                if (!(g instanceof RosterTreeNodeGroup)) continue;
                sb.append(((RosterTreeNodeGroup)g).getJson()).append(",");
            }
        }
        sb.append("]}");
        return sb.toString();
    }

    public int getAvailableEntryCount() {
        return this.availableEntryCount;
    }

    public void setAvailableEntryCount(int availableEntryCount) {
        this.availableEntryCount = availableEntryCount;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(int entryCount) {
        this.entryCount = entryCount;
    }

    @Override
    public String toString() {
        return "[root:user=" + this.user + ",name=" + this.name + "]";
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menuPopup = new JPopupMenu();
        JMenuItem addContactItem = new JMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442...");
        addContactItem.setActionCommand("addContactItem");
        addContactItem.addActionListener(e -> PluginClientListener.imManager.addContactDialog());
        menuPopup.add(addContactItem);
        return menuPopup;
    }
}

