<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:common="http://common.bitel.ru">
<xsl:import href="layout.xsl"/>

	<xsl:template name="title">
		<xsl:choose>
			<xsl:when test="data/@action = 'Vidimax' and data/@operation = 'activeTariff'">Текущий тариф</xsl:when>
			<xsl:when test="data/@action = 'Vidimax' and data/@operation = 'subscribe'">Подтвреждение изменения тарифа</xsl:when>
			<xsl:when test="data/@action = 'Vidimax' and data/@operation = 'subscribeConfirm'">Результат изменения тарифа</xsl:when>
			<xsl:otherwise>Список тарифов</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="/data">
		<xsl:choose>
			<xsl:when test="@action = 'Vidimax'">
				<xsl:choose>
				
					<xsl:when  test="@operation = 'subscribe'">
						<xsl:call-template name="subscribe" />
					</xsl:when>
					
					<xsl:when  test="@operation = 'subscribeConfirm'">
						<xsl:call-template name="subscribeResult" />
					</xsl:when>
					
					<xsl:when  test="@operation = 'activeTariff'">
						<xsl:call-template name="activeTariff" />
					</xsl:when>
					
					<xsl:otherwise>
						<xsl:call-template name="tariffList" />
					</xsl:otherwise>
					
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="subscribe">
		<xsl:choose>
			<xsl:when test="/data/common:result/attributes/item[@key='tariff_is_active']/value/text() != ''">
				<xsl:value-of select="/data/common:result/attributes/item[@key='tariff_is_active']/value/text()"/>
				<br/><br/>
				<xsl:call-template name="button">
					<xsl:with-param name="title" select="'Вернуться к списку тарифов'"/>
					<xsl:with-param name="onclick">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Vidimax&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			
			<xsl:otherwise>
				<p>Вы уверены, что хотите изменить текущий тарифный план на <b>"<xsl:value-of select="common:result/data/item/@name" />"</b>?</p>
				<table class="table800 left">
					<col width="200px"/>
					<col width=""/>
					
					<tbody style="vertical-align: top;">
						<tr>
							<td style="text-align: left; font-weight: bold;">Название тарифа</td>
							<td style="text-align: left; vertical-align: top;"><xsl:value-of select="common:result/data/item/@name" /></td>
						</tr>
						<tr>
							<td style="text-align: left; font-weight: bold;">Описание тарифа</td>
							<td style="text-align: left; vertical-align: top;">
								<xsl:value-of select="common:result/data/item/@description" />
							</td>
						</tr>
						<tr>
							<td style="text-align: left; font-weight: bold;">Абонентская плата</td>
							<td style="text-align: left; vertical-align: top;"><xsl:value-of select="common:result/data/item/@price" /></td>
						</tr>
					</tbody>
		 		</table>
		 		<br/>
		 		
		 		<form name="confirmation" action="{$WEBEXECUTER}" method="post">
					<xsl:call-template name="action"/>
					<input type="hidden" name="operation" value="subscribeConfirm" />
					<input type="hidden" name="tariffId">
						<xsl:attribute name="value"><xsl:value-of select="common:result/data/item/@id"/></xsl:attribute>
					</input>
				
			 		<xsl:call-template name="okCancel">
						<xsl:with-param name="title1" select="'Да, изменить тариф'"/>
						<xsl:with-param name="onclick1">document.forms['confirmation'].submit();</xsl:with-param>
						<xsl:with-param name="title2" select="'Нет, вернуться к списку тарифов'"/>
						<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Vidimax&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
					</xsl:call-template>
				</form>
				
			</xsl:otherwise>
		</xsl:choose>
		
		
	</xsl:template>
	
	<xsl:template name="activeTariff">	    
		<table class="table800 left">
			<col width="200px"/>
			<col width=""/>
			
			<tbody style="vertical-align: top;">
				<tr>
					<td style="text-align: left; font-weight: bold;">Название тарифа</td>
					<td style="text-align: left; vertical-align: top;"><xsl:value-of select="common:result/data/item/@name" /></td>
				</tr>
				<tr>
					<td style="text-align: left; font-weight: bold;">Описание тарифа</td>
					<td style="text-align: left; vertical-align: top;">
						<xsl:value-of select="common:result/data/item/@description" />
					</td>
				</tr>
				<tr>
					<td style="text-align: left; font-weight: bold;">Дата начала текущего расчетного периода</td>
					<td style="text-align: left; vertical-align: top;"><xsl:value-of select="common:result/data/item/@startCurrentPeriod" /></td>
				</tr>
				<tr>
					<td style="text-align: left; font-weight: bold;">Дата окончания текущего расчетного периода</td>
					<td style="text-align: left; vertical-align: top;"><xsl:value-of select="common:result/data/item/@stopCurrentPeriod" /></td>
				</tr>
				<tr>
					<td style="text-align: left; font-weight: bold;">Состояние подписки</td>
					<td style="text-align: left; vertical-align: top;"><xsl:value-of select="common:result/data/item/@state" /></td>
				</tr>
			</tbody>
 		</table>
 		<br/>
 		<xsl:call-template name="button">
			<xsl:with-param name="title" select="'К списку тарифов'"/>
			<xsl:with-param name="onclick">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Vidimax&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="subscribeResult">
		<xsl:call-template name="error"/>
		
		<xsl:choose>
			<xsl:when test="common:result/attributes/item[@key='subscribe_result']/value/text() = 'success'">Смена тарифа прошла успешно.</xsl:when>
			<xsl:otherwise>
				Ошибка при смене тарифа. Тариф не был изменен.<br/>
				<xsl:if test="common:result/attributes/item[@key='result_message']/value/text() != ''">
					Текст ошибки: <xsl:value-of select="common:result/attributes/item[@key='result_message']/value/text()"></xsl:value-of>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>	
		<br/><br/>
		<xsl:call-template name="button">
			<xsl:with-param name="title" select="'К списку тарифов'"/>
			<xsl:with-param name="onclick">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Vidimax&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>');</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="tariffList">
		<div class="report">
			<xsl:if test="common:result/data">
			<table class="table800">
				<thead>
				  <tr>
					<td>ID</td>
					<td>Название тарифа</td>
					<td>Описание тарифа</td>
					<td>Абонентская плата</td>
					<td></td>
	  			</tr>
	 			</thead>
	 			<tbody>
	  				<xsl:for-each select="common:result/data/item">
	  					<tr>
	  						<td>
	  							<xsl:value-of select="@id" />
	  						</td>
	  						<td>
	  							<xsl:value-of select="@name" />
	  						</td>
	  						<td>
	  							<xsl:value-of select="@description" />
	  						</td>
	  						<td>
	  							<xsl:value-of select="@price" />
	  						</td>
	  						<td>
	  							<xsl:variable name="activeTariffId">
									<xsl:value-of select="/data/common:result/attributes/item[@key='active_tariff_id']/value/text()"/>
								</xsl:variable>
								
	  							<xsl:choose>
	  								<xsl:when test="@id=$activeTariffId">
	  									текущий
	  									
	  									<xsl:variable name="activeTariffLink">
											<xsl:value-of select="$WEBEXECUTER"/>?action=Vidimax&#38;operation=activeTariff&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>
										</xsl:variable>
										
										(<a href="{$activeTariffLink}">подробнее</a>)
	  								</xsl:when>
	  								
	  								<xsl:otherwise>
	  									<xsl:variable name="subscribeLink">
			  								<xsl:value-of select="$WEBEXECUTER"/>?action=Vidimax&#38;operation=subscribe&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>&#38;id=<xsl:value-of select="@id" />
			  							</xsl:variable>
			  							<a href="{$subscribeLink}">подписаться</a>
	  								</xsl:otherwise>
	  							</xsl:choose>
	  						</td>
	  					</tr>
	  				</xsl:for-each>
	 			</tbody>
			</table>
			</xsl:if>
			
		</div>
	</xsl:template>

</xsl:stylesheet>