/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.common.dto;

import jakarta.activation.DataSource;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;

public class FileDto {
    private String contentType;
    private String fileName;
    private String data;
    private BGServerFile serverFile;

    @XmlAttribute
    public String getContentType() {
        return this.contentType;
    }

    @XmlAttribute
    public String getFileName() {
        return this.fileName;
    }

    @XmlElement
    public String getData() {
        return this.data;
    }

    @XmlElement
    public BGServerFile getServerFile() {
        return this.serverFile;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setServerFile(BGServerFile serverFile) {
        this.serverFile = serverFile;
    }

    public static FileDto fromDataSource(DataSource dataSource) throws BGException {
        if (dataSource == null) {
            return null;
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(dataSource.getInputStream().readAllBytes());
            outputStream.flush();
            FileDto fileDto = new FileDto();
            fileDto.setContentType(dataSource.getContentType());
            fileDto.setFileName(dataSource.getName());
            fileDto.setData(Base64.getEncoder().encodeToString(outputStream.toByteArray()));
            return fileDto;
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }
}

