/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.radius;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.processor.ipn.IPNSession;
import bitel.billing.server.radius.RadiusSetup;
import java.net.InetAddress;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNLogin;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNNas;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNNasConnection;
import ru.bitel.bgbilling.modules.ipn.server.radius.IPNRadiusSessionParams;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class IPNRadiusProcessor
extends RadiusProcessor<IPNNasConnection, IPNNas, IPNRadiusSessionParams> {
    private static final Logger log = LogManager.getLogger();
    private int moduleId;
    private static final Pattern patTT = Pattern.compile("\t\t");
    private static final Pattern patT = Pattern.compile("\t");

    public IPNRadiusProcessor(RadiusSetup setup, int moduleId) throws BGException {
        super((Setup)setup, "ipn", moduleId, (NasList)new IPNNasList());
        this.moduleId = moduleId;
        RadiusUtils.logEnable = false;
    }

    protected RadiusSession<IPNNas, IPNRadiusSessionParams> newRadiusSession(Connection con, IPNNas nas, RadiusPacket request, RadiusSession.State state) {
        RadiusAttribute.RadiusAttributeString userNameAttribute = (RadiusAttribute.RadiusAttributeString)request.getAttribute(-1, 1);
        String realm = null;
        if (userNameAttribute == null) {
            return null;
        }
        String userName = (String)userNameAttribute.getValue();
        int pos = (userName = userName.trim()).indexOf("@");
        realm = pos > 0 ? userName.substring(pos + 1) : "default";
        pos = (userName = Utils.deleteAfterDog((String)userName)).indexOf(92);
        if (pos >= 0) {
            userName = userName.substring(pos + 1);
        }
        userNameAttribute = userNameAttribute.clone();
        if (request.getAttribute(-1, 79) != null) {
            return new EAPSession(userName, userNameAttribute, (Object)new IPNRadiusSessionParams(realm));
        }
        return new RadiusSession(state != null ? state.state : null, userName, userNameAttribute, (Object)new IPNRadiusSessionParams(realm));
    }

    protected int authentication(RadiusListenerWorker<?> req, IPNNas nas, RadiusSession<IPNNas, IPNRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, ConnectionSet zzz, int logRecordId) {
        log.debug("Finding login..");
        IPNLogin login = nas.logins.get(session.userName);
        if (login == null) {
            log.debug("Login not found");
            return this.addReplyMessage(response, 14);
        }
        if (!RadiusUtils.checkPassword((Nas)nas, (String)login.passw, (RadiusAttributeSet)request, (RadiusAttributeSet)response, (byte[])nas.getSecret(), (byte[])request.getAuthenticator())) {
            log.debug("Login password error");
            return this.addReplyMessage(response, 2);
        }
        List<String[]> pairs = login.attrs.get(((IPNRadiusSessionParams)session.sessionParams).realm);
        if (pairs == null) {
            log.debug("Realm error");
            return this.addReplyMessage(response, -1);
        }
        for (String[] pair : pairs) {
            response.addAttribute(RadiusDictionary.newRadiusAttribute((String)pair[0], (String)pair[1]));
        }
        response.setCode((byte)2);
        nas.setConnection(new IPNNasConnection(new IPNSession(session.userName), (DefaultServerSetup)this.setup, this.nasList, nas.getId()), request, (Connection)null, (Connection)null);
        return 0;
    }

    protected int authorization(RadiusListenerWorker<?> req, IPNNas nas, RadiusSession<IPNNas, IPNRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet zzz, int logRecordId, ContractManager contrM, Contract contract, Object login, String userName) {
        throw new UnsupportedOperationException();
    }

    private int addReplyMessage(RadiusPacket response, int errorCode) {
        response.setCode((byte)3);
        response.setStringAttribute(-1, 18, String.valueOf(errorCode));
        return errorCode;
    }

    public String executeCommand(String command, String param) {
        if ("set".equals(command)) {
            return this.set(param);
        }
        if ("delete".equals(command)) {
            this.delete(param);
            return "ok\n";
        }
        if ("nas".equals(command)) {
            return this.nas(param);
        }
        if ("list".equals(command)) {
            return this.list(param);
        }
        return "";
    }

    private String set(String str) {
        HashMap<String, List<String[]>> attributes = new HashMap<String, List<String[]>>();
        String[] realms = patTT.split(str);
        String[] loginParam = patT.split(realms[0]);
        if (loginParam.length != 3 || loginParam[0].trim().length() == 0) {
            return "error\n";
        }
        String login = loginParam[1];
        for (int i = 1; i < realms.length; ++i) {
            String[] realmParam = patT.split(realms[i]);
            if (realmParam.length != 2) {
                return "error\n";
            }
            ArrayList<String[]> ras = new ArrayList<String[]>();
            StringTokenizer st = new StringTokenizer(realmParam[1], ";");
            while (st.hasMoreTokens()) {
                String attrAndValue = st.nextToken();
                int pos = attrAndValue.indexOf("=");
                if (pos <= 0) continue;
                String attr = attrAndValue.substring(0, pos);
                String value = attrAndValue.substring(pos + 1);
                ras.add(new String[]{attr, value});
            }
            attributes.put(realmParam[0], ras);
        }
        IPNNas nas = (IPNNas)this.nasList.get(loginParam[0]);
        if (nas != null) {
            nas.set(login, new IPNLogin(login, loginParam[2], attributes));
            return "ok\n";
        }
        return "error\n";
    }

    private String list(String nasid) {
        IPNNas nas = (IPNNas)this.nasList.get(nasid);
        if (nas != null) {
            StringBuilder result = new StringBuilder(1024);
            for (Map.Entry<String, IPNLogin> login : nas.logins.entrySet()) {
                result.append(login.getKey());
                for (Map.Entry<String, List<String[]>> realm : login.getValue().attrs.entrySet()) {
                    result.append("\t\t");
                    result.append(realm.getKey());
                    result.append("\t");
                    boolean was = false;
                    for (String[] attr : realm.getValue()) {
                        if (!was) {
                            was = true;
                        }
                        result.append(attr[0]);
                        result.append("=");
                        result.append(attr[1]);
                        result.append(";");
                    }
                    if (!was) continue;
                    result.setLength(result.length() - 1);
                }
                result.append("\n");
            }
            result.append(".\n");
            return result.toString();
        }
        return ".\n";
    }

    private void delete(String nasId_login) {
        String[] param = patT.split(nasId_login);
        if (param.length == 2) {
            IPNNas nas;
            if (log.isDebugEnabled()) {
                log.debug("delete " + param[1]);
            }
            if ((nas = (IPNNas)this.nasList.get(param[0])) != null) {
                nas.killByLoginName(param[1]);
            }
        }
    }

    public synchronized void setNAS(DefaultServerSetup setup, int moduleId, String nasIP, String nasId, byte[] secret, String inspClass, String configString) {
        try {
            InetAddress nasIPAddress = InetAddress.getByName(nasIP);
            if (Utils.notBlankString((String)inspClass)) {
                configString = "nas.inspector.class=" + inspClass + "\n" + (String)configString;
            }
            this.nasList.setNas(setup, moduleId, (RadiusProcessor)this, Utils.parseInt((String)nasId), nasIPAddress, nasId, secret, 0, (String)configString, "", new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String nas(String param) {
        String[] params;
        if (log.isDebugEnabled()) {
            log.debug(param);
        }
        if ((params = patT.split(param, 5)).length >= 4) {
            this.setNAS((DefaultServerSetup)this.setup, this.moduleId, params[1], params[0], params[2].getBytes(), params[3], params.length > 4 ? params[4].replaceAll("\t", "\n") : "");
            return "ok\n";
        }
        if (params.length == 3) {
            this.setNAS((DefaultServerSetup)this.setup, this.moduleId, params[1], params[0], params[2].getBytes(), null, "");
            return "ok\n";
        }
        return "error\n";
    }

    public String getStatus() {
        StringBuffer report = new StringBuffer();
        VersionInfo vi = VersionInfo.getVersionInfo((String)"ipn");
        report.append("version ");
        report.append(vi.getVersionString());
        report.append("\n");
        return report.toString();
    }

    protected void reloadNasList() {
    }

    static class IPNNasList
    extends NasList<IPNNasConnection, IPNNas> {
        IPNNasList() {
        }

        protected IPNNas newNas(DefaultServerSetup setup, int moduleId, RadiusProcessor<IPNNasConnection, IPNNas, ?> processor, int id, IPNNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, IPNNasConnection> connections, String script, NasConnectionInspector inspector, Object ... params) {
            return new IPNNas(setup, moduleId, (IPNRadiusProcessor)processor, id, oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, script, inspector);
        }

        public synchronized void load(DefaultServerSetup setup, RadiusProcessor<IPNNasConnection, IPNNas, ?> processor, Connection nil, int mid) {
        }
    }
}

