<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:common="http://common.bitel.ru">

<xsl:import href="layout.xsl"/>


<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'ShowStat'">IP-статистика</xsl:when>
	<xsl:when test="data/@action = 'GateControl'">Управление шлюзом</xsl:when>
	<xsl:when test="data/@action = 'DispatchTrafficIpn'">Рассылка трафика Ipn</xsl:when>
	<xsl:when test="data/@action = 'GateRuleControl'">Управление правилами шлюза</xsl:when>
	
</xsl:choose>
</xsl:template>


<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@action = 'ShowStat'">
		<xsl:call-template name="ShowStat"/>
	</xsl:when>
	<xsl:when test="@action = 'GateControl'">
	 	<xsl:call-template name="GateControl"/>
	</xsl:when>
	<xsl:when test="@action = 'DispatchTrafficIpn'">
	 	<xsl:call-template name="DispatchTrafficIpn"/>
	</xsl:when>	
	<xsl:when test="@action = 'GateRuleControl'">
	 	<xsl:call-template name="GateRuleControl"/>
	</xsl:when>
</xsl:choose>
</xsl:template>


<xsl:template name="head">
<xsl:text disable-output-escaping="yes">
	<![CDATA[    
    <style TYPE="text/css" TITLE="ipn style">
        <!-- 
        
#idIpnStatColumnsTable {
	border-collapse: collapse;
	margin-bottom: 20px;
	height: 100px;
}

#idIpnStatColumnsTable tbody td {
	vertical-align: bottom ! important;
	text-align: center;
	padding-left: 2px;
	height: 100%;
	width: 15px;
}

#idIpnStatColumnsTable tbody td div {
	vertical-align: bottom ! important;
	font-size: 0px;
	line-height: 0px;
	padding: 0px;
	margin: 0px;
}

#idIpnStatColumnsTable tfoot td {
	text-align: center;
	font-family: Verdana, Arial, Helvetica, sans-serif;
	font-size: 10px;
	padding: 1px;
}

#idIpnStatColumnsTable tbody div {
	text-align: center;
	background-color: #0056a2;
	width: 90%;
}

#idIpnStatTable {
	width: 600px;
}

#idIpnStatTable td {
	text-align: center;
	font-size: 11px;
	font-weight: normal;
}

#idIpnStatTable th {
	background: #3077bb;
	background-color: #3077bb;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	color: #FFFFFF;
	text-align: center;
	font-weight: bold;
}     
/*перенесено из основного style.css:*/ 

table.table {
	background-color: #0056a2;
}  

table.table thead tr td,
table.table tbody tr th,
table.table tbody tr td {
	padding: 5px;
}

table.table tfoot tr td {
	padding: 5px;
}

table.table thead td,
table.table tfoot th {
	background-color: #3077bb;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	color: #FFFFFF;
	text-align: center;
}

table.table thead th {
	background-color: #FFFFFF;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	/*color: #FFFFFF;*/
	text-align: center;
	font-weight: normal;
	white-space: nowrap;
/*
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	color: #000000;
	background-color: #FFFFFF;
*/
}

table.table td {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	color: #000000;
	background-color: #FFFFFF;
}

table.table tfoot tr td {
	font-weight: bold;
}

@media print
{
table.table thead tr td,
table.table tbody tr th,
table.table tbody tr td{
	padding: 1px;
	font-size: 10pt;
}
}
        -->
    </style>    
    ]]>
</xsl:text>
</xsl:template>


<!-- свойства рассылки трафика -->
<xsl:template name="DispatchTrafficIpn">
	<form action="{$WEBEXECUTER}" method="post">	
	<xsl:call-template name="action"/>
	<input type="hidden" name="id"><xsl:attribute name="value"><xsl:value-of select="dispatch/@id"/></xsl:attribute></input>
	<input type="hidden" name="type"><xsl:attribute name="value"><xsl:value-of select="dispatch/@type"/></xsl:attribute></input>
	<input type="hidden" name="command" value="save"/>
	   	<div class="report">
       <table cellspacing='1' class="table800">
	   <thead>
         <tr>
           <td>Поле</td>
           <td>Данные</td>
           <td>Комментарий</td>
          </tr>
		 </thead>
		 <tbody>
          <tr>
            <td>Название:</td>
            <td><input type="text" name="title" size="32">
              <xsl:attribute name="value">
                <xsl:value-of select="dispatch/@title"/>
              </xsl:attribute>
              </input>
            </td>
            <td><em class="comment">Название вашей рассылки, например 'Ежедневная рассылка баланса'.
              Это название будет указано в теле письма.</em></td>
          </tr>
          <tr>
            <td>Адреса:</td>
            <td><textarea name="mails" rows="4" cols="25">
                <xsl:for-each select="dispatch/mail">
                  <xsl:value-of select="@value"/>
                  <xsl:if test="position() != last()">
                    <xsl:value-of select="'	
					'"/>
                  </xsl:if>
                </xsl:for-each>
              </textarea>
            </td>
            <td><em class="comment">Перечень адресов на которые будут приходить данная рассылка.
              Каждый адрес с новой строки.</em></td>
          </tr>
          <tr>
            <td>Статус:</td>
            <td><select name="status">
                <option value="0">неактивна</option>
                <option value="1">
                  <xsl:if test="dispatch/@status='1'">
                    <xsl:attribute name="selected">1</xsl:attribute>
                  </xsl:if>
                  активна
                </option>
              </select>
            </td>
            <td><em class="comment">Рассылка приходит только если ее статус активен.</em></td>
          </tr>
          <tr>
            <td>Дни недели ( 1-7 ):</td>
            <td class="tt"><input type="text" name="dw">
              <xsl:attribute name="value">
                <xsl:value-of select="dispatch/@dw"/>
              </xsl:attribute>
              </input>
            </td>
            <td><em class="comment">Дни недели, например 1 - 7 ( каждый день ),
            1, 2 ( понедельник, вторник ) в которые вам будет высылаться рассылка.</em>
            </td>
          </tr>
          </tbody>
		  <tfoot>
          <tr>
            <td colspan="3">
			<xsl:call-template name="okCancel">
				<xsl:with-param name="title1" select="'Сохранить'"/>
				<xsl:with-param name="onclick2">window.location.replace( '<xsl:value-of select="$WEBEXECUTER"/>?action=Subscription&#38;mid=contract&#38;module=contract' );</xsl:with-param>
			</xsl:call-template>	
            </td>
          </tr>
		  </tfoot>
        </table>
      </div>	
</form>		
</xsl:template>


<xsl:template name="ShowStat">
	<form method='get' action='{$WEBEXECUTER}'>
	<xsl:call-template name="action"/>	
	<xsl:call-template name="error"/>	
	<table class="filter" cellpadding="0" cellspacing="0">
	<tr>
		<td colspan="2">
		<table>
			<tr>
				<td>
					<table>
					<tr>
							<td>Ед. измерения </td>
					  		<td>
									<select class="gradbtn " name='unit'>
										<xsl:call-template name="unit_list"/>
								</select>
							</td>
					</tr>
					</table>
				</td>
				<td>
					<xsl:call-template name="dayFilterForm"/>
				</td>
			</tr>
		</table>
		</td>
	</tr>
	<tr>
		<td>Услуги</td>
		<td>Адреса</td>
	</tr>
	<tr>
		<td>
			<select size='10' name='services' multiple='1'>
				  <xsl:for-each select="services/service">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
						<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
						<xsl:value-of select="@title"/>
					</option>
				  </xsl:for-each>
			</select>
		</td>
		<td>
			<select size='10' name='addreses' multiple='1'>
				<xsl:for-each select="addreses/address">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
						<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
						<xsl:value-of select="@title"/>
					</option>
				</xsl:for-each>
			</select>
		</td>
	</tr>
	<tr>
		<td colspan="2">
			<em class='comment'>Для выделения сразу нескольких услуг/адресов держите нажатой клавишу 'Ctrl'</em>
		</td>
	</tr>
	</table>
	
	
	<!-- столбики значений -->
	<table border='0' id="idIpnStatColumnsTable">
	<tbody>
		<tr>
			<xsl:for-each select="labels/label">
				<xsl:variable name="id" select="@id"/>
				<xsl:variable name="value" select="/data/stat/item[ @id = $id ]/@value"/>
				<xsl:variable name="val" select="round($value * 100 div /data/stat/@max)"/>
				
				<td>
					<xsl:if test="$value">
					<xsl:variable name="title" select="format-number( $value, '### ### ### ##0', 'summa')"/>
					<xsl:attribute name="title"><xsl:value-of select="$title"/></xsl:attribute>
					<div>
					<xsl:attribute name="style">height:<xsl:value-of select="format-number( $value * 100 div /data/stat/@max, '### ### ### ##0', 'summa')"/>px</xsl:attribute><xsl:attribute name="title"><xsl:value-of select="$title"/></xsl:attribute></div></xsl:if>
				</td>
			</xsl:for-each>
		</tr>
	</tbody>
	<tfoot>
		<tr>
		<xsl:for-each select="labels/label">
			<td><xsl:value-of select="@text"/></td>
		</xsl:for-each>
		</tr>
	</tfoot>
	</table>
	
	<xsl:variable name="unit" select="/data/unit/@unit"/>
	<!-- нижняя табличка -->
		<strong>Итого: <xsl:value-of select="format-number( stat/@all div $unit , '### ### ### ##0.#', 'summa')"/>
		&#160;
		<xsl:call-template name="unit_title"> 
	 		<xsl:with-param name="unit" select="$unit"/>
	 	</xsl:call-template>
		
		</strong>
	<!--  -->	
	
	<table id="idIpnStatTable" cellspacing="1" class="table">
	<tbody>

	 <xsl:call-template name="addStatRow"> 
	 	<xsl:with-param name="from_pos" select="0"/>
	 	<xsl:with-param name="to_pos" select="7"/>
	 	<xsl:with-param name="unit" select="$unit"/>
	 </xsl:call-template>
		 
	<xsl:call-template name="addStatRow"> 
	 	<xsl:with-param name="from_pos" select="6"/>
	 	<xsl:with-param name="to_pos" select="13"/>
	 	<xsl:with-param name="unit" select="$unit"/>
	 </xsl:call-template>
				 
	 <xsl:call-template name="addStatRow"> 
	 	<xsl:with-param name="from_pos" select="12"/>
	 	<xsl:with-param name="to_pos" select="19"/>
	 	<xsl:with-param name="unit" select="$unit"/>
	 </xsl:call-template>
		 
	 <xsl:call-template name="addStatRow"> 
	 	<xsl:with-param name="from_pos" select="18"/>
	 	<xsl:with-param name="to_pos" select="25"/>
	 	<xsl:with-param name="unit" select="$unit"/>
	 </xsl:call-template>
				 
	 <xsl:call-template name="addStatRow"> 
	 	<xsl:with-param name="from_pos" select="24"/>
	 	<xsl:with-param name="to_pos" select="31"/>
	 	<xsl:with-param name="unit" select="$unit"/>
	 </xsl:call-template>

	<xsl:for-each select="labels/label">
    	<xsl:if test='position() = 31'>
		<tr>
    		<xsl:variable name="value" select="/data/stat/item[@id = '31']/@value"/>
    		<td colspan='3'><xsl:value-of select="@text"/></td>
    		<td colspan='3'>
    			<xsl:if test="$value"><xsl:value-of select="format-number( $value div $unit, '### ### ### ##0.0', 'summa')"/></xsl:if>
				<xsl:if test="not( $value )">0</xsl:if>
			</td>   
		</tr> 			
    	</xsl:if>
    </xsl:for-each>
      
	 </tbody>
	</table>	
	
</form>

<br />
<xsl:choose>
	<xsl:when test="createDetail/@created='1'">
	<table cellspacing="0" class="filter">
		<tr>
			<td>Отправка детализации поставлена в очередь.</td>
		</tr>
	</table>
	</xsl:when>
	<xsl:when test="date/@day='0'">
	<table cellspacing="0" class="filter">
		<tr>
			<td>Выберите день для получения детализации.</td>
		</tr>
	</table>
	</xsl:when>
	<xsl:otherwise>
		<form method='post' action='{$WEBEXECUTER}'>
		<xsl:call-template name="action"/>
		<input type="hidden" name="createDetail" value="1"/>
		<div style="display:none">
		<xsl:call-template name="dayFilterForm"/>
			<select size='10' name='services' multiple='1'>
				  <xsl:for-each select="services/service">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
						<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
						<xsl:value-of select="@title"/>
					</option>
				  </xsl:for-each>
			</select>
			<select size='10' name='addreses' multiple='1'>
				<xsl:for-each select="addreses/address">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
						<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
						<xsl:value-of select="@title"/>
					</option>
				</xsl:for-each>
			</select>
		</div>
		
		<table cellspacing="0" class="filter">
		<tr>
			<td colspan="2">Выслать детализацию для адресов:
			
				<select name='address_id' style="margin-right:0px;">
					<xsl:for-each select="addreses/address">
						<option>
							<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
							<xsl:if test="@selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
							<xsl:value-of select="@title"/>
						</option>
					</xsl:for-each>
				</select>
			</td>
		</tr>
		<tr>
			<td>за час:
				<input type="text" name="hour" size="4" ></input>
			на email:
				<input type="text" name="mail" size="30" ></input>
			</td>
			<td>
				<xsl:call-template name="submit">
					<xsl:with-param name="title">Выслать</xsl:with-param>
				</xsl:call-template>
			</td>
		</tr>
		</table>
		
		</form>
	</xsl:otherwise>
</xsl:choose>
	
</xsl:template>


<xsl:template name="GateControl">
	<form method='post' action='{$WEBEXECUTER}'>
	<xsl:call-template name="action"/>

		
	<xsl:if test="gate/@status = 2">
		<xsl:call-template name="error">
			<xsl:with-param name="text">
				Сумму долга смотрите в разделе "Просмотр баланса"
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<table border='0' cellspacing='0' class="filter">
	  <tr>
		<td nowrap='1'>Текущее состояние шлюза:</td>
		<td>
			<select name='status'>
			<xsl:choose>
				<xsl:when test="gate/@status &lt; 2">
					<option value='0'><xsl:if test="gate/@status = '0'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>открыт</option>
					<option value='1'><xsl:if test="gate/@status = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>закрыт</option>
				</xsl:when>
				<xsl:otherwise>
					<option value='2'>заблокирован</option>
				</xsl:otherwise>
			</xsl:choose>
			</select>
		</td>
		<td>
			<xsl:call-template name="submit"/>
		</td>
	 </tr>
	</table>
	
	<div class="report">
	<table cellspacing='1' class="table800">
	<thead>
	  <tr>
		<td nowrap='1'>Дата и время</td>
		<td>Действие</td>
		<td>Исполнитель</td>
		<td>Комментарий</td>
	  </tr>
	</thead>
	<tbody>
	<xsl:for-each select="gate/row">
		<xsl:if test="position() &lt; 11">
		<tr>
			<td><xsl:value-of select="@dt"/></td>
			<td>
			<xsl:choose>
				<xsl:when test="@action = 0">открыт</xsl:when>
				<xsl:when test="@action = 1">закрыт</xsl:when>
				<xsl:when test="@action = 2">заблокирован</xsl:when>
				<xsl:when test="@action = 3">удален</xsl:when>
				<xsl:when test="@action = 4">жестко блокирован</xsl:when>
				<xsl:otherwise>???</xsl:otherwise>
			</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="@uid = -1">клиент</xsl:when>
					<xsl:when test="@uid = 0">сервер</xsl:when>
					<xsl:when test="@uid &gt; 0">админ.</xsl:when>
					<xsl:otherwise>???</xsl:otherwise>
				</xsl:choose>
			</td>
			<td><xsl:value-of select="@comment"/></td>
		</tr>
		</xsl:if>
	</xsl:for-each>
	</tbody>
	</table>
	</div>
	</form>
</xsl:template>



<xsl:template name="GateRuleControl">
	<form method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<xsl:call-template name="error"	/>

		<xsl:if test="@status = 'ok'"><div class="alert alert-primary">Изменение сохранено!</div></xsl:if>
		<input type="hidden" name="save" value="save"/>
		<div class="report">
			<table cellspacing="1">
			<thead>
				<tr>
    				<td nowrap="1">Шлюз</td>
    				<td>Тип правила</td>
				</tr>
			</thead>
			<tbody>
				
				<xsl:for-each select="gates/data/item/data">				
				
				<tr>
					<td><xsl:value-of select="item[@key='id']/value"/> -<xsl:value-of select="item[@key='title']/value"/> </td>	
					<td>
							 
						<select>
							<xsl:attribute name="name">gate_<xsl:value-of select="item[@key='id']/value"/></xsl:attribute>
							
							<xsl:variable name = "ruleTypeId" select = "item[@key='ruleTypeId']/value" />
							
								<xsl:for-each select="item[@key='list']/value/item">						 
							 						 
							 		<option>
							 	 		<xsl:if test="data/item[@key='id']/value=$ruleTypeId"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
							 	 		<xsl:attribute name="value"><xsl:value-of select="data/item[@key='id']/value"/></xsl:attribute>
							 	 		<xsl:value-of select="data/item[@key='title']/value"/>	
							 		</option>
							 	</xsl:for-each>						 
						</select>
						
					</td>		
				</tr>
				</xsl:for-each>
				<tr>
					<td colspan="3">
						<xsl:call-template name="submit">
							<xsl:with-param name="title" select="'Сменить'"/>
							<xsl:with-param name="align" select="'right'"/>
						</xsl:call-template>
					</td>
				</tr>
			</tbody>
			</table>		
		</div>
	</form>
</xsl:template>

<!-- добавление строки в таблицу наработки -->
<xsl:template name="addStatRow">
	<xsl:param name="to_pos"/>
	<xsl:param name="from_pos"/>
	<xsl:param name="unit"/>
	<tr>
		<xsl:for-each select="labels/label">
			<xsl:if test='position() &lt; $to_pos and position() &gt; $from_pos'>
				<td><xsl:value-of select="@text"/></td>
			</xsl:if>
		</xsl:for-each>
	</tr>
	<tr>
		<xsl:for-each select="labels/label">	
			<xsl:if test='position() &lt; $to_pos and position() &gt; $from_pos'>						
				<xsl:variable name="id" select="@id"/>
				<xsl:variable name="value" select="/data/stat/item[@id = $id]/@value"/>
				<td>
					<xsl:if test="$value"><xsl:value-of select="format-number( $value div $unit, '### ### ### ##0.0', 'summa')"/></xsl:if>
					<xsl:if test="not( $value )">0</xsl:if>
				</td>
			</xsl:if>
		</xsl:for-each>
	</tr>
</xsl:template>

</xsl:stylesheet>