/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common.table;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.BGTableColumn;
import bitel.billing.module.common.table.SortTableHeaderRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.common.XMLUtils;

public class BGSortableTable
extends BGTable {
    protected volatile Vector<ActionListener> sortListeners = new Vector();

    @Override
    protected void setSorting(NodeList list) {
        if (this.rowSorter != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element columnElement = (Element)list.item(i);
                String orderName = XMLUtils.getAttribute(columnElement, "ordername", null);
                if (orderName == null) {
                    this.rowSorter.setSortable(i, false);
                    continue;
                }
                this.rowSorter.setComparator(i, this.getComparator(null));
                SortTableHeaderRenderer renderer = new SortTableHeaderRenderer();
                renderer.setFont(this.tableHeader.getFont().deriveFont(1));
                this.columnModel.getColumn(i).setHeaderRenderer(renderer);
                BGTableColumn column = (BGTableColumn)this.columnModel.getColumn(i).getIdentifier();
                column.setColumnOrderName(orderName);
            }
            this.tableHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        int column = BGSortableTable.this.tableHeader.columnAtPoint(e.getPoint());
                        if (!BGSortableTable.this.rowSorter.isSortable(column)) {
                            return;
                        }
                        if (BGSortableTable.this.lastClickedColumn == -1 || BGSortableTable.this.lastClickedColumn != column) {
                            BGSortableTable.this.sortClicks = -1;
                            BGSortableTable.this.rowSorter.toggleSortOrder(column);
                        }
                        BGSortableTable.this.lastClickedColumn = column;
                        if (BGSortableTable.this.sortClicks == 2) {
                            RowSorter.SortKey sk = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
                            sortKeys.add(sk);
                            BGSortableTable.this.rowSorter.setSortKeys(sortKeys);
                            BGSortableTable.this.sortClicks = 0;
                            return;
                        }
                        if (BGSortableTable.this.sortClicks == 1) {
                            BGSortableTable.this.rowSorter.setSortKeys(null);
                        }
                        ++BGSortableTable.this.sortClicks;
                        BGSortableTable.this.fireSortEvent(new ActionEvent(null, 0, "sorted"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public String getSortColumnName() {
        List<RowSorter.SortKey> sortKeys = this.rowSorter.getSortKeys();
        if (sortKeys != null && sortKeys.size() > 0) {
            return ((BGTableColumn)this.columnModel.getColumn(sortKeys.get(0).getColumn()).getIdentifier()).getColumnOrderName();
        }
        return "";
    }

    @Override
    protected Comparator<?> getComparator(String type) {
        Comparator<String> fakeComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return 0;
            }
        };
        return fakeComparator;
    }

    public synchronized void addSortListener(ActionListener l) {
        this.sortListeners.add(l);
    }

    public synchronized void removeSortListener(ActionListener l) {
        this.sortListeners.remove(l);
    }

    protected void fireSortEvent(ActionEvent sortEvent) {
        for (ActionListener l : this.sortListeners) {
            l.actionPerformed(sortEvent);
        }
    }
}

