/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.common.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.kernel.tariff.common.event.TariffPlanModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.IdTitle;

@DirectoryItem(serviceClass=TariffService.class, eventClass=TariffPlanModifiedEvent.class)
public class TariffPlan
extends IdTitle
implements Serializable {
    private String comment;
    private String config = "";
    private Preferences configMap;
    private String description;
    protected List<Integer> filterContractLabel = new ArrayList<Integer>();
    protected int filterFace;
    protected String filterMask;
    private String titleWeb = null;
    protected boolean used;
    protected boolean useTitleInWeb = true;

    public String getComment() {
        return this.comment;
    }

    public String getConfig() {
        return this.config;
    }

    public Preferences getConfigPreferences() {
        if (this.configMap == null) {
            this.configMap = new Preferences(this.config, "\n");
        }
        return this.configMap;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Integer> getFilterContractLabelIds() {
        return this.filterContractLabel;
    }

    public int getFilterFace() {
        return this.filterFace;
    }

    public String getFilterMask() {
        return this.filterMask;
    }

    public String getTitleWeb() {
        return this.titleWeb;
    }

    public boolean isUsed() {
        return this.used;
    }

    public boolean isUseTitleInWeb() {
        return this.useTitleInWeb;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setConfig(String config) {
        this.config = config == null ? "" : config;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFilterContractLabelIds(List<Integer> filterContractLabel) {
        this.filterContractLabel = filterContractLabel;
    }

    public void setFilterFace(int filterFace) {
        this.filterFace = filterFace;
    }

    public void setFilterMask(String filterMask) {
        this.filterMask = filterMask;
    }

    public void setTitleWeb(String titleWeb) {
        this.titleWeb = titleWeb;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public void setUseTitleInWeb(boolean useTitleInWeb) {
        this.useTitleInWeb = useTitleInWeb;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TariffPlan tariffPlan = new TariffPlan();

        private Builder() {
        }

        public Builder setId(int id) {
            this.tariffPlan.id = id;
            return this;
        }

        public Builder setTitle(String title) {
            this.tariffPlan.title = title;
            return this;
        }

        public Builder setComment(String comment) {
            this.tariffPlan.comment = comment;
            return this;
        }

        public Builder setConfig(String config) {
            this.tariffPlan.config = config == null ? "" : config;
            return this;
        }

        public Builder setDescription(String description) {
            this.tariffPlan.description = description;
            return this;
        }

        public Builder setFilterContractLabelIds(List<Integer> filterContractLabel) {
            this.tariffPlan.filterContractLabel = filterContractLabel;
            return this;
        }

        public Builder setFilterFace(int filterFace) {
            this.tariffPlan.filterFace = filterFace;
            return this;
        }

        public Builder setFilterMask(String filterMask) {
            this.tariffPlan.filterMask = filterMask;
            return this;
        }

        public Builder setTitleWeb(String titleWeb) {
            this.tariffPlan.titleWeb = titleWeb;
            return this;
        }

        public Builder setUsed(boolean used) {
            this.tariffPlan.used = used;
            return this;
        }

        public Builder setUseTitleInWeb(boolean useTitleInWeb) {
            this.tariffPlan.useTitleInWeb = useTitleInWeb;
            return this;
        }

        public TariffPlan build() {
            try {
                TariffPlan tariffPlan = this.tariffPlan;
                return tariffPlan;
            }
            finally {
                this.tariffPlan = null;
            }
        }
    }
}

