/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.service.EntityService;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;

public class TvAccountSpecPanel
extends BGUPanel {
    private TvDeviceService tvDeviceService;
    private TvAccountService tvAccountService;
    private TvAccountSpecTableModel model = new TvAccountSpecTableModel();

    public TvAccountSpecPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        BGEditor editor = new BGEditor();
        editor.setVisible(false);
        editor.addForm((JComponent)((Object)new TvAccountSpecForm()));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), "Center");
        this.add((Component)editor, "South");
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)editor);
    }

    private TvDeviceService getTvDeviceService() {
        if (this.tvDeviceService == null) {
            this.tvDeviceService = (TvDeviceService)((ClientContext)this.getContext()).getPort(TvDeviceService.class);
        }
        return this.tvDeviceService;
    }

    private TvAccountService getTvAccountService() {
        if (this.tvAccountService == null) {
            this.tvAccountService = (TvAccountService)((ClientContext)this.getContext()).getPort(TvAccountService.class);
        }
        return this.tvAccountService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(this.getTvAccountService().tvAccountSpecList())));
    }

    private JPanel panelWrap(JComponent panel) {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return result;
    }

    private class TvAccountSpecTableModel
    extends BGTableModel<TvAccountSpec> {
        public TvAccountSpecTableModel() {
            super(TvAccountSpecTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class TvAccountSpecForm
    extends BGUPanel {
        private BGTextField title;
        private BGUCheckList<IdTitle> deviceType;
        private BGUCheckList<IdTitle> childrenType;
        private BGUCheckTree<DeviceGroup> deviceGroup;
        private BGUComboBox<EntitySpec> entitySpec;
        private JCheckBox needLogin;
        private JCheckBox needPassword;
        private JCheckBox needPin;
        private JCheckBox needDevice;
        private JCheckBox needIdentifier;
        private JCheckBox needMacAddress;
        private BGConfigEditorPane config;
        private TvAccountSpec current;

        public TvAccountSpecForm() {
            super((LayoutManager)new GridBagLayout());
            this.entitySpec = new BGUComboBox();
        }

        protected void jbInit() {
            BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 ");
            this.add(this.getGeneralPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.getCheckPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 20, 0, 0), 0, 0));
            this.add(this.getTabbedPane(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 20, 0, 0), 0, 0));
        }

        private JPanel getGeneralPanel() {
            this.title = new BGTextField(40);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.33, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, 1, 1, 1, 0.33, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.entitySpec, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getCheckPanel() {
            this.needLogin = new JCheckBox("\u043b\u043e\u0433\u0438\u043d");
            this.needPassword = new JCheckBox("\u043f\u0430\u0440\u043e\u043b\u044c");
            this.needPin = new JCheckBox("PIN");
            this.needDevice = new JCheckBox("\u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            this.needIdentifier = new JCheckBox("\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440");
            this.needMacAddress = new JCheckBox("MAC-\u0430\u0434\u0440\u0435\u0441");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.needLogin, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needPassword, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needPin, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needDevice, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needIdentifier, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.needMacAddress, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JTabbedPane getTabbedPane() {
            this.config = new BGConfigEditorPane();
            this.deviceType = new BGUCheckList();
            this.deviceGroup = new BGUCheckTree(DeviceGroup.class);
            this.childrenType = new BGUCheckList();
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add((Component)TvAccountSpecPanel.this.panelWrap(new JScrollPane((Component)this.config)), "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            tabbedPane.add((Component)TvAccountSpecPanel.this.panelWrap((JComponent)this.deviceType), "\u0422\u0438\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432");
            tabbedPane.add((Component)TvAccountSpecPanel.this.panelWrap((JComponent)this.childrenType), "\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0442\u0438\u043f\u044b");
            tabbedPane.add((Component)TvAccountSpecPanel.this.panelWrap(new JScrollPane((Component)this.deviceGroup)), "\u0413\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432");
            return tabbedPane;
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.current = new TvAccountSpec();
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                this.current = (TvAccountSpec)TvAccountSpecPanel.this.model.getSelectedRow();
                if (this.current != null) {
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    TvAccountSpec tvAccountSpec = TvAccountSpec.builder().setId(TvAccountSpecForm.this.current.getId()).setTitle(TvAccountSpecForm.this.title.getText()).setEntitySpecId(((EntitySpec)TvAccountSpecForm.this.entitySpec.getSelectedItem()).getId()).setDeviceTypeIds(TvAccountSpecForm.this.deviceType.getSelectedIds()).setParentTypeIds(TvAccountSpecForm.this.childrenType.getSelectedIds()).setDeviceGroupIds(TvAccountSpecForm.this.deviceGroup.getChecked()).setNeedLogin(TvAccountSpecForm.this.needLogin.isSelected()).setNeedPassword(TvAccountSpecForm.this.needPassword.isSelected()).setNeedPin(TvAccountSpecForm.this.needPin.isSelected()).setNeedDevice(TvAccountSpecForm.this.needDevice.isSelected()).setNeedIdentifier(TvAccountSpecForm.this.needIdentifier.isSelected()).setNeedMacAddress(TvAccountSpecForm.this.needMacAddress.isSelected()).setConfig(TvAccountSpecForm.this.config.getText()).build();
                    int id = TvAccountSpecPanel.this.getTvAccountService().tvAccountSpecUpdate(tvAccountSpec);
                    TvAccountSpecForm.this.performActionClose();
                    TvAccountSpecPanel.this.performAction("refresh");
                    TvAccountSpecPanel.this.model.setSelectedRow(id);
                }
            };
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.current = (TvAccountSpec)TvAccountSpecPanel.this.model.getSelectedRow();
                if (this.current != null && BGSwingUtilites.confirmDelete((String)"\u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", (Object)this.current)) {
                    TvAccountSpecPanel.this.getTvAccountService().tvAccountSpecDelete(this.current.getId());
                    this.performActionClose();
                    TvAccountSpecPanel.this.performAction("refresh");
                }
            });
        }

        public void performActionOpen() {
            try {
                Async entitySpecList = Async.of(() -> {
                    ArrayList<EntitySpec> entitySpecs = new ArrayList<EntitySpec>();
                    entitySpecs.add(new EntitySpec("-----"));
                    entitySpecs.addAll(((EntityService)((ClientContext)this.getContext()).getPort(EntityService.class, 0)).entitySpecList());
                    return entitySpecs;
                });
                Async deviceTypeTitles = Async.of(() -> TvAccountSpecPanel.this.getTvDeviceService().deviceTypeTitleList());
                Async tvAccountSpecTitles = Async.of(() -> TvAccountSpecPanel.this.getTvAccountService().tvAccountSpecTitleList());
                Async.ofWithTry(() -> this.deviceGroup.setData((Id)TvAccountSpecPanel.this.getTvDeviceService().deviceGroupRoot(), this.current.getDeviceGroupIds()));
                this.title.setText(this.current.getTitle());
                this.entitySpec.setData((List)entitySpecList.get());
                this.entitySpec.setSelectedItem((Object)this.current.getEntitySpecId());
                this.needLogin.setSelected(this.current.isNeedLogin());
                this.needPassword.setSelected(this.current.isNeedPassword());
                this.needPin.setSelected(this.current.isNeedPin());
                this.needDevice.setSelected(this.current.isNeedDevice());
                this.needIdentifier.setSelected(this.current.isNeedIdentifier());
                this.needMacAddress.setSelected(this.current.isNeedMacAddress());
                this.config.setText(this.current.getConfig());
                this.deviceType.setData((List)deviceTypeTitles.get());
                this.deviceType.setSelected((Collection)this.current.getDeviceTypeIds());
                this.childrenType.setData((List)tvAccountSpecTitles.get());
                this.childrenType.setSelected((Collection)this.current.getParentTypeIds());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            super.performActionOpen();
        }
    }
}

