/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TaskBaseRunner
extends RunTask {
    private int taskId = 0;
    private Date dt = null;
    private String className = null;
    private String params = null;
    private int moduleId;
    private String comment = null;
    private List<DependentTask> dependentTasks;
    private boolean isPackageTask;

    public TaskBaseRunner(LightweightTaskData task, Date dt, boolean isPackageTask) throws Exception {
        this.taskId = task.getId();
        this.dt = dt;
        this.className = task.getClassName();
        this.params = task.getParams();
        this.moduleId = task.getModuleId();
        this.comment = task.getComment();
        this.dependentTasks = task.getDependentTasks();
        this.isPackageTask = isPackageTask;
    }

    @Override
    public String getDescription() {
        try {
            TaskBase task = (TaskBase)Class.forName(this.className).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (task != null) {
                GregorianCalendar time = new GregorianCalendar();
                time.setTime(this.dt);
                task.setExecutingTime(time);
                task.setModuleId(this.moduleId == -2 ? this.dependentTasks.get(0).getModuleId() : this.moduleId);
                task.initTask(Setup.getSetup(), this.taskId, this.params);
                return task.getDescription();
            }
        }
        catch (Exception ex) {
            return Utils.notBlankString(this.comment) ? this.comment : "\u041f\u0430\u043a\u0435\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 (\u0417\u0430\u0434\u0430\u0447: " + this.dependentTasks.size() + ")";
        }
        return null;
    }

    @Override
    public void executeTask() {
        try {
            Object task;
            if (Utils.notBlankString(this.className) && this.moduleId > -1 && (task = (TaskBase)Class.forName(this.className).getConstructor(new Class[0]).newInstance(new Object[0])) != null) {
                GregorianCalendar time = new GregorianCalendar();
                time.setTime(this.dt);
                ((TaskBase)task).setModuleId(this.moduleId);
                ((TaskBase)task).setExecutingTime(time);
                ((TaskBase)task).initTask(this.setup, this.taskId, this.params);
                long start = System.currentTimeMillis();
                this.getLogger().info("Start task [ID# " + this.taskId + "] at time " + TimeUtils.format(this.dt, "dd.MM.yyyy HH:mm:ss"));
                ((TaskBase)task).startTask();
                long end = System.currentTimeMillis();
                this.getLogger().info("Task time: " + TimeUtils.formatDeltaTime((end - start) / 1000L));
            }
            if (Utils.notEmptyCollection(this.dependentTasks)) {
                for (DependentTask dependentTask : this.dependentTasks) {
                    TaskBase task2 = (TaskBase)Class.forName(dependentTask.getClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (task2 == null || this.isPackageTask && TaskStatus.DISABLE.equals((Object)dependentTask.getTaskStatus())) continue;
                    GregorianCalendar time = new GregorianCalendar();
                    time.setTime(this.dt);
                    task2.setExecutingTime(time);
                    task2.setModuleId(dependentTask.getModuleId());
                    task2.initTask(this.setup, this.taskId, dependentTask.getParams());
                    long start = System.currentTimeMillis();
                    this.getLogger().info("start task id => " + this.taskId + " at time " + TimeUtils.format(this.dt, "dd.MM.yyyy HH"));
                    task2.startTask();
                    long end = System.currentTimeMillis();
                    this.getLogger().info("task time : " + TimeUtils.formatDeltaTime((end - start) / 1000L));
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public String toString() {
        return this.className;
    }
}

