/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportUtils;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport;
import ru.bitel.bgbilling.modules.reports.server.report.BGReport;
import ru.bitel.common.Utils;

@WebServlet(name="reportsViewer", urlPatterns={"/reports/viewer/*"})
public class ReportsViewerExecutor
extends CommonExecutor {
    private final String JSP_PATH = "/WEB-INF/jspf/reports/viewer/";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        int moduleId = Utils.parseInt((String)request.getParameter("moduleId"), (int)27);
        if ("/reportTable".equals(pathInfo)) {
            this.reportTable(request, response, moduleId);
        } else if ("/reportMenu".equals(pathInfo)) {
            this.reportMenu(request, response, moduleId);
        } else if ("/reportList".equals(pathInfo)) {
            this.reportList(request, response, moduleId);
        } else {
            this.sendBasePage(request, response);
        }
    }

    private void reportList(HttpServletRequest request, HttpServletResponse response, int moduleId) {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            String reportModule = request.getParameter("module");
            ArrayList<BGReportUtils.Report> reports = new ArrayList<BGReportUtils.Report>();
            for (BGReportUtils.Report report : BGReportUtils.getReports(reportModule, con)) {
                String className = report.report_class;
                if (Utils.isBlankString((String)className) && ("folder".equals(report.from) || "dyn".equals(report.from))) {
                    className = report.reportElement.getAttribute("dyn_class");
                }
                try {
                    Class.forName(className).asSubclass(BGCSVReport.CSVFillerData.class);
                    reports.add(report);
                }
                catch (Exception exception) {}
            }
            request.setAttribute("reportList", reports);
            request.setAttribute("reportModuleId", (Object)moduleId);
            response.setContentType("text/html; charset=utf-8");
            request.getRequestDispatcher("/WEB-INF/jspf/reports/viewer/reportList.jsp").include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void reportMenu(HttpServletRequest request, HttpServletResponse response, int moduleId) {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            ArrayList<ModulePlugin> modules = new ArrayList<ModulePlugin>();
            JSONArray jsonArray = BGReportUtils.getModuleAndPlugin(this.setup.getModuleSetup(Integer.valueOf(moduleId)), con);
            for (int index = 0; index < jsonArray.length(); ++index) {
                JSONObject json = jsonArray.getJSONObject(index);
                ModulePlugin modulePlugin = new ModulePlugin();
                modulePlugin.setType(json.getString("type"));
                modulePlugin.setTitle(json.getString("title"));
                modulePlugin.setModule(json.optString("module"));
                modulePlugin.setModuleId(json.optInt("moduleId"));
                modules.add(modulePlugin);
            }
            request.setAttribute("modules", modules);
            response.setContentType("text/html; charset=utf-8");
            request.getRequestDispatcher("/WEB-INF/jspf/reports/viewer/reportMenu.jsp").include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void reportTable(HttpServletRequest request, HttpServletResponse response, int moduleId) {
        String reportId = request.getParameter("report_id");
        reportId = reportId != null ? reportId : "inet_egs_nat_policy";
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            this.getLogger().debug("Generate report with id={}", (Object)reportId);
            BGReport report = BGReportUtils.getReport(reportId, con, conSlave, this.setup.getModuleSetup(Integer.valueOf(moduleId)), 0, this.getLogger());
            BGReportUtils.addRequestParams(report, request);
            if (report instanceof BGCSVReport) {
                request.setAttribute("fields", ((BGCSVReport)report).getFields());
                request.setAttribute("reportResult", (Object)((BGCSVReport)report).getReportResult());
            }
            response.setContentType("text/html; charset=utf-8");
            request.getRequestDispatcher("/WEB-INF/jspf/reports/viewer/reportTable.jsp").include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void sendBasePage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BGModule bgModule;
        Iterator iterator = ModuleCache.getInstance().getModulesList().iterator();
        while (iterator.hasNext() && !"reports".equals((bgModule = (BGModule)iterator.next()).getName())) {
        }
        response.setContentType("text/html; charset=utf-8");
        request.getRequestDispatcher("/WEB-INF/jspf/reports/viewer/reportMain.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    public static class ModulePlugin {
        String type = null;
        String title = null;
        String module = null;
        int moduleId = 0;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String module) {
            this.module = module;
        }

        public int getModuleId() {
            return this.moduleId;
        }

        public void setModuleId(int moduleId) {
            this.moduleId = moduleId;
        }
    }
}

