/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.action.web;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractCredentials;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoTryAndBuy;
import ru.bitel.bgbilling.modules.megogo.common.service.MegogoService;
import ru.bitel.bgbilling.modules.megogo.server.MegogoApi;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionMegogo
extends AbstractAction {
    private MegogoService megogoService;

    public ActionMegogo() {
        super("megogo");
    }

    @PostConstruct
    public void init() throws BGException {
        this.megogoService = (MegogoService)this.context.newService(MegogoService.class, this.moduleId);
    }

    public void execute() throws BGException {
    }

    public void mode() throws Exception {
        List contractlist = this.megogoService.contractSubscriptionList(this.contractId, -1, null);
        int preview = this.req.getInt("preview", -1);
        if (contractlist.size() == 0) {
            this.setResultParam("mode", "0");
        } else if (preview == 1) {
            this.setResultParam("mode", "3");
        } else {
            this.setSubscription();
            this.setResultParam("mode", "1");
        }
        this.requestDispatcher(this.moduleName, "megogo");
    }

    public void listServiceForConnect() throws Exception {
        this.setSubscription();
        this.setResultParam("mode", "2");
        this.requestDispatcher(this.moduleName, "megogo");
    }

    public void subscribe() throws Exception {
        int serviceId = this.req.getInt("serviceId", -1);
        if (serviceId > 0) {
            List contractlistAll = this.megogoService.contractSubscriptionList(this.contractId, -1, null);
            boolean firstConnection = contractlistAll.size() == 0;
            this.megogoService.subscribe(this.contractId, serviceId);
            if (firstConnection) {
                this.setResultParam("redirectToMegogo", "1");
            }
        }
        this.setSubscription();
        this.setResultParam("mode", "1");
    }

    public void unsubscribe() throws Exception {
        int contractSubscribeId = this.req.getInt("id", -1);
        if (contractSubscribeId > 0) {
            this.megogoService.unsubscribe(contractSubscribeId);
        }
        this.setSubscription();
        this.setResultParam("mode", "1");
    }

    public void abortUnsubscribe() throws Exception {
        int contractSubscribeId = this.req.getInt("id", -1);
        if (contractSubscribeId > 0) {
            this.megogoService.abortUnsubscribe(contractSubscribeId);
        }
        this.setSubscription();
        this.setResultParam("mode", "1");
    }

    public void moveToMegogo() throws Exception {
        List contractlist = this.megogoService.contractSubscriptionList(this.contractId, -1, new Date());
        if (contractlist.size() == 0) {
            throw new BGMessageException("\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a");
        }
        MegogoApi megogoApi = new MegogoApi(this.moduleId, this.userId, this.con);
        this.context.getResponse().sendRedirect(megogoApi.getRedirectUrl(this.contractId));
        this.setResultParam("mode", "1");
    }

    public void getCredentials() throws Exception {
        this.megogoService.requestCredentials(this.contractId, null, null);
        this.setSubscription();
        this.setResultParam("mode", "1");
    }

    private void setSubscription() throws Exception {
        MegogoContractCredentials credentials;
        boolean all = this.req.getBoolean("allSubcription", false);
        List contractlist = this.megogoService.getContractSubscriptionListByType(this.contractId, -1, all ? null : new Period(new Date(), null));
        List contractlistAll = this.megogoService.contractSubscriptionList(this.contractId, -1, null);
        Directory serviceDirectory = this.context.getDirectory(Service.class, 0);
        HashSet<Integer> serviceIdConnectList = new HashSet<Integer>();
        boolean haveMainSub = false;
        boolean haveMainInDisconnect = false;
        boolean firstConnection = contractlistAll.size() == 0;
        Iterator iterator = contractlist.iterator();
        while (iterator.hasNext()) {
            MegogoContractSubscription ser;
            Service service = (Service)serviceDirectory.get((ser = (MegogoContractSubscription)iterator.next()).getServiceId());
            ser.setTitle(service != null ? service.getTitle() : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430");
            serviceIdConnectList.add(ser.getServiceId());
            MegogoSubscription sub = this.megogoService.getSubscriptionByServiceId(ser.getServiceId());
            if (sub.getType() != 1) continue;
            haveMainSub = true;
            if (ser.getStatus() != 1) continue;
            haveMainInDisconnect = true;
        }
        HashMap<Integer, String> connectButtonMap = new HashMap<Integer, String>();
        Map tryAndBuyMap = this.megogoService.getTryAndBuyMap(true).getMap();
        ArrayList<MegogoSubscription> subscriptions = new ArrayList<MegogoSubscription>();
        block1: for (MegogoSubscription subscription : this.megogoService.subscriptionList(Boolean.valueOf(true), -1)) {
            if (serviceIdConnectList.contains(subscription.getSid()) || haveMainInDisconnect && subscription.getType() == 1) continue;
            Service service = (Service)serviceDirectory.get(subscription.getSid());
            subscription.setTitle(service != null ? service.getTitle().replaceAll("\"", "&quot") : "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430");
            subscriptions.add(subscription);
            String buttonConText = subscription.getType() == 1 && haveMainSub ? "\u041f\u0435\u0440\u0435\u0439\u0442\u0438" : "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c";
            connectButtonMap.put(subscription.getSid(), buttonConText);
            MegogoTryAndBuy tAb = (MegogoTryAndBuy)tryAndBuyMap.get(subscription.getSid());
            if (tAb == null || tAb.getType() == 1 && !firstConnection) continue;
            if (tAb.getType() == 2) {
                for (MegogoContractSubscription contractSubscription : contractlistAll) {
                    if (contractSubscription.getServiceId() != tAb.getSid()) continue;
                    continue block1;
                }
            }
            connectButtonMap.put(subscription.getSid(), tAb.getTitle());
        }
        if (all) {
            this.setResultParam("allSubcription", Utils.booleanToStringInt((boolean)all));
        }
        if (haveMainSub) {
            this.setResultParam("havaMainSub", Utils.booleanToStringInt((boolean)haveMainSub));
        }
        if ((credentials = this.megogoService.getContractCredentials(this.contractId)) != null) {
            this.setResultParam("login", credentials.getLogin());
            this.setResultParam("pwd", credentials.getPwd());
        }
        this.setResultParam("contractSubscriptionList", contractlist);
        this.setResultParam("subscriptionList", subscriptions);
        this.setResultParam("connectButtonMap", connectButtonMap);
    }
}

