/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.contract;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class ContractContactPanel
extends BGUPanel {
    private List<ContactType> contactTypes = null;
    private DispatchService dispatchService = null;
    private ContactTableModel model = new ContactTableModel();

    protected void jbInit() {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add(this.getTablePanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private DispatchService getDispatchService() {
        if (this.dispatchService == null) {
            this.dispatchService = (DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class);
        }
        return this.dispatchService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.model.setData(this.getDispatchService().getContacts(((ClientContext)this.getContext()).getContractId()));
            if (this.contactTypes == null) {
                this.contactTypes = this.getDispatchService().getContactTypes();
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> Optional.ofNullable(this.contactTypes).filter(a -> !this.contactTypes.isEmpty()).ifPresentOrElse(a -> new ContactEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442", new Contact()).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432")));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Contact contact = this.getCurrentAndCheck();
            if (contact != null) {
                if (this.contactTypes == null || this.contactTypes.isEmpty()) {
                    ClientUtils.showErrorMessageDialog((String)"\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043e\u0432");
                    return;
                }
                new ContactEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", contact).open();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Contact contact = this.getCurrentAndCheck();
            if (contact != null && ClientUtils.confirmDelete((Object)contact.getValueForView())) {
                this.getDispatchService().deleteContact(contact.getId());
                this.performAction("refresh");
            }
        });
    }

    private Contact getCurrentAndCheck() throws BGMessageException {
        Contact contact = (Contact)this.model.getSelectedRow();
        if (contact == null) {
            ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
        }
        return contact;
    }

    class ContactTableModel
    extends BGTableModel<Contact> {
        public ContactTableModel() {
            super(ContactTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", 400, 500, 600, "contactType", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "valueForView", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        public Object getValue(Contact contact, int column) throws Exception {
            String i = this.getIdentifier(column);
            if ("contactType".equals(i)) {
                ContactType item = this.findItem(contact.getContactTypeId());
                return item != null ? item.getTitle() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430>";
            }
            return super.getValue((Object)contact, column);
        }

        private ContactType findItem(int contactTypeId) {
            for (ContactType contactType : ContractContactPanel.this.contactTypes) {
                if (contactType.getId() != contactTypeId) continue;
                return contactType;
            }
            return null;
        }
    }

    class ContactEditor
    extends BGEditorDialog<Contact> {
        private JTextArea tooltip;
        private BGTextField valueField;
        private BGUComboBox<ContactType> contactTypeBox;

        public ContactEditor(String title, Contact data) {
            super(title, (Object)data);
            this.tooltip = new JTextArea(5, 40);
            this.valueField = new BGTextField(40);
            this.contactTypeBox = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.tooltip.setEditable(false);
            this.tooltip.setLineWrap(true);
            this.tooltip.setWrapStyleWord(true);
            this.tooltip.setMargin(new Insets(3, 3, 3, 3));
            this.tooltip.setFont(this.tooltip.getFont().deriveFont(11.0f));
            this.tooltip.setForeground(Color.DARK_GRAY);
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.contactTypeBox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.valueField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JScrollPane(this.tooltip), new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.contactTypeBox.setData(ContractContactPanel.this.contactTypes);
            this.contactTypeBox.setSelectedItem((Object)((Contact)this.data).getContactTypeId());
            if (((Contact)this.data).getId() > 0) {
                this.contactTypeBox.setEnabled(false);
            } else {
                this.contactTypeBox.addActionListener(e -> this.setTooltopAndDefaultValue());
            }
            this.setTooltopAndDefaultValue();
            this.valueField.setText(((Contact)this.data).getValue());
        }

        private void setTooltopAndDefaultValue() {
            ContactType type = (ContactType)this.contactTypeBox.getSelectedItem();
            if (type != null) {
                String text = type.getDescription() + "\n\n\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:\n";
                try {
                    String defaultValue = ContractContactPanel.this.getDispatchService().getContactDefaultValue(type.getId(), ((ClientContext)ContractContactPanel.this.getContext()).getContractId());
                    text = text + (defaultValue == null ? "\u043d\u0435\u0442" : defaultValue);
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
                this.tooltip.setText(text);
            }
        }

        public boolean doApply() throws Exception {
            ((Contact)this.data).setValue(this.valueField.getText());
            ((Contact)this.data).setContactTypeId(((ContactType)this.contactTypeBox.getSelectedItem()).getId());
            ((Contact)this.data).setContractId(((ClientContext)ContractContactPanel.this.getContext()).getContractId());
            ContractContactPanel.this.getDispatchService().updateContact((Contact)this.data);
            ContractContactPanel.this.performAction("refresh");
            return true;
        }
    }
}

