/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.dbcp;

import java.sql.Connection;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import ru.bitel.bgbilling.server.dbcp.DbcpPoolableConnection;

public final class DbcpPoolableConnectionFactory
extends PoolableConnectionFactory {
    public DbcpPoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, int validationQueryTimeout, boolean defaultReadOnly, boolean defaultAutoCommit) {
        super(connFactory, pool, stmtPoolFactory, validationQuery, validationQueryTimeout, defaultReadOnly, defaultAutoCommit);
    }

    public Object makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(conn);
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)conn));
        }
        return new DbcpPoolableConnection(conn, this._pool, this._config);
    }

    public void passivateObject(Object obj) throws Exception {
        if (obj instanceof DbcpPoolableConnection) {
            DbcpPoolableConnection conn = (DbcpPoolableConnection)((Object)obj);
            if (!conn.getAutoCommit() && !conn.isReadOnly()) {
                conn.rollback();
            }
            conn.clearWarnings();
            conn.passivate();
        } else {
            super.passivateObject(obj);
        }
    }
}

