/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.ClosableTabbedPane;
import bitel.billing.module.common.CloseTabAction;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class ClosableTabbedPaneUI
extends BasicTabbedPaneUI {
    private ImageIcon closeImageIcon = null;
    private TabCloseButtonAlign closeButtonAlign = TabCloseButtonAlign.LEFT;

    public ClosableTabbedPaneUI() {
        this.closeImageIcon = ClientUtils.getIcon("close_tab.gif");
    }

    public ClosableTabbedPaneUI(TabCloseButtonAlign closeButtonAlign) {
        this();
        this.closeButtonAlign = closeButtonAlign;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        Rectangle myIconRect = this.getIconRect(rects[tabIndex], textRect);
        g.drawImage(this.closeImageIcon.getImage(), myIconRect.x, myIconRect.y, null);
    }

    private Rectangle getIconRect(Rectangle rectsI, Rectangle textRect) {
        Rectangle absIconRect = null;
        switch (this.closeButtonAlign) {
            case LEFT: {
                absIconRect = new Rectangle(5, 2, this.closeImageIcon.getIconWidth(), this.closeImageIcon.getIconHeight());
                break;
            }
            case RIGHT: {
                absIconRect = new Rectangle(rectsI.width - this.closeImageIcon.getIconWidth() - 5, 2, this.closeImageIcon.getIconWidth(), this.closeImageIcon.getIconHeight());
            }
        }
        absIconRect.x = rectsI.x + absIconRect.x;
        absIconRect.y = textRect != null ? textRect.y - 3 : rectsI.y + absIconRect.y;
        return absIconRect;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int shiftX = 0;
        switch (this.closeButtonAlign) {
            case LEFT: {
                shiftX = 6;
                break;
            }
            case RIGHT: {
                shiftX = -9;
            }
        }
        return super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected) + shiftX;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + 15;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return 100;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    public static enum TabCloseButtonAlign {
        LEFT,
        RIGHT;

    }

    class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public MyMouseHandler() {
            super(ClosableTabbedPaneUI.this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int tabIndex = -1;
            int tabCount = ClosableTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!ClosableTabbedPaneUI.this.rects[i].contains(x, y)) continue;
                tabIndex = i;
                break;
            }
            if (tabIndex >= 0) {
                Rectangle iconRect = ClosableTabbedPaneUI.this.getIconRect(ClosableTabbedPaneUI.this.rects[tabIndex], null);
                if (SwingUtilities.isMiddleMouseButton(e) || iconRect.contains(x, y)) {
                    if (ClosableTabbedPaneUI.this.tabPane instanceof ClosableTabbedPane) {
                        ClosableTabbedPane closableTabbedPane = (ClosableTabbedPane)ClosableTabbedPaneUI.this.tabPane;
                        CloseTabAction closeTabAction = closableTabbedPane.getCloseTabAction();
                        if (closeTabAction != null) {
                            closeTabAction.act(closableTabbedPane, tabIndex);
                        }
                    } else {
                        ClosableTabbedPaneUI.this.tabPane.removeTabAt(tabIndex);
                    }
                }
            }
        }
    }
}

