/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.ByteBuffer;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.common.inet.IpAddress;

public class NetFlow9Record
extends Data {
    private static final byte[] ZERO = new byte[4];

    public void fillData(ByteBuffer data, NetFlow9Template template) {
        boolean postNatDest;
        int pos = 0;
        int position = data.position();
        if (template.ip6SrcAddressItem.init) {
            this.srcAddress.address = this.ipv6SrcAddress;
            data.position(position + template.ip6SrcAddressItem.offset);
            data.get(this.srcAddress.address, 0, 16);
        } else {
            this.srcAddress.address = this.ipv4SrcAddress;
            if (template.ip4SrcAddressItem.init) {
                data.position(position + template.ip4SrcAddressItem.offset);
                data.get(this.srcAddress.address, 0, 4);
            } else {
                System.arraycopy(ZERO, 0, this.srcAddress.address, 0, 4);
            }
        }
        if (template.ip6DstAddressItem.init) {
            this.dstAddress.address = this.ipv6DstAddress;
            data.position(position + template.ip6DstAddressItem.offset);
            data.get(this.dstAddress.address, 0, 16);
            postNatDest = false;
        } else {
            this.dstAddress.address = this.ipv4DstAddress;
            if (template.hslNatLogFieldTranslatedDestinationIPv4Addr.init) {
                pos = position + template.hslNatLogFieldTranslatedDestinationIPv4Addr.offset;
                if (pos < data.limit()) {
                    data.position(pos);
                    data.get(this.dstAddress.address, 0, 4);
                }
                postNatDest = this.dstAddress.address != null && !IpAddress.equals((byte[])this.dstAddress.address, (byte[])ZERO);
            } else {
                postNatDest = false;
            }
        }
        if (!postNatDest) {
            if (template.ip4DstAddressItem.init) {
                data.position(position + template.ip4DstAddressItem.offset);
                data.get(this.dstAddress.address, 0, 4);
            } else {
                System.arraycopy(ZERO, 0, this.dstAddress.address, 0, 4);
            }
        }
        this.nextHop = template.ip4NextHopItem.init ? (long)data.getInt(position + template.ip4NextHopItem.offset) & 0xFFFFFFFFL : 0L;
        this.inputInterface = template.inSnmpIfaceItem.init ? data.getShort(position + template.inSnmpIfaceItem.offset) & 0xFFFF : 0;
        this.outputInterface = template.outSnmpIfaceItem.init ? data.getShort(position + template.outSnmpIfaceItem.offset) & 0xFFFF : 0;
        if (template.inOctetsItem.init) {
            int length = template.inOctetsItem.length;
            if (length == 4) {
                this.octets = (long)data.getInt(position + template.inOctetsItem.offset) & 0xFFFFFFFFL;
            } else if (length == 8) {
                this.octets = data.getLong(position + template.inOctetsItem.offset) & 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.octets = 0L;
        }
        this.srcPort = template.l4SrcPortItem.init ? ((pos = position + template.l4SrcPortItem.offset) < data.limit() - 2 ? data.getShort(pos) & 0xFFFF : 0) : 0;
        if (postNatDest && template.hslNatLogFieldTranslatedDestinationPort != null && template.hslNatLogFieldTranslatedDestinationPort.init) {
            pos = position + template.hslNatLogFieldTranslatedDestinationPort.offset;
            int n = this.dstPort = pos < data.limit() - 2 ? data.getShort(pos) & 0xFFFF : 0;
            if (this.dstPort == 0 && template.l4DstPortItem.init) {
                pos = position + template.l4DstPortItem.offset;
                this.dstPort = pos < data.limit() - 2 ? data.getShort(pos) & 0xFFFF : 0;
            }
        } else {
            this.dstPort = template.l4DstPortItem.init ? data.getShort(position + template.l4DstPortItem.offset) & 0xFFFF : 0;
        }
        int n = this.diffServ = template.srcTosBytesItem.init ? data.get(position + template.srcTosBytesItem.offset) & 0xFF : 0;
        this.protocol = template.protocolItem.init ? ((pos = position + template.protocolItem.offset) < data.limit() - 1 ? data.get(pos) & 0xFF : 0) : 0;
        pos = position + 8;
        this.milliseconds = pos < data.limit() - 4 ? ((long)data.getInt(position + 8) & 0xFFFFFFFFL) * 1000L : 0L;
        pos = position + 12;
        this.milliseconds += pos < data.limit() - 4 ? ((long)data.getInt(position + 8 + 4) & 0xFFFFFFFFL) / 1000000L : 0L;
    }
}

