package ru.bitel.bgbilling.modules.tv.dyn.wink;

import bitel.billing.server.util.Config;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public class WinkConf
    extends Config
{
    final int chargeTypeId;
    final boolean testMode;
    final String username;
    final String password;
    final String providerURL;
    final String providerURLPrefix;
    final String partnerRegionId;
    final String ottTvCodePattern;
    
    public WinkConf( int moduleId, ParameterMap moduleSetup, Setup serverSetup )
    {
        super( moduleId, moduleSetup, serverSetup );
        
        this.username = moduleSetup.get( "om.wink.provider.username", "" );
        this.password = moduleSetup.get( "om.wink.provider.password", "" );
        this.providerURL = moduleSetup.get( "om.wink.provider.url", "https://api.wink.tv/" );
        this.providerURLPrefix = moduleSetup.get( "om.wink.provider.url.prefix", "" );
        this.partnerRegionId = moduleSetup.get( "om.wink.partner.region.id", "" );
        this.ottTvCodePattern = moduleSetup.get( "om.wink.ott.tv.code.pattern", "" );
        
        this.testMode = moduleSetup.getBoolean( "om.wink.test.mode", false );

        this.chargeTypeId = moduleSetup.getInt( "om.wink.charge.type.id", 0 );
    }
}
