/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc.fermaofdru;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.BGFiscConnectException;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.function.ThrowingConsumer;

public class FermaofdruFiscalizator
extends Fiscalizator {
    private String addr = null;
    private String login = null;
    private String password = null;
    private int timeout = -1;
    private String Inn = null;
    private String TaxationSystem = null;
    private String AgentType = null;
    private String TransferAgentPhone = null;
    private String TransferAgentName = null;
    private String TransferAgentAddress = null;
    private String TransferAgentINN = null;
    private String PaymentAgentOperation = null;
    private String PaymentAgentPhone = null;
    private String ReceiverPhone = null;
    private String SupplierPhone = null;
    private volatile String authToken = null;
    private static Logger logger = LogManager.getLogger();
    private static String RECEIPT_TYPE_INCOME = "Income";
    private static String RECEIPT_TYPE_INCOMERETURN = "IncomeReturn";
    private static String RECEIPT_TYPE_INCOMECORRECTION = "IncomeCorrection";

    public FermaofdruFiscalizator(Printer printer) throws BGException {
        super(printer);
        this.addr = printer.getConfig().get("addr", "addr-not-specified");
        if (this.addr.endsWith("/")) {
            this.addr = this.addr.substring(0, this.addr.length() - 1);
        }
        this.login = printer.getConfig().get("login", "login-not-specified");
        this.password = printer.getConfig().get("pass", "");
        this.timeout = printer.getConfig().getInt("timeout", this.timeout);
        this.Inn = printer.getConfig().get("Inn", "");
        this.TaxationSystem = printer.getConfig().get("TaxationSystem", "");
        this.AgentType = printer.getConfig().get("AgentType", null);
        this.TransferAgentPhone = printer.getConfig().get("TransferAgentPhone", null);
        this.TransferAgentName = printer.getConfig().get("TransferAgentName", null);
        this.TransferAgentAddress = printer.getConfig().get("TransferAgentAddress", null);
        this.TransferAgentINN = printer.getConfig().get("TransferAgentINN", null);
        this.PaymentAgentOperation = printer.getConfig().get("PaymentAgentOperation", null);
        this.PaymentAgentPhone = printer.getConfig().get("PaymentAgentPhone", null);
        this.ReceiverPhone = printer.getConfig().get("ReceiverPhone", null);
        this.SupplierPhone = printer.getConfig().get("SupplierPhone", null);
    }

    private static <T> T checkErrorAsNoerror(JSONObject error, Class<T> dataType) {
        int Code = error.getInt("Code");
        if (Code == 1019) {
            String Message = error.getString("Message");
            Pattern pattern = Pattern.compile("\\(\\-\\-([A-Fa-f0-9\\-]+)\\-\\-\\)");
            Matcher matcher = pattern.matcher(Message);
            if (!matcher.find()) {
                return null;
            }
            String ReceiptId = matcher.group(1);
            logger.debug("mask error code 1019 (duplicate receipt-request?), ReceiptId=" + ReceiptId);
            JSONObject data = new JSONObject();
            data.put("ReceiptId", (Object)ReceiptId);
            return dataType.cast(data);
        }
        return null;
    }

    private static String formatErrorText(JSONObject error, int httpCode) {
        int Code = error.getInt("Code");
        String Message = error.getString("Message");
        return String.format("\u041e\u0448\u0438\u0431\u043a\u0430 Ferma: %s\n\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e: code: %s, http: %s", Message, Code, httpCode);
    }

    private static String formatErrorsText(JSONArray errors, int httpCode) {
        StringBuilder message = new StringBuilder();
        for (Object error : errors) {
            message.append(error.toString()).append("; ");
        }
        return String.format("\u041e\u0448\u0438\u0431\u043a\u0438 Ferma (\u0432\u043d\u0435\u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442): %s\n\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e: http: %s", message.toString(), httpCode);
    }

    private JSONObject doJsonRequest(String method, String url, JSONObject data, String token) throws BGException, BGFiscConnectException {
        return this.doJsonRequest(method, url, data, token, JSONObject.class);
    }

    private JSONArray doJsonRequestA(String method, String url, JSONObject data, String token) throws BGException, BGFiscConnectException {
        return this.doJsonRequest(method, url, data, token, JSONArray.class);
    }

    private <T> T doJsonRequest(String method, String url, JSONObject data, String token, Class<T> dataType) throws BGException, BGFiscConnectException {
        String body = null;
        if (data != null) {
            try {
                body = data.toString(0);
            }
            catch (Exception e) {
                throw new BGException("error dump json to request: " + e.getMessage(), (Throwable)e);
            }
        }
        if (token != null) {
            url = (String)url + "?AuthToken=" + token;
        }
        HashMap<String, String> requestProperties = new HashMap<String, String>(){
            {
                this.put("Content-type", "application/json; charset=utf-8");
            }
        };
        CashCheckUtils.HttpReply reply = CashCheckUtils.doHttpRequest(method, (String)url, body, (Map<String, String>)requestProperties, this.timeout, logger);
        JSONObject fullresponse = null;
        try {
            JSONTokener tokener = new JSONTokener(reply.body);
            fullresponse = (JSONObject)tokener.nextValue();
        }
        catch (Exception e) {
            throw new BGException("error parse json from response: " + e.getMessage());
        }
        if (fullresponse.has("Error") && !fullresponse.isNull("Error")) {
            try {
                JSONObject error = fullresponse.getJSONObject("Error");
                T maybeNotError = FermaofdruFiscalizator.checkErrorAsNoerror(error, dataType);
                if (maybeNotError != null) {
                    return maybeNotError;
                }
                throw new BGMessageException(FermaofdruFiscalizator.formatErrorText(error, reply.code));
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException("error parse error-message from response: " + e.getMessage(), (Throwable)e);
            }
        }
        if (fullresponse.has("Errors") && !fullresponse.isNull("Errors")) {
            try {
                JSONArray errors = fullresponse.getJSONArray("Errors");
                throw new BGMessageException(FermaofdruFiscalizator.formatErrorsText(errors, reply.code));
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException("error parse errorS-message from response: " + e.getMessage(), (Throwable)e);
            }
        }
        if (fullresponse.has("Data")) {
            if (dataType == JSONObject.class) {
                return dataType.cast(fullresponse.getJSONObject("Data"));
            }
            if (dataType == JSONArray.class) {
                return dataType.cast(fullresponse.getJSONArray("Data"));
            }
            throw new BGException("error parse response: error Data type " + dataType);
        }
        return dataType.cast(fullresponse);
    }

    private String getAuthToken() throws BGException {
        if (this.authToken == null) {
            logger.debug("get auth token...");
            String url = this.addr + "/Authorization/CreateAuthToken";
            JSONObject data = new JSONObject((Map)new HashMap<String, Object>(){
                {
                    this.put("Login", FermaofdruFiscalizator.this.login);
                    this.put("Password", FermaofdruFiscalizator.this.password);
                }
            });
            JSONObject reply = this.doJsonRequest("POST", url, data, null);
            if (!reply.has("AuthToken")) {
                throw new BGException("protocol error: no \"AuthToken\" field in response");
            }
            this.authToken = reply.getString("AuthToken");
        }
        return this.authToken;
    }

    public CheckPrintResult receipt(final String Type2, final Check check) throws BGException {
        JSONObject data;
        logger.debug("receipt " + Type2 + "...");
        String token = this.getAuthToken();
        final Date LocalDate2 = check.getDocumentDate() != null ? check.getDocumentDate() : new Date();
        final String InvoiceId = check.getDocumentId();
        if (InvoiceId == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0447\u0435\u043a\u0430 documentId");
        }
        String customerAddr = check.getCustomerEmail();
        if (customerAddr == null) {
            throw new BGMessageException("\u0412 \u0441\u043a\u0440\u0438\u043f\u0442\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d customerEmail");
        }
        final String Email = customerAddr.contains("@") ? customerAddr : null;
        final String Phone = !customerAddr.contains("@") ? customerAddr.replace(" ", "") : null;
        final String VatTotal = this.vat_convert(check.getTax());
        final Integer payMethodTotal = check.getPayMethod();
        final Integer payObjectTotal = check.getPayObject();
        final Integer payment_type = this.payment_type_convert(check.getPaymentType());
        String url = this.addr + "/kkt/cloud/receipt";
        JSONObject reply = this.doJsonRequest("POST", url, data = new JSONObject((Map)new HashMap<String, Object>(){
            {
                this.put("Request", new HashMap<String, Object>(){
                    {
                        this.put("Inn", FermaofdruFiscalizator.this.Inn);
                        this.put("Type", Type2);
                        this.put("InvoiceId", InvoiceId);
                        this.put("LocalDate", FermaofdruFiscalizator.this.date_convert(LocalDate2));
                        this.put("CustomerReceipt", new HashMap<String, Object>(){
                            {
                                this.put("TaxationSystem", FermaofdruFiscalizator.this.TaxationSystem);
                                if (Email != null) {
                                    this.put("Email", Email);
                                }
                                if (Phone != null) {
                                    this.put("Phone", Phone);
                                }
                                if (payObjectTotal != null) {
                                    this.put("PaymentType", payObjectTotal);
                                }
                                if (FermaofdruFiscalizator.this.AgentType != null || FermaofdruFiscalizator.this.TransferAgentPhone != null || FermaofdruFiscalizator.this.TransferAgentName != null || FermaofdruFiscalizator.this.TransferAgentAddress != null || FermaofdruFiscalizator.this.TransferAgentINN != null || FermaofdruFiscalizator.this.PaymentAgentOperation != null || FermaofdruFiscalizator.this.PaymentAgentPhone != null || FermaofdruFiscalizator.this.ReceiverPhone != null || FermaofdruFiscalizator.this.SupplierPhone != null) {
                                    this.put("PaymentAgentInfo", new HashMap<String, Object>(){
                                        {
                                            if (FermaofdruFiscalizator.this.AgentType != null) {
                                                this.put("AgentType", FermaofdruFiscalizator.this.AgentType);
                                            }
                                            if (FermaofdruFiscalizator.this.TransferAgentPhone != null) {
                                                this.put("TransferAgentPhone", FermaofdruFiscalizator.this.TransferAgentPhone);
                                            }
                                            if (FermaofdruFiscalizator.this.TransferAgentName != null) {
                                                this.put("TransferAgentName", FermaofdruFiscalizator.this.TransferAgentName);
                                            }
                                            if (FermaofdruFiscalizator.this.TransferAgentAddress != null) {
                                                this.put("TransferAgentAddress", FermaofdruFiscalizator.this.TransferAgentAddress);
                                            }
                                            if (FermaofdruFiscalizator.this.TransferAgentINN != null) {
                                                this.put("TransferAgentINN", FermaofdruFiscalizator.this.TransferAgentINN);
                                            }
                                            if (FermaofdruFiscalizator.this.PaymentAgentOperation != null) {
                                                this.put("PaymentAgentOperation", FermaofdruFiscalizator.this.PaymentAgentOperation);
                                            }
                                            if (FermaofdruFiscalizator.this.PaymentAgentPhone != null) {
                                                this.put("PaymentAgentPhone", FermaofdruFiscalizator.this.PaymentAgentPhone);
                                            }
                                            if (FermaofdruFiscalizator.this.ReceiverPhone != null) {
                                                this.put("ReceiverPhone", FermaofdruFiscalizator.this.ReceiverPhone);
                                            }
                                            if (FermaofdruFiscalizator.this.SupplierPhone != null) {
                                                this.put("SupplierPhone", FermaofdruFiscalizator.this.SupplierPhone);
                                            }
                                        }
                                    });
                                }
                                this.put("Items", new ArrayList<HashMap<String, Object>>(){
                                    {
                                        for (final Check.CheckLine line : check.getLines()) {
                                            if (line.summa == null) continue;
                                            final Integer payMethod = line.payMethod != null ? line.payMethod : payMethodTotal;
                                            final Integer payObject = line.payObject != null ? line.payObject : payObjectTotal;
                                            final String Vat = line.tax != null ? FermaofdruFiscalizator.this.vat_convert(line.tax) : VatTotal;
                                            this.add(new HashMap<String, Object>(){
                                                {
                                                    this.put("Label", line.text);
                                                    this.put("Price", line.summa);
                                                    this.put("Quantity", 1);
                                                    this.put("Amount", line.summa);
                                                    this.put("Vat", Vat);
                                                    if (payMethod != null) {
                                                        this.put("PaymentMethod", FermaofdruFiscalizator.payMethod_convert(payMethod));
                                                    }
                                                    if (payObject != null) {
                                                        this.put("PaymentType", FermaofdruFiscalizator.payObject_convert(payObject));
                                                    }
                                                }
                                            });
                                        }
                                    }
                                });
                                if (payment_type != null) {
                                    this.put("PaymentItems", new ArrayList<HashMap<String, Object>>(){
                                        {
                                            this.add(new HashMap<String, Object>(){
                                                {
                                                    this.put("PaymentType", payment_type);
                                                    this.put("Sum", check.getPaymentsum());
                                                }
                                            });
                                        }
                                    });
                                }
                                Long attr_internet = (Long)check.getCustomTags().get(1125);
                                Long attr_timezone = (Long)check.getCustomTags().get(1011);
                                if (attr_internet != null) {
                                    this.put("IsInternet", attr_internet == 1L);
                                }
                                if (attr_timezone != null) {
                                    this.put("Timezone", attr_timezone);
                                }
                            }
                        });
                    }
                });
            }
        }), token);
        if (!reply.has("ReceiptId")) {
            throw new BGException("protocol error: no ReceiptId field in response");
        }
        String ReceiptId = reply.getString("ReceiptId");
        return CheckPrintResult.async(ReceiptId);
    }

    public CheckPrintResult _receipt(String Type2, Check check) throws BGException {
        if (check.getCheckType() != null) {
            String newType = null;
            switch (check.getCheckType()) {
                case PAYMENT: {
                    newType = RECEIPT_TYPE_INCOME;
                    break;
                }
                case PAYMENTREFUND: {
                    newType = RECEIPT_TYPE_INCOMERETURN;
                    break;
                }
                case PAYMENTCORRECTION: {
                    newType = RECEIPT_TYPE_INCOMECORRECTION;
                    throw new BGException("checkType=PAYMENTCORRECTION \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u044d\u0442\u043e\u043c \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0435");
                }
                case PAYMENTREFUNDCORRECTION: {
                    throw new BGException("checkType=PAYMENTREFUNDCORRECTION \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u044d\u0442\u043e\u043c \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0435");
                }
            }
            if (!Type2.equals(newType)) {
                logger.debug("overwrite check type from " + Type2 + " to " + newType);
                Type2 = newType;
            }
        }
        return this.receipt(Type2, check);
    }

    private String date_convert(Date date) {
        return TimeUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss");
    }

    private String vat_convert(Integer vat) {
        if (vat == null) {
            return null;
        }
        switch (vat) {
            default: {
                return "VatNo";
            }
            case 0: 
            case 1000000: {
                return "Vat0";
            }
            case 10: 
            case 1000010: {
                return "Vat10";
            }
            case 18: 
            case 1000018: {
                return "Vat18";
            }
            case 20: 
            case 1000020: {
                return "Vat20";
            }
            case 110: 
            case 10110: 
            case 1000110: {
                return "CalculatedVat10110";
            }
            case 118: 
            case 18118: 
            case 1000118: {
                return "CalculatedVat18118";
            }
            case 120: 
            case 20120: 
            case 1000120: {
                return "CalculatedVat20120";
            }
            case 1000005: {
                return "Vat5";
            }
            case 1000105: {
                return "CalculatedVat5105";
            }
            case 1000007: {
                return "Vat7";
            }
            case 1000107: 
        }
        return "CalculatedVat7107";
    }

    private Integer payment_type_convert(Integer payment_type) {
        if (payment_type == null) {
            return null;
        }
        switch (payment_type) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
        }
        return payment_type;
    }

    private static Integer payMethod_convert(Integer payMethod) {
        if (payMethod == null) {
            return null;
        }
        switch (payMethod) {
            case 1214001: {
                return 1;
            }
            case 1214002: {
                return 2;
            }
            case 1214003: {
                return 3;
            }
            case 1214004: {
                return 4;
            }
            case 1214005: {
                return 5;
            }
            case 1214006: {
                return 6;
            }
            case 1214007: {
                return 7;
            }
        }
        return payMethod;
    }

    private static Integer payObject_convert(Integer payObject) {
        if (payObject == null) {
            return null;
        }
        switch (payObject) {
            case 1212001: {
                return 1;
            }
            case 1212003: {
                return 3;
            }
            case 1212004: {
                return 4;
            }
            case 1212010: {
                return 10;
            }
            case 1212011: {
                return 11;
            }
            case 1212013: {
                return 13;
            }
        }
        return payObject;
    }

    @Override
    public CheckPrintResult check(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this._receipt(RECEIPT_TYPE_INCOME, check);
    }

    @Override
    public CheckPrintResult checkreturn(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this._receipt(RECEIPT_TYPE_INCOMERETURN, check);
    }

    @Override
    public String status(String pass) throws BGException {
        this.getAuthToken();
        return "ok";
    }

    @Override
    public String name(String pass) throws BGException {
        return "OFD.ru Ferma";
    }

    @Override
    public String getFiscalizatorStatus() throws BGException {
        return "\u0410\u0434\u0440\u0435\u0441: " + this.addr + "\n\u041b\u043e\u0433\u0438\u043d: " + this.login;
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    private Fiscalizator.CheckResult cloud_status(final String ReceiptId) throws BGException {
        logger.debug("cloud status " + ReceiptId + "...");
        String token = this.getAuthToken();
        String url = this.addr + "/kkt/cloud/status";
        JSONObject data = new JSONObject((Map)new HashMap<String, Object>(){
            {
                this.put("Request", new HashMap<String, Object>(){
                    {
                        this.put("ReceiptId", ReceiptId);
                    }
                });
            }
        });
        JSONObject reply = this.doJsonRequest("POST", url, data, token);
        return this.getCheckResultFromJsonDoc(ReceiptId, reply);
    }

    private Fiscalizator.CheckResult getCheckResultFromJsonDoc(String ReceiptId, JSONObject reply) throws BGException {
        String StatusName;
        if (!reply.has("StatusName")) {
            throw new BGException("protocol error: no \"StatusName\" field in status-response");
        }
        switch (StatusName = reply.getString("StatusName")) {
            case "CONFIRMED": {
                return Fiscalizator.CheckResult.ok(ReceiptId, this.fiscalDataConvert(reply));
            }
            case "PROCESSED": {
                return Fiscalizator.CheckResult.wait(ReceiptId);
            }
            case "NEW": {
                return Fiscalizator.CheckResult.wait(ReceiptId);
            }
            case "KKT_ERROR": {
                reply.remove("StatusCode");
                HashSet names = new HashSet(reply.keySet());
                for (String key : names) {
                    if (!reply.isNull(key)) continue;
                    reply.remove(key);
                }
                String errorText = reply.toString(0);
                return Fiscalizator.CheckResult.error(ReceiptId, errorText);
            }
        }
        throw new BGException("protocol error: error value \"StatusName\" field in status-response: \"" + StatusName + "\"");
    }

    private static String truncFrom(String date, String symb) {
        int idx = date.indexOf(symb);
        if (idx >= 0) {
            date = date.substring(0, idx);
        }
        return date;
    }

    private CheckFiscalData fiscalDataConvert(JSONObject payloadData) {
        JSONObject fiscal_dataJson = payloadData.optJSONObject("Device");
        CheckFiscalData cfd = new CheckFiscalData();
        String date = payloadData.optString("ReceiptDateTimeIso", null);
        if (date != null) {
            date = FermaofdruFiscalizator.truncFrom(date, "[");
            date = FermaofdruFiscalizator.truncFrom(date, "+");
            date = FermaofdruFiscalizator.truncFrom(date, ".");
            cfd.time(date, "yyyy-MM-dd'T'HH:mm:ss");
        }
        if (fiscal_dataJson != null) {
            cfd.fn = fiscal_dataJson.optString("FN", null);
            cfd.fd = fiscal_dataJson.optString("FDN", null);
            cfd.fp = fiscal_dataJson.optString("FPD", null);
            cfd.ofd_receipt_url = fiscal_dataJson.optString("OfdReceiptUrl", null);
            cfd.fillAttrs(fiscal_dataJson.toMap(), "FN", "FDN", "FPD", "OfdReceiptUrl");
        }
        return cfd;
    }

    private Fiscalizator.CheckResult cloud_list(final String ReceiptId) throws BGException {
        logger.debug("cloud list for ReceiptId:" + ReceiptId + "...");
        String token = this.getAuthToken();
        String url = this.addr + "/kkt/cloud/list";
        JSONObject data = new JSONObject((Map)new HashMap<String, Object>(){
            {
                this.put("Request", new HashMap<String, Object>(){
                    {
                        this.put("ReceiptId", ReceiptId);
                    }
                });
            }
        });
        JSONArray replyArray = this.doJsonRequestA("POST", url, data, token);
        if (replyArray.length() != 1) {
            String error = "[?] not found document " + ReceiptId + " in cloud_list";
            logger.error(error);
            return Fiscalizator.CheckResult.error(ReceiptId, error);
        }
        JSONObject reply = replyArray.getJSONObject(0);
        return this.getCheckResultFromJsonDoc(ReceiptId, reply);
    }

    private Fiscalizator.CheckResult get_status(String ReceiptId) throws BGException {
        try {
            return this.cloud_status(ReceiptId);
        }
        catch (BGException e) {
            if (e.getMessage().contains("code: 1004")) {
                logger.debug("not found cloud status for " + ReceiptId + ", try cloud list...");
                return this.cloud_list(ReceiptId);
            }
            throw e;
        }
    }

    @Override
    public void checkPending(List<String> pendingIds, long timeout, ThrowingConsumer<Fiscalizator.CheckResult> eachResult) throws BGException {
        for (String pendingId : pendingIds) {
            eachResult.accept((Object)this.get_status(pendingId));
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException e) {
                throw new BGException("InterruptedException");
            }
        }
    }
}

