/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.Calendar;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionCardActionTable
extends ActionBase {
    public void doAction() throws Exception {
        Period period = this.getPeriod();
        int did = this.getIntParameter("did", 0);
        int type = this.getIntParameter("type", 0);
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        CardActionManager actionManager = new CardActionManager(this.con, this.mid);
        for (CardAction action : actionManager.getActionList(did, period, type)) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(action.getId()));
            row.setAttribute("dealer", action.getDealerTitle());
            row.setAttribute("type", action.getType() == 1 ? "\u0432\u044b\u0434\u0430\u0447\u0430" : "\u0432\u043e\u0437\u0432\u0440\u0430\u0442");
            row.setAttribute("time", TimeUtils.format((Calendar)action.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("count", String.valueOf(action.getCardCount()));
            row.setAttribute("summ", Utils.formatCost((float)action.getCardSumma()));
            row.setAttribute("cost", Utils.formatCost((float)action.getCost()));
        }
    }
}

