<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<c:set var="dispatchId"><c:choose><c:when test="${not empty subscription.dispatch}">${subscription.dispatch.id}</c:when><c:otherwise>0</c:otherwise></c:choose></c:set>

<c:choose>
	<c:when test = "${step == 3}">
		<div class="message ok">Рассылка сохранена</div>
	</c:when>
	<c:when test = "${step == 2}">
	<form id="dispatchSubsriptionForm" style="margin: 0px;">
		<input type="hidden" name="operation" value="showSubscriptionEditor"/>
		<input type="hidden" name="subscriptionId" value="${subscription.id}"/>
		<input type="hidden" name="dispatchId" value="${dispatchId}"/>
		<input type="hidden" name="step" value="3"/>
		
		<div class="message title">${subscription.dispatch.title}</div>
		<div style="padding: 0.5em;">Выберите контакты:<br/>
		<c:forEach var="contact" items="${contacts}">
			<c:set var="checked"></c:set><c:forEach var="c" items="${subscription.contacts}"><c:if test="${contact.id==c.id}"><c:set var="checked">checked</c:set></c:if></c:forEach>
			<label><input type="checkbox" name="contactIds" value="${contact.id}" ${checked}/>${contact.value}</label>&nbsp;  
		</c:forEach>
		</div><br/>
		<c:if test="${subscription.dispatch.personal}">
			<!-- personal dispatch data -->
			<div>
			<c:forEach var="condition" items="${subscription.dispatch.conditions}">
			<c:choose>
				<c:when test="${condition.className == 'DispatchBalanceCondition'}">
					<div style="padding: 0.5em;">Укажите условия для баланса, при котором разрешать присылать рассылку
					<div style="width: 100%; padding: 0.5em; margin-left: -0.5em;">
					<c:set var="fromBalance">${condition.moduleId}.from_balance</c:set>
					от <input type="text" size="7" inputmode="numeric" name="prefs.${condition.moduleId}.from_balance" style="text-align: center;" value="${subscription.preferences.map[fromBalance]}">
					<c:set var="toBalance">${condition.moduleId}.to_balance</c:set>
					до <input type="text" size="7" inputmode="numeric" name="prefs.${condition.moduleId}.to_balance" style="text-align: center;" value="${subscription.preferences.map[toBalance]}">
					</div>
					</div>
				</c:when>
				<c:when test="${condition.className == 'voiceip'}">
					<span>Укажите логин VoiceIP:</span><br/>
					<select name="prefs.${condition.moduleId}.voip_amount_login_id">
						<xsl:for-each select="/data/*[name()=concat('data-',$class)]/data/item">
							<option>
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
								<xsl:if test="/data/subscription/preferences/data/entry[key/text()=concat($moduleId,'.voip_amount_login_id')]/value/text()=@id">
									<xsl:attribute name="selected">1</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="@title"/>
							</option>
						</xsl:for-each>
					</select>
				</c:when>
				<c:when test="${condition.className == 'inet'}">
					<span>Укажите сервис Inet:</span><br/>
					<select name="prefs.${condition.moduleId}.inet_service_id">
						<xsl:for-each select="/data/*[name()=concat('data-',$class)]/data/item">
							<option>
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
								<xsl:if test="/data/subscription/preferences/data/entry[key/text()=concat($moduleId,'.inet_service_id')]/value/text()=@id">
									<xsl:attribute name="selected">1</xsl:attribute>
								</xsl:if>
								<xsl:value-of select="concat(@deviceTitle,' / ',@typeTitle)"/>
							</option>
						</xsl:for-each>
					</select>
				</c:when>
			</c:choose>
			</c:forEach>
			</div><br/>
			<div>Дни недели (1-7): 
				<input name="days" type="text" value="${subscription.repeatTime.dayOfWeekAsString}">
				<p>Дни недели, например "1-7" (каждый день), "1,2" (понедельник, вторник), в которые вам будет высылаться рассылка</p>
			</div>
		</c:if>
		<div style="padding: 0.5em;">Ваш комментарий:<br/><textarea name="comment" cols="50" rows="3" style="resize: none; width: 100%; padding: 0.5em; margin-left: -0.5em;">${subscription.comment}</textarea></div>
		<c:if test="${not empty error }"><div class="alert alert-danger" role="alert">${error}</div></c:if>
	</form>
	</c:when>
	<c:otherwise>
		<div class="message confirm">Выберите рассылку:</div>
		<div class="selectType">
			<form id="dispatchSubsriptionForm" enctype="application/x-www-form-urlencoded" style="display: inline;">
			<input type="hidden" name="operation" value="showSubscriptionEditor"/>
			<input type="hidden" name="step" value="2"/>
			<select name="dispatchId">
				<c:forEach var="item" items="${dispatches}">
					<c:set var="selected"><c:if test="${item.id == dispatchId}">selected="selected"</c:if></c:set>
					<option value="${item.id}" ${selected}>${item.title}</option>
				</c:forEach>
			</select>
			</form>
		</div>
	</c:otherwise>
</c:choose>

<script>
{
	const queryParam = { 
			operation: 'showSubscriptionEditor', 
			step: ${step}, 
			subscriptionId: ${subscription.id}, 
			dispatchId: ${dispatchId},
			contactIds: '',
			comment: "${fn:replace(subscription.comment, '\"', '&quot;')}"
		};
	const editor = jQuery("div#dispatchSubscriptionEditor").dialog({ autoOpen : false, modal: true, width: 700, dialogClass: "bgbilling-dialog bgbilling-dialog-user" });
	const dialogDestroy = () => editor.dialog( "destroy" );
	const buttonClick = () => showBlock( 'dispatchSubscriptionEditor', new FormData( jQuery("form#dispatchSubsriptionForm")[0] ), dispatchQuery );
	const cancelButton = { text: "Отмена", click: dialogDestroy };
	
	let buttons = [
		<c:choose>
		<c:when test="${step == 1}">
			cancelButton, { text: "Далее", click: () => { dialogDestroy(); buttonClick(); } }
		</c:when>
		<c:when test = "${step == 2}">
			cancelButton,
			{ text: "Далее",  click: () => { dialogDestroy(); queryParam.step = 3; queryParam.comment = jQuery("#dispatchSubsriptionForm")[0].comment.value; buttonClick(); } }
		</c:when>
		<c:otherwise>
			{ text: "Закрыть", click: () => { dialogDestroy(); showBlock( 'dispatchRoot', 'subscriptions', dispatchQuery ); } }
		</c:otherwise>
		</c:choose>
	];

	editor.dialog( "option","buttons", buttons );
	editor.dialog("open");
}
</script>