/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.client;

import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.common.IntTextField;
import jakarta.xml.ws.Holder;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel_Parameters;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvto;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvtoStatus;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitLog;
import ru.bitel.bgbilling.kernel.contract.limit.common.service.ContractLimitService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ContractSubPanel_Limit
extends ContractSubPanel {
    private BGControlPanelPages logPagePanel = new BGControlPanelPages();
    private BGControlPanelPages avtoPagePanel = new BGControlPanelPages();
    private FloatTextField limitField = new FloatTextField(10);
    private IntTextField periodField = new IntTextField();
    private BGTextField commentTf = new BGTextField();
    private LimitLogTableModel limitLogTableModel = new LimitLogTableModel(LimitLogTableModel.class.getName());
    private LimitAvtoTableModel limitAvtoTableModel = new LimitAvtoTableModel(LimitAvtoTableModel.class.getName());
    private BGUTable limitLogTable = new BGUTable((TableModel)((Object)this.limitLogTableModel));
    private BGUTable limitAvtoTable = new BGUTable((TableModel)((Object)this.limitAvtoTableModel));
    private ButtonGroup avtoStatusBbuttonGroup = new ButtonGroup();
    private ContractLimitService contractLimitService = (ContractLimitService)this.getContext().getPort(ContractLimitService.class);

    public ContractSubPanel_Limit() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.rb_name = ClientUtils.getRBName(ContractPanel_Parameters.class);
        this.getModuleDoc(ContractPanel_Parameters.class.getClass());
        this.limitLogTable.getRowSorter().addRowSorterListener(e -> {
            if (RowSorterEvent.Type.SORT_ORDER_CHANGED.equals((Object)e.getType())) {
                this.setData();
            }
        });
        this.limitLogTable.setSelectionMode(0);
    }

    @Override
    public void setParentComponent(ContractEditor editor) {
        super.setParentComponent(editor);
    }

    private void jbInit() throws Exception {
        this.periodField.setMinValue(0L);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(0, (Component)this.getLimitLogPanel(), (Component)this.getLimitAvtoPanel(), 200L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getEditLimitPanel() {
        JLabel jLabel1 = new JLabel();
        jLabel1.setFont(new Font("Dialog", 1, 16));
        jLabel1.setText("/");
        BGButton buttonOk = new BGButton("OK");
        buttonOk.addActionListener(e -> {
            String period = this.periodField.getText().trim();
            if (period.length() == 0) {
                this.updateLimit(this.limitField.getText().trim(), this.commentTf.getText().trim());
            } else {
                this.updatePeriodLimit(Utils.parseBigDecimal((String)this.limitField.getText().trim(), (BigDecimal)BigDecimal.ZERO), Utils.parseInt((String)period, (int)-1), this.commentTf.getText().trim());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041b\u0438\u043c\u0438\u0442 "));
        panel.add((Component)this.limitField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.periodField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.commentTf, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)jLabel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)buttonOk, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getButtonsLimitPanel() {
        String limits = this.setup.get("dbinfo.contract.limit.values", "=-1000;=-500;=-300;=-150;=-50;=-30;=-10;=0;-5/1;-50/1;-100/1;-15/3;-50/3;-100/3");
        JPanel buttonsLimitPanel = new JPanel(new GridLayout(0, 7));
        StringTokenizer st = new StringTokenizer(limits, ";");
        while (st.hasMoreTokens()) {
            String value = st.nextToken().trim();
            BGButton button = new BGButton();
            button.setText(value);
            button.setActionCommand(value);
            button.addActionListener(e -> {
                String actionCommand = e.getActionCommand();
                if (actionCommand != null) {
                    if (actionCommand.startsWith("=") && actionCommand.length() > 1) {
                        this.updateLimit(actionCommand.substring(1), "");
                    } else {
                        int pos = actionCommand.indexOf("/");
                        if (pos > 0 && actionCommand.length() > pos + 1) {
                            this.updatePeriodLimit(Utils.parseBigDecimal((String)actionCommand.substring(0, pos), (BigDecimal)BigDecimal.ZERO), Utils.parseInt((String)actionCommand.substring(pos + 1), (int)-1), "");
                        }
                    }
                }
            });
            buttonsLimitPanel.add((Component)button);
        }
        return buttonsLimitPanel;
    }

    private JPanel getLimitLogPanel() {
        this.logPagePanel.setBorder((Border)new BGTitleBorder(" \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 "));
        this.logPagePanel.init();
        this.logPagePanel.setPageIndex(1);
        this.logPagePanel.setPageSize(15);
        this.logPagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.searchContractLimitLogList();
            }
        });
        JPanel limitPanel = new JPanel(new GridBagLayout());
        limitPanel.add((Component)this.getEditLimitPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        limitPanel.add((Component)this.logPagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getButtonsLimitPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)limitPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.limitLogTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getLimitAvtoPanel() {
        this.avtoPagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.searchContractLimitAvtoList();
            }
        });
        ActionListener actionListener = e -> this.searchContractLimitAvtoList();
        int gridx = 0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new AvtoButton("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435", "on", true, this.avtoStatusBbuttonGroup, actionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new AvtoButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u044b\u0435", "off", false, this.avtoStatusBbuttonGroup, actionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new AvtoButton("\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0435", "cancel", false, this.avtoStatusBbuttonGroup, actionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new AvtoButton("\u0412\u0441\u0435", "", false, this.avtoStatusBbuttonGroup, actionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.avtoPagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0417\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430"));
        panel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.limitAvtoTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setData() {
        try {
            this.limitField.setText(String.valueOf(this.contractLimitService.getCurrentContractLimit(this.getContractId())));
            this.periodField.setText("");
            this.commentTf.setText("");
            this.searchContractLimitLogList();
            this.searchContractLimitAvtoList();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void searchContractLimitLogList() {
        try {
            String[] stringArray;
            String[] sort = this.limitLogTable.getSort();
            if (sort.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "date:1";
            } else {
                stringArray = sort;
            }
            sort = stringArray;
            SearchResult<ContractLimitLog> searchResult = this.contractLimitService.searchContractLimitLogList(this.getContractId(), null, sort, this.logPagePanel.getPage());
            this.logPagePanel.setPage(searchResult.getPage());
            this.limitLogTableModel.setData(searchResult.getList(), false);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void searchContractLimitAvtoList() {
        try {
            SearchResult<ContractLimitAvto> searchResult = this.contractLimitService.searchContractLimitAvtoList(this.getContractId(), this.avtoStatusBbuttonGroup.getSelection().getActionCommand(), this.limitAvtoTable.getSort(), this.avtoPagePanel.getPage());
            this.avtoPagePanel.setPage(searchResult.getPage());
            this.limitAvtoTableModel.setData(searchResult.getList(), false);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void updateLimit(String limit, String comment) {
        try {
            Holder amountHolder = new Holder((Object)0);
            boolean reject = this.contractLimitService.checkContractLimitUpdate(this.getContractId(), (Holder<Integer>)amountHolder);
            int taskAmount = (Integer)amountHolder.value;
            if (taskAmount > 0) {
                if (reject) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u043b\u0438\u043c\u0438\u0442 \u0431\u0435\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f,\n\u0442\u0430\u043a \u043a\u0430\u043a \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0437\u0430\u0434\u0430\u0447\u0438 \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    return;
                }
                int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0437\u0430\u0434\u0430\u0447\u0438 \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430! \u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b,\n\u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043b\u0438\u043c\u0438\u0442 \u0431\u0435\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0);
                if (result == 1) {
                    return;
                }
            }
            this.contractLimitService.updateContractLimit(this.getContractId(), Utils.parseBigDecimal((String)limit, (BigDecimal)BigDecimal.ZERO), this.commentTf.getText());
            this.setData();
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void updatePeriodLimit(BigDecimal limit, int period, String comment) {
        if (limit != null) {
            try {
                this.contractLimitService.updateContractLimitPeriod(this.getContractId(), limit, period, comment);
                this.setData();
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void deleteItem() {
        List selectedRows = this.limitAvtoTableModel.getSelectedRows();
        if (selectedRows.size() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 \u043d\u0430 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430");
        } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u043d\u0438\u0435(\u044f)?", "\u041e\u0442\u043c\u0435\u043d\u0430 \u0437\u0430\u0434\u0430\u043d\u0438\u044f(\u0439)", 0) == 0) {
            ArrayList<Integer> taskIds = new ArrayList<Integer>();
            for (ContractLimitAvto selectRow : selectedRows) {
                taskIds.add(selectRow.getId());
            }
            try {
                this.contractLimitService.cancelLimitChangeTask(this.getContractId(), taskIds);
                EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.setData();
        }
    }

    class LimitLogTableModel
    extends BGTableModel<ContractLimitLog> {
        public LimitLogTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 150, 150, 150, "date", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 200, 250, "userName", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041b\u0438\u043c\u0438\u0442", 100, 120, 150, "limitValue", false, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0414\u043d\u0435\u0439", 50, 50, 50, "days", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(ContractLimitLog val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("days".equals(identifier)) {
                int daysValue = val.getDays();
                return daysValue == 0 ? "" : String.valueOf(daysValue);
            }
            return super.getValue((Object)val, column);
        }
    }

    class LimitAvtoTableModel
    extends BGTableModel<ContractLimitAvto> {
        private Directory<UserInfo> userDirectory;

        public LimitAvtoTableModel(String name) {
            super(name);
            try {
                this.userDirectory = ContractSubPanel_Limit.this.getContext().getDirectory(UserInfo.class, 0);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430", 150, 150, 150, "date", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430 \u043d\u0430", 150, 200, 250, "value", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 200, -1, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, -1, -1, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(ContractLimitAvto value, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("userId".equals(identifier)) {
                UserInfo user = this.userDirectory.get(value.getUserId());
                return user == null ? null : user.getName();
            }
            if ("status".equals(identifier)) {
                ContractLimitAvtoStatus status = ContractLimitAvtoStatus.ALL.getStatusByCode(value.getStatus());
                return status == null ? value.getStatus() : status.toString();
            }
            return super.getValue((Object)value, column);
        }
    }

    class AvtoButton
    extends JToggleButton {
        public AvtoButton(String title, String actionCommand, boolean selected, ButtonGroup buttonGroup, ActionListener actionListener) {
            super(title);
            this.setActionCommand(actionCommand);
            this.setSelected(selected);
            buttonGroup.add(this);
            this.addActionListener(actionListener);
        }
    }
}

