#!/bin/bash

if [ "$EUID" -ne 0 ]; then
    echo "ERROR: no root"
    exit
fi

SERVICE_FILE=$1

if [ -z "$SERVICE_FILE" ]; then
    SERVICE_LIST=`ls *.service`
    LEN=$(wc -w <<< "$SERVICE_LIST")
    if [ "$LEN" -lt 1 ]; then
        echo "ERROR: not found unit-service?"
        exit
    fi
    if [ "$LEN" -gt 1 ]; then
        echo "ERROR: more than 1 unit-service (specify in the parameter): $SERVICE_LIST"
        exit
    fi
    SERVICE_FILE=$SERVICE_LIST
fi


echo "install unit-service: $SERVICE_FILE"


SCRIPTPATH=$(realpath -s "$0")
APPPATH=$(dirname $(dirname "$SCRIPTPATH"))  # /opt/bgbilling/BGBillingServer
INSTALLPATH=$(dirname $APPPATH)  # /opt/bgbilling

APPLICATION_SH_PATH="$APPPATH/bin/application.sh"


# check exist application.sh
if [ ! -f $APPLICATION_SH_PATH ]; then
    echo "ERROR: application.sh not found ($APPLICATION_SH_PATH)"
    exit
fi


# check not-opt-bgbilling install
if [ "$INSTALLPATH" != "/opt/bgbilling" ]; then
    echo "no standart install?: $APPPATH"
    echo "application.sh: $APPLICATION_SH_PATH"

    # backup orig unit-file
    SERVICE_FILE_BACKUP="$SERVICE_FILE.orig"
    if [ ! -f $SERVICE_FILE_BACKUP ]; then
        echo "backup $SERVICE_FILE to $SERVICE_FILE_BACKUP"
        cp -v $SERVICE_FILE $SERVICE_FILE_BACKUP
    fi

    # patch /opt/bgbilling path to custom INSTALLPATH
    echo "patch $SERVICE_FILE install path"
    sed -i -e "s|/opt/bgbilling|$INSTALLPATH|g" $SERVICE_FILE
fi


# copy&install unit
cp -v $SERVICE_FILE /etc/systemd/system/
systemctl enable $SERVICE_FILE
systemctl daemon-reload
