<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" encoding="UTF-8"/>

<xsl:template match="/data">
######################<br/>
# Отчет по задаче    #<br/>
######################<br/>
<br/>
Данные по задаче:<br/>
---------------------<br/>
Код задачи:		<xsl:value-of select="header/@id"/><br/>
Тип:			<xsl:value-of select="header/@type"/><br/>
Группа:			<xsl:value-of select="header/@group"/><br/>
Текущее состояние:	<xsl:value-of select="header/@status"/><br/>
Открыта: 		<xsl:value-of select="header/@open"/><br/>
Принята:		<xsl:value-of select="header/@accept"/><br/>
Закрыта:		<xsl:value-of select="header/@close"/><br/>

Данные по клиенту:<br/>
---------------------<br/>
Договор:		<xsl:value-of select="contract/@title"/><br/>
Город:			<xsl:value-of select="contract/@city"/><br/>
Квартал:		<xsl:value-of select="contract/@quarter"/><br/>
Улица:			<xsl:value-of select="contract/@street"/><br/>
Дом:			<xsl:value-of select="contract/@house"/><br/>
Квартира:		<xsl:value-of select="contract/@flat"/><br/>
ФИО:			<xsl:value-of select="contract/@fio"/><br/>
Телефон:		<xsl:value-of select="contract/@phone"/><br/>


Описание задачи:<br/>
---------------------<br/>
<xsl:for-each select="comment/row">
<xsl:value-of select="@text"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>

Назначены исполнители:<br/>
---------------------<br/>
<xsl:for-each select="executors/item">
<xsl:value-of select="@title"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>

Примечания:<br/>
---------------------<br/>
<xsl:for-each select="resolution/row">
<xsl:value-of select="@text"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>

</xsl:template>
</xsl:stylesheet>