/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.table;

import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.BGSQueryLogParam;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogEntry;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

public class TableBGSQueryLog
extends BGTableInfoBase {
    public TableBGSQueryLog() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextCenter("\u0412\u0440\u0435\u043c\u044f", "dtime").setWidth(180), BGUTableColumn.buildColumnTextCenter("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", "user").setWidth(180), BGUTableColumn.buildColumnTextCenter("IP", "ipaddr").setWidth(120), BGUTableColumn.buildColumnTextLeft("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "contract"), BGUTableColumn.buildColumnTextLeft("\u041c\u043e\u0434\u0443\u043b\u044c/\u041f\u043b\u0430\u0433\u0438\u043d", "module"), BGUTableColumn.buildColumnTextLeft("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435", "action").setMaxWidth(-1)};
    }

    @Override
    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        BGSQueryLogParam bgsQueryLogParam = new BGSQueryLogParam().setUserId(Utils.parseInt((String)tableParams.optParamValue("userId").orElse("-2"))).setContractIds(Utils.toIntegerList((String)tableParams.optParamValue("contracts").orElse(null))).setActionList(Utils.toList((String)tableParams.optParamValue("actions").orElse(null))).setParamName(tableParams.get("paramName")).setParamValue(tableParams.get("paramValue")).setRegexp(Boolean.valueOf(tableParams.optParamValue("isregexp").orElse("false")));
        SearchResult<BGSQueryLogEntry> searchResult = this.getContext().getService(UserService.class, 0).bgsQueryLog(bgsQueryLogParam, tableParams.getPeriod(), tableParams.getPage());
        this.page = searchResult.getPage();
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        for (BGSQueryLogEntry entry : searchResult.getList()) {
            BGUTableRowData rowData = new BGUTableRowData().addValue(this.getDateTime("dtime", entry.getDate())).addValue("user", entry.getUserName()).addValue("ipaddr", entry.getRemoteAddr()).addValue("contract", entry.getContractTitle()).addValue("module", entry.getModuleName()).addValue("action", entry.getActionTitle()).addValue("query", entry.getQueryString());
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

