/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.table;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccountType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountMode;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseAccountTypeDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseParamData;
import ru.bitel.common.Utils;

public class TableContractAccountParameter
extends BGTableInfoBase {
    private List<SmartHouseParamData> forpostIntercomParams;
    private List<SmartHouseParamData> forpostVideoParams;

    public TableContractAccountParameter() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (String)"title").setWidth(300), BGUTableColumn.buildColumnTextLeft((String)"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", (String)"valueTitle").setWidth(-1)};
        this.forpostIntercomParams = Arrays.asList(new SmartHouseParamData("ManagementAccountId", "list:forpost_intercom_management_account", "\u0423\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u0439 \u0434\u043e\u043c\u043e\u0444\u043e\u043d\u043d\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442", ""), new SmartHouseParamData("DeviceId", "list:forpost_intercom_device", "\u0414\u043e\u043c\u043e\u0444\u043e\u043d", ""), new SmartHouseParamData("Users", "list:forpost_intercom_users", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438", ""), new SmartHouseParamData("AccountSIP", "list:forpost_intercom_sip", "SIP \u0430\u043a\u043a\u0430\u0443\u043d\u0442", ""));
        this.forpostVideoParams = Arrays.asList(new SmartHouseParamData[0]);
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        SmartHouseAccount account;
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        Connection con = this.getContext().getConnection();
        SmartHouseAccountDao accountDao = new SmartHouseAccountDao(con, moduleId);
        SmartHouseAccountTypeDao accountTypeDao = new SmartHouseAccountTypeDao(con, moduleId);
        int accountId = Utils.parseInt((String)tableParams.get("accountId"));
        SmartHouseAccount smartHouseAccount = account = accountId > 0 ? (SmartHouseAccount)accountDao.get(accountId) : new SmartHouseAccount().setType(Utils.parseInt((String)tableParams.get("accountTypeId")));
        if (account.getType() == 0) {
            return rowDatas;
        }
        SmartHouseAccountType accountType = (SmartHouseAccountType)accountTypeDao.get(account.getType());
        SmartHouseAccountMode accountMode = accountType.getMode();
        switch (accountMode) {
            case FORPOST_INTERCOM: {
                for (SmartHouseParamData data : this.forpostIntercomParams) {
                    String value = "";
                    BGUTableRowData rowData = new BGUTableRowData().addValue("name", data.getName()).addValue("type", data.getType()).addValue("title", data.getTitle()).addValue("value", value).addValue("valueTitle", value);
                    rowDatas.add(rowData);
                }
                break;
            }
            case FORPOST_VIDEO: {
                for (SmartHouseParamData data : this.forpostVideoParams) {
                    String value = "";
                    BGUTableRowData rowData = new BGUTableRowData().addValue("name", data.getName()).addValue("type", data.getType()).addValue("title", data.getTitle()).addValue("value", value).addValue("valueTitle", value);
                    rowDatas.add(rowData);
                }
                break;
            }
        }
        return rowDatas;
    }
}

