/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public abstract class SPP_RadiusAttributes
extends ServicePanel
implements PatternModuleTabPanel.PatternModuleTabPanelItemParams {
    protected AttributesPanel attributesPanel = null;
    protected InheritPanel inheritPanel = null;
    protected AttributeSetPanel attributeSetPanel = null;
    private boolean init = false;

    @Override
    public void init(int cid, int mid, int objectid) {
        super.init(cid, mid, objectid);
        if (this.attributesPanel != null) {
            this.attributesPanel.init(this.module, mid);
        }
        if (this.inheritPanel != null) {
            this.inheritPanel.init(this.module, mid);
        }
        if (this.attributeSetPanel != null) {
            this.attributeSetPanel.init(this.module, mid);
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        if (this.attributesPanel != null) {
            this.attributesPanel.init(module, mid);
        }
        if (this.inheritPanel != null) {
            this.inheritPanel.init(module, mid);
        }
        if (this.attributeSetPanel != null) {
            this.attributeSetPanel.init(module, mid);
        }
    }

    public SPP_RadiusAttributes() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    protected abstract void jbInit() throws Exception;

    @Override
    public boolean updateData() {
        if (this.module != null && this.getModuleId() != 0) {
            Document doc;
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("UpdateRadiusInfo");
            request.setAttribute("lid", String.valueOf(this.id));
            if (this.attributesPanel != null) {
                this.attributesPanel.setRequest(request);
            }
            if (this.attributeSetPanel != null) {
                this.attributeSetPanel.setRequest(request);
            }
            if (this.inheritPanel != null) {
                this.inheritPanel.setRequest(request);
            }
            if (Utils.notBlankString((doc = this.getDocument(request)).getDocumentElement().getAttribute("access_error"))) {
                return true;
            }
            return ClientUtils.checkStatus(doc);
        }
        return true;
    }

    private static final String toHexString(String value) {
        char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            buf.append(HEX[(ch & 0xF000) >> 12]);
            buf.append(HEX[(ch & 0xF00) >> 8]);
            buf.append(HEX[(ch & 0xF0) >> 4]);
            buf.append(HEX[ch & 0xF]);
        }
        return buf.toString();
    }

    protected void init() {
        if (this.attributesPanel != null) {
            this.attributesPanel.init();
        }
        if (this.inheritPanel != null) {
            this.inheritPanel.init();
        }
        if (this.attributeSetPanel != null) {
            this.attributeSetPanel.init();
        }
    }

    @Override
    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("RadiusInfo");
        request.setModuleId(this.getModuleId());
        request.setAttribute("lid", String.valueOf(this.id));
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            if (this.inheritPanel != null) {
                this.inheritPanel.updateData(XMLUtils.getElement(doc, "realmOptions"));
            }
            if (this.attributesPanel != null) {
                this.attributesPanel.updateData(XMLUtils.getNode(doc, "table"));
            }
            if (this.attributeSetPanel != null) {
                this.attributeSetPanel.updateData(XMLUtils.getNode(doc, "set_table"));
            }
        }
    }

    @Override
    public void initParams(int mid) {
        if (this.inheritPanel != null) {
            this.inheritPanel.init(this.inheritPanel.getModule(), mid);
        }
        if (this.attributesPanel != null) {
            this.attributesPanel.init(this.attributesPanel.getModule(), mid);
        }
        if (this.attributeSetPanel != null) {
            this.attributeSetPanel.init(this.attributeSetPanel.getModule(), mid);
        }
        this.init();
    }

    @Override
    public void serializeParams(Element element) {
        Element attributes = XMLUtils.createElement(element, "attributes");
        if (this.inheritPanel != null) {
            this.inheritPanel.serializeParams(attributes);
        }
        if (this.attributesPanel != null) {
            this.attributesPanel.serializeParams(attributes);
        }
        if (this.attributeSetPanel != null) {
            this.attributeSetPanel.serializeParams(attributes);
        }
    }

    @Override
    public void setParams(Element element) throws Exception {
        if (this.inheritPanel != null) {
            Element realmOptions = XMLUtils.selectElement(element, "attributes/realmOptions");
            this.inheritPanel.updateData(realmOptions != null ? realmOptions : element);
        }
        if (this.attributesPanel != null) {
            this.attributesPanel.updateData(XMLUtils.selectElement(element, "attributes/table"));
        }
        if (this.attributeSetPanel != null) {
            this.attributeSetPanel.updateData(XMLUtils.selectElement(element, "attributes/set_table"));
        }
    }

    public static class AttributesPanel
    extends BGPanel {
        private final boolean withRealm;
        private BGTable table = new BGTable();
        private JComboBox<ComboBoxItem> jComboBox1 = new JComboBox();
        private JTextField jTextField1 = new JTextField();
        private BGComboBox<ComboBoxItem> realmCB = new BGComboBox();

        public AttributesPanel(boolean withRealm) {
            this.withRealm = withRealm;
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            if (withRealm) {
                this.table.setHeader(this.rb_name, this.moduleDoc, "radius_attr");
            } else {
                this.table.setHeader(this.rb_name, this.moduleDoc, "radius_attr2");
            }
        }

        private void jbInit() throws Exception {
            this.jTextField1.setMinimumSize(new Dimension(114, 24));
            this.jTextField1.setPreferredSize(new Dimension(114, 24));
            this.jTextField1.setCaretPosition(0);
            this.jTextField1.setText("");
            this.jTextField1.setColumns(10);
            BGButton bGButton1 = new BGButton();
            BGButton bGButton2 = new BGButton();
            bGButton1.setIcon(ClientUtils.getIcon("item_add.png"));
            bGButton1.setMargin(new Insets(0, 0, 0, 0));
            bGButton1.setText("");
            bGButton1.addActionListener(e -> this.bGButton1_actionPerformed(e));
            bGButton2.setIcon(ClientUtils.getIcon("item_delete.png"));
            bGButton2.setMargin(new Insets(0, 0, 0, 0));
            bGButton2.setText("");
            bGButton2.addActionListener(e -> this.bGButton2_actionPerformed(e));
            BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.table_mouseClicked((MouseEvent)e));
            this.jComboBox1.setEditable(true);
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            jPanel4.add(this.jComboBox1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            jPanel4.add((Component)this.jTextField1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            if (this.withRealm) {
                jPanel4.add(this.realmCB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
                jPanel4.add((Component)bGButton1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
                jPanel4.add((Component)bGButton2, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                jPanel4.add((Component)bGButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
                jPanel4.add((Component)bGButton2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.setLayout(new GridBagLayout());
            this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)jPanel4, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        private void table_mouseClicked(MouseEvent e) {
            int selRow = this.table.getSelectedRow();
            RadiusAttribute ra = this.getRadiusAttributeFromRow(selRow);
            this.jComboBox1.setSelectedItem(ra.attrName);
            this.jTextField1.setText(ra.attrValue);
            ClientUtils.setComboBoxSelection(this.realmCB, ra.realm);
        }

        private RadiusAttribute getRadiusAttributeFromRow(int row) {
            TableModel model = this.table.getModel();
            RadiusAttribute ra = new RadiusAttribute();
            String name = (String)model.getValueAt(row, 0);
            String value = (String)model.getValueAt(row, 1);
            ra.attrName = name;
            ra.attrValue = value;
            if (this.withRealm) {
                String realm = (String)model.getValueAt(row, 2);
                if (realm == null) {
                    realm = "default";
                }
                ra.realm = realm;
            }
            return ra;
        }

        private void bGButton1_actionPerformed(ActionEvent e) {
            ComboBoxItem it;
            Object item = this.jComboBox1.getSelectedItem();
            String name = this.jTextField1.getText().trim();
            String realm = this.withRealm ? ((it = this.realmCB.getSelectedItem()) != null ? it.getObject().toString() : "") : "";
            if (item != null && !"".equals(name) && !"".equals(item.toString().trim())) {
                String atribut = item.toString();
                Vector<String> node = new Vector<String>();
                node.add(0, atribut);
                node.add(1, name);
                if (this.withRealm) {
                    node.add(2, realm);
                }
                this.table.getBGTableModel().addRow(node);
            }
        }

        private void bGButton2_actionPerformed(ActionEvent e) {
            int row = this.table.getSelectedRow();
            if (row > -1) {
                this.table.getBGTableModel().removeRow(row);
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            }
        }

        public void init() {
            Request request = new Request().setModule("call").setAction("RadiusAttributeTypeList").setModuleId(this.getModuleId());
            Document doc = this.getDocument(request);
            ClientUtils.buildComboBox(this.jComboBox1, XMLUtils.getNode(doc, "types"), null);
            this.jComboBox1.setSelectedIndex(-1);
            if (this.withRealm) {
                request = new Request().setModule("call").setModuleId(this.getModuleId()).setAction("RealmList");
                doc = this.getDocument(request);
                Node node = XMLUtils.getNode(doc, "realms");
                ClientUtils.buildComboBox(this.realmCB, node, null);
            }
        }

        public void updateData(Node tableNode) {
            if (tableNode == null) {
                this.table.removeRows();
            } else {
                this.table.updateData(tableNode);
            }
        }

        public void setRequest(Request req) {
            StringBuilder atribut = new StringBuilder();
            StringBuilder value = new StringBuilder();
            StringBuilder realm = new StringBuilder();
            int n = this.table.getBGTableModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                RadiusAttribute ra = this.getRadiusAttributeFromRow(i);
                atribut.append(SPP_RadiusAttributes.toHexString(ra.attrName));
                atribut.append(", ");
                value.append(SPP_RadiusAttributes.toHexString(ra.attrValue));
                value.append(", ");
                if (!this.withRealm) continue;
                realm.append(SPP_RadiusAttributes.toHexString(ra.realm));
                realm.append(", ");
            }
            req.setAttribute("atribut", atribut.toString().trim());
            req.setAttribute("value", value.toString().trim());
            if (this.withRealm) {
                req.setAttribute("realm", realm.toString().trim());
            }
        }

        public void serializeParams(Element element) {
            Element tableEl = XMLUtils.createElement(element, "table");
            Element data = XMLUtils.createElement(tableEl, "data");
            int n = this.table.getBGTableModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                RadiusAttribute ra = this.getRadiusAttributeFromRow(i);
                Element row = XMLUtils.createElement(data, "attr");
                row.setAttribute("attribute", ra.attrName);
                row.setAttribute("value", ra.attrValue);
                if (!this.withRealm) continue;
                row.setAttribute("realm", ra.realm);
            }
        }

        private class RadiusAttribute {
            public String attrName;
            public String attrValue;
            public String realm;

            private RadiusAttribute() {
            }
        }
    }

    public static class InheritPanel
    extends BGPanel {
        private JRadioButton globalAndLocal_RB = new JRadioButton();
        private JRadioButton local_RB = new JRadioButton();
        private BGComboBox<ComboBoxItem> realmGroup_CB = new BGComboBox();

        public InheritPanel() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.globalAndLocal_RB.setSelected(true);
            this.globalAndLocal_RB.setText("\u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0435+\u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0435");
            this.local_RB.setText("\u0442\u043e\u043b\u044c\u043a\u043e \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0435");
            this.realmGroup_CB.setMinimumSize(new Dimension(4, 24));
            this.realmGroup_CB.setPreferredSize(new Dimension(63, 24));
            this.setBorder(new BGTitleBorder(" \u041f\u0440\u0430\u0432\u0438\u043b\u0430 \u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f "));
            this.add((Component)this.globalAndLocal_RB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            ButtonGroup buttonGroup1 = new ButtonGroup();
            buttonGroup1.add(this.local_RB);
            buttonGroup1.add(this.globalAndLocal_RB);
            this.add((Component)new JLabel("\u041f\u0440\u0438\u0441\u0432\u0430\u0438\u0432\u0430\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.add(this.realmGroup_CB, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 50, 5, 5), 0, 0));
            this.add((Component)this.local_RB, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 REALM\u043e\u0432:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 50, 0, 0), 0, 0));
        }

        public void setRequest(Request req) {
            ComboBoxItem item = this.realmGroup_CB.getSelectedItem();
            if (item != null) {
                req.setAttribute("realm_group", item.getObject().toString());
            }
            req.setAttribute("rp_mode", this.globalAndLocal_RB.isSelected() ? "0" : "1");
        }

        public void serializeParams(Element element) {
            Element data = XMLUtils.createElement(element, "realmOptions");
            ComboBoxItem item = this.realmGroup_CB.getSelectedItem();
            if (item != null) {
                data.setAttribute("realm_group", item.getObject().toString());
            }
            data.setAttribute("rp_mode", this.globalAndLocal_RB.isSelected() ? "0" : "1");
        }

        public void init() {
            Request req = new Request();
            req.setModule("call");
            req.setModuleId(this.getModuleId());
            req.setAction("RealmGroupList");
            Document doc = this.getDocument(req);
            ClientUtils.buildComboBox(this.realmGroup_CB, XMLUtils.getNode(doc, "realmgrs"), null);
        }

        public void updateData(Element realmOptions) {
            String rpMode = realmOptions.getAttribute("rp_mode");
            String realmGroup = realmOptions.getAttribute("realm_group");
            if ("1".equals(rpMode)) {
                this.local_RB.setSelected(true);
            } else {
                this.globalAndLocal_RB.setSelected(true);
            }
            ClientUtils.setComboBoxSelection(this.realmGroup_CB, realmGroup);
        }
    }

    public static class AttributeSetPanel
    extends BGPanel {
        private BGTable setTable = new BGTable();
        private BGComboBox<ComboBoxItem> set_CB = new BGComboBox();
        private BGComboBox<ComboBoxItem> setRealm_CB = new BGComboBox();

        public AttributeSetPanel() {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.setTable.setHeader(this.rb_name, this.moduleDoc, "radius_attr_set");
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            BGButton setbGButton1 = new BGButton();
            BGButton setbGButton2 = new BGButton();
            setbGButton1.setIcon(ClientUtils.getIcon("item_add.png"));
            setbGButton1.setMargin(new Insets(0, 0, 0, 0));
            setbGButton1.setText("");
            setbGButton1.addActionListener(e -> this.setbGButton1_actionPerformed(e));
            setbGButton2.setIcon(ClientUtils.getIcon("item_delete.png"));
            setbGButton2.setMargin(new Insets(0, 0, 0, 0));
            setbGButton2.setText("");
            setbGButton2.addActionListener(e -> this.setbGButton2_actionPerformed(e));
            JPanel editPanel = new JPanel(new GridBagLayout());
            this.add((Component)new JScrollPane(this.setTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)editPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            editPanel.add(this.set_CB, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            editPanel.add(this.setRealm_CB, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            editPanel.add((Component)setbGButton1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            editPanel.add((Component)setbGButton2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void setbGButton1_actionPerformed(ActionEvent e) {
            ComboBoxItem it = this.setRealm_CB.getSelectedItem();
            if (it == null) {
                return;
            }
            String realm = it.getObject().toString();
            it = this.set_CB.getSelectedItem();
            if (it == null) {
                return;
            }
            String setId = it.getObject().toString();
            String setTitle = it.toString();
            if (setId != null && realm != null) {
                Vector<String> node = new Vector<String>();
                node.add(0, setId);
                node.add(1, setTitle);
                node.add(2, realm);
                this.setTable.getBGTableModel().addRow(node);
            }
        }

        private void setbGButton2_actionPerformed(ActionEvent e) {
            int row = this.setTable.getSelectedRow();
            if (row > -1) {
                this.setTable.getBGTableModel().removeRow(row);
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            }
        }

        public void init() {
            Request req = new Request();
            req.setModule("call");
            req.setModuleId(this.getModuleId());
            req.setAction("RealmList");
            Document doc = this.getDocument(req);
            Node node = XMLUtils.getNode(doc, "realms");
            ClientUtils.buildComboBox(this.setRealm_CB, node, null);
            req = new Request();
            req.setModule("call");
            req.setModuleId(this.getModuleId());
            req.setAction("AttrSetList");
            doc = this.getDocument(req);
            ClientUtils.buildComboBox(this.set_CB, XMLUtils.getNode(doc, "sets"), null);
        }

        public void setRequest(Request req) {
            StringBuilder setId = new StringBuilder();
            StringBuilder setRealm = new StringBuilder();
            int n = this.setTable.getBGTableModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                setId.append((String)this.setTable.getValueAt(i, 0));
                setId.append(", ");
                setRealm.append(SPP_RadiusAttributes.toHexString((String)this.setTable.getValueAt(i, 2)));
                setRealm.append(", ");
            }
            req.setAttribute("setIds", setId.toString().trim());
            req.setAttribute("setRealms", setRealm.toString().trim());
        }

        public void serializeParams(Element element) {
            Element tableEl = XMLUtils.createElement(element, "set_table");
            Element data = XMLUtils.createElement(tableEl, "data");
            int n = this.setTable.getBGTableModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                Element row = XMLUtils.createElement(data, "set");
                row.setAttribute("setId", (String)this.setTable.getValueAt(i, 0));
                row.setAttribute("setTitle", (String)this.setTable.getValueAt(i, 1));
                row.setAttribute("realm", (String)this.setTable.getValueAt(i, 2));
            }
        }

        public void updateData(Node table) {
            if (table == null) {
                this.setTable.removeRows();
            } else {
                this.setTable.updateData(table);
            }
        }
    }
}

