/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.concurrent.TimeUnit;

public class FrequencyCounter {
    private final int period;
    private final long[] amount;
    private final long delimeter;
    private long currentPeriod = 0L;

    public FrequencyCounter(long period, TimeUnit unit) {
        TimeUnit lessUnit = FrequencyCounter.getLessTimeUnit(unit);
        this.period = (int)lessUnit.convert(period, unit) + 1;
        this.amount = new long[this.period];
        this.delimeter = TimeUnit.MILLISECONDS.convert(1L, lessUnit);
    }

    private static TimeUnit getLessTimeUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return TimeUnit.HOURS;
            }
            case HOURS: {
                return TimeUnit.MINUTES;
            }
        }
        return TimeUnit.SECONDS;
    }

    public synchronized void add(long nowMillis, long count) {
        long currentPeriod = nowMillis / this.delimeter;
        long delta = currentPeriod - this.currentPeriod;
        if (delta > 0L) {
            this.clear((int)currentPeriod % this.period, (int)delta);
        }
        this.currentPeriod = currentPeriod;
        int n = (int)(currentPeriod % (long)this.period);
        this.amount[n] = this.amount[n] + count;
    }

    public synchronized long addAndGet(long nowMillis, long count) {
        this.add(nowMillis, count);
        long result = 0L;
        for (int i = 0; i < this.period; ++i) {
            result += this.amount[i];
        }
        return result;
    }

    public synchronized long get(long nowMillis) {
        return this.addAndGet(nowMillis, 0L);
    }

    private void clear(int pos, int length) {
        int i;
        for (i = pos; i >= 0 && length-- > 0; --i) {
            this.amount[i] = 0L;
        }
        for (i = this.period - 1; length-- > 0 && i > pos; --i) {
            this.amount[i] = 0L;
        }
    }

    public String toString() {
        StringBuilder a = new StringBuilder();
        for (int i = 0; i < this.amount.length; ++i) {
            a.append(i > 0 ? ", " : "").append(this.amount[i]);
        }
        return String.format("period = %s, delimeter = %s, currentPeriod = %s\namount = [%s]", this.period, this.delimeter, this.currentPeriod, a.toString());
    }

    public static void main(String[] args) {
        FrequencyCounter counter = new FrequencyCounter(60L, TimeUnit.SECONDS);
        System.out.println(counter);
        for (int a = 0; a < 60; ++a) {
            counter.add(10000 + 1000 * a, a);
        }
        System.out.println(counter);
        counter.add(72000L, 100L);
        System.out.println(counter);
        counter.add(73000L, 101L);
        System.out.println(counter);
        counter.add(95000L, 102L);
        System.out.println(counter);
        System.out.println(counter.get(95000L));
        System.out.println(counter);
    }
}

