/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.npay.common.bean.FilterMode;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.bean.object.ServiceObjectManager;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class DayServiceFilterTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    protected FilterMode filterMode = FilterMode.ALL;
    protected int serviceId = 0;
    protected int beforeDayValue = 1;
    protected int afterDayValue = 1;
    protected int beforeValue = 1;
    protected int afterValue = 1;

    public DayServiceFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.serviceId = parameterMap.getInt("serviceId", 0);
        this.filterMode = FilterMode.valueOf((String)parameterMap.get("filterMode", FilterMode.ALL.name()));
        this.beforeDayValue = parameterMap.getInt("beforeDayValue", 1);
        this.afterDayValue = parameterMap.getInt("afterDayValue", parameterMap.getInt("dayValue", 1));
        this.beforeValue = parameterMap.getInt("beforeValue", 1);
        this.afterValue = parameterMap.getInt("afterValue", 1);
    }

    protected int executeImpl(Long treeNodeId, NPayTariffRequest tariffRequest, NPayTariffContext tariffContext) {
        int contractId = tariffRequest.contractId;
        int result = 0;
        try {
            Period period = new Period(tariffRequest.getMonthStart().getTime(), tariffRequest.getMonthEnd().getTime());
            List<ServiceObject> list = new ServiceObjectManager(tariffRequest.getConnection(), tariffRequest.moduleId).getServiceObjectList(contractId, this.serviceId, period);
            if (!list.isEmpty()) {
                switch (this.filterMode) {
                    case ALL: {
                        result = list.stream().anyMatch(s -> !(s.getDate1() != null && s.getDate1().getTime() > period.getDateFrom().getTime() || s.getDate2() != null && s.getDate2().getTime() < TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)period.getDateTo()).getTime())) ? 1 : 0;
                        break;
                    }
                    case PERIOD: {
                        result = list.stream().anyMatch(s -> this.period((ServiceObject)s, tariffRequest.getServiceObject(), period)) ? 1 : 0;
                        break;
                    }
                    case DAY_BEFORE: {
                        result = list.stream().anyMatch(s -> this.day((ServiceObject)s, period) <= this.beforeDayValue) ? 1 : 0;
                        break;
                    }
                    case DAY: 
                    case DAY_AFTER: {
                        result = list.stream().anyMatch(s -> this.day((ServiceObject)s, period) >= this.afterDayValue) ? 1 : 0;
                        break;
                    }
                    case BEFORE: {
                        result = list.stream().anyMatch(s -> this.day((ServiceObject)s, tariffRequest.getTime()) <= this.beforeValue) ? 1 : 0;
                        break;
                    }
                    case AFTER: {
                        result = list.stream().anyMatch(s -> this.day((ServiceObject)s, tariffRequest.getTime()) >= this.afterValue) ? 1 : 0;
                        break;
                    }
                    case LAST: {
                        result = list.stream().anyMatch(s -> this.lastDay(s.getDate2(), tariffRequest.getTime())) ? 1 : 0;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean period(ServiceObject serviceObject, ServiceObject filterServiceObject, Period period) {
        Date from1 = serviceObject.getDate1() == null || serviceObject.getDate1().before(period.getDateFrom()) ? period.getDateFrom() : serviceObject.getDate1();
        Date to1 = serviceObject.getDate2() == null || serviceObject.getDate2().after(period.getDateTo()) ? period.getDateTo() : serviceObject.getDate2();
        Date from2 = filterServiceObject.getDate1() == null || filterServiceObject.getDate1().before(period.getDateFrom()) ? period.getDateFrom() : filterServiceObject.getDate1();
        Date to2 = filterServiceObject.getDate2() == null || filterServiceObject.getDate2().after(period.getDateTo()) ? period.getDateTo() : filterServiceObject.getDate2();
        return from1.equals(from2) && to1.equals(to2);
    }

    private int day(ServiceObject serviceObject, Period period) {
        Date start = serviceObject.getDate1() == null || serviceObject.getDate1().before(period.getDateFrom()) ? period.getDateFrom() : serviceObject.getDate1();
        Date to = serviceObject.getDate2() == null || serviceObject.getDate2().after(period.getDateTo()) ? period.getDateTo() : serviceObject.getDate2();
        return TimeUtils.convertDateToLocalDate((Date)to).getDayOfMonth() - TimeUtils.convertDateToLocalDate((Date)start).getDayOfMonth() + 1;
    }

    private int day(ServiceObject serviceObject, Calendar calculateDay) {
        if (serviceObject.getDate1() == null) {
            return Integer.MAX_VALUE;
        }
        return (int)((calculateDay.getTime().getTime() - serviceObject.getDate1().getTime()) / 1000L / 86400L);
    }

    private boolean lastDay(Date serviceDate, Calendar calculateDay) {
        if (serviceDate == null) {
            return false;
        }
        LocalDate date1 = TimeUtils.convertDateToLocalDate((Date)serviceDate);
        LocalDate date2 = TimeUtils.convertDateToLocalDate((Date)calculateDay.getTime());
        return date1.equals(date2);
    }
}

