/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import bitel.billing.server.radius.RadiusSetup;
import bitel.billing.server.util.SnmpUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextv2c;

public abstract class SNMPNasConnectionInspector
extends NasConnectionInspector {
    private static final Logger logger = LogManager.getLogger();
    protected final SnmpContext context;
    protected final String snmp_oid_kill;
    protected final String snmp_oid_check;

    public SNMPNasConnectionInspector(RadiusSetup setup, InetAddress nasIPAddress, byte[] secret, Map<String, ? extends NasConnection<?>> connection, ParameterMap params, NasConnectionInspector old) throws IOException {
        super((DefaultServerSetup)setup, nasIPAddress, secret, connection, params, old);
        String prefix = "nas.inspector.snmp.";
        int snmp_port = params.getInt("nas.inspector.snmp.port", 161);
        String snmp_community = params.get("nas.inspector.snmp.community", null);
        String killerPrefix = "nas.inspector.snmp.kill.";
        this.snmp_oid_kill = params.get(killerPrefix + "oid", null);
        String checkPrefix = "nas.inspector.snmp.check.";
        this.snmp_oid_check = params.get(checkPrefix + "oid", null);
        String version = params.get("snmp.version", "1");
        this.context = version.equals("1") ? new SnmpContext(nasIPAddress.getHostAddress(), snmp_port) : (version.equals("2") || version.equals("2c") ? new SnmpContextv2c(nasIPAddress.getHostAddress(), snmp_port) : null);
        if (this.context == null) {
            logger.error("Can't create context for SNMP version " + version);
        } else {
            this.context.setCommunity(snmp_community);
            SnmpUtils.setBufferSizes((SnmpContext)this.context, (int)params.getInt("nas.inspector.snmp..buffer.in", 4), (int)params.getInt("nas.inspector.snmp..buffer.out", 4));
        }
    }

    protected String getDecSessionId(String hexSessionID) {
        String result = "0";
        try {
            result = String.valueOf(Long.parseLong(hexSessionID, 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Deprecated
    protected String getDecSessionID(String hexSessionId) {
        return this.getDecSessionId(hexSessionId);
    }

    @Override
    protected void preDestroy() {
        super.preDestroy();
        this.context.destroy();
    }
}

