/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.client.utils;

import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.loader.client.UtilPanel;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;

public class MovePhonePointToVoiceAccountPanel
extends UtilPanel {
    public static final String TITLE = "Phone: \u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432 \u0432 Voice";
    public static final String CARD_NAME = "movePhonePointToVoiceAccount";
    private BGUComboBox<IdTitle> phoneModules = new BGUComboBox();
    private BGUComboBox<IdTitle> voiceModules = new BGUComboBox();
    private BGUComboBox<IdTitle> voiceAccountSpecs = new BGUComboBox();
    private BGControlPanelDateNoB moveWithDate = new BGControlPanelDateNoB();
    private JTabbedPane tabbedPane = new JTabbedPane();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new UtilPanel.PanelTitleLabel(TITLE), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(this.getColumnPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(15, 5, 2, 5), 0, 0));
        this.add(this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getColumnPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2, 10, 0));
        panel.add(this.getParamPanel());
        panel.add(this.getImportResultPanel());
        return panel;
    }

    private JPanel getParamPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getModulePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getContractFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getModulePanel() {
        this.voiceModules.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.loadVoiceAccountSpecs();
            }
        });
        this.voiceAccountSpecs.addItemListener(e -> {});
        this.loadVoiceAccountSpecs();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c Phone:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c Voice:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 Voice:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0435\u043d\u043e\u0441\u0438\u0442\u044c \u0441 \u0434\u0430\u0442\u044b:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.phoneModules, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)this.voiceModules, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)this.voiceAccountSpecs, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)this.moveWithDate, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getContractFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    @Override
    protected JPanel getButtonPanel() {
        BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
        okCancelPanel.addActionListener(actionEvent -> {
            if (actionEvent.getActionCommand().equals("ok")) {
                this.doUtil();
            } else {
                this.doClearForm();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)okCancelPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void loadVoiceAccountSpecs() {
        Async.of(() -> {
            ArrayList<IdTitle> items = new ArrayList<IdTitle>();
            items.add(new IdTitle(0, "--- \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ---"));
            IdTitle module = (IdTitle)this.voiceModules.getSelectedItem();
            if (module != null && module.getId() > 0) {
                try {
                    items.addAll(((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class, module.getId())).voiceAccountSpecTitleList());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.voiceAccountSpecs.setData(items);
        });
    }

    private void initModules(BGUComboBox<IdTitle> modules, String type) {
        Async.of(() -> {
            ArrayList<IdTitle> moduleItems = new ArrayList<IdTitle>();
            moduleItems.add(new IdTitle(0, "--- \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ---"));
            moduleItems.addAll(((ModuleService)((ClientContext)this.getContext()).getWebService(ModuleService.class, 0)).moduleByNameList(type).stream().map(IdTitle::toIdTitle).toList());
            modules.setData(moduleItems);
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.initModules(this.phoneModules, "phone");
            this.initModules(this.voiceModules, "voice");
        });
    }
}

