/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.util.ClientUtils;

public class BGControlPanelHistory
extends JPanel {
    private List<String> historyList = new ArrayList<String>();
    private int currentHistotyIndex = -1;
    private ActionListener actionListener;
    private BGButton buttonHistoryBackward = new BGButton();
    private BGButton buttonHistoryBackwardList = new BGButton();
    private BGButton buttonHistoryForward = new BGButton();
    private BGButton buttonHistoryForwardList = new BGButton();
    private int maxHistoryLenght = 10;
    private static final int MAX_TEXTLEN_POPUP = 50;

    public BGControlPanelHistory() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.buttonHistoryBackward.setIcon(ClientUtils.getIcon("arrow_left.png"));
        this.buttonHistoryBackward.addActionListener(e -> {
            if (this.currentHistotyIndex > 0) {
                --this.currentHistotyIndex;
            }
            this.resetEnabled();
            this.actionListener.actionPerformed(e);
        });
        Dimension d = this.buttonHistoryBackwardList.getPreferredSize();
        d.width = 16;
        this.buttonHistoryBackwardList.setPreferredSize(d);
        this.buttonHistoryBackwardList.setBorder(null);
        this.buttonHistoryBackwardList.setIcon(ClientUtils.getIcon("item_down.png"));
        this.buttonHistoryBackwardList.addActionListener(e -> {
            this.showPopupMenu(DirectMode.BACK);
            this.resetEnabled();
            this.actionListener.actionPerformed(e);
        });
        this.buttonHistoryForward.setIcon(ClientUtils.getIcon("arrow_right.png"));
        this.buttonHistoryForward.addActionListener(e -> {
            if (this.currentHistotyIndex < this.historyList.size() - 1) {
                ++this.currentHistotyIndex;
            }
            this.resetEnabled();
            this.actionListener.actionPerformed(e);
        });
        d = this.buttonHistoryForwardList.getPreferredSize();
        d.width = 16;
        this.buttonHistoryForwardList.setPreferredSize(d);
        this.buttonHistoryForwardList.setBorder(null);
        this.buttonHistoryForwardList.setIcon(ClientUtils.getIcon("item_down.png"));
        this.buttonHistoryForwardList.addActionListener(e -> {
            this.showPopupMenu(DirectMode.FORWARD);
            this.resetEnabled();
            this.actionListener.actionPerformed(e);
        });
        this.add((Component)this.buttonHistoryBackward, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonHistoryBackwardList, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonHistoryForward, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonHistoryForwardList, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.resetEnabled();
    }

    protected void showPopupMenu(DirectMode directMode) {
        JPopupMenu menu = new JPopupMenu();
        int indexBegin = -1;
        int indexEnd = -1;
        BGButton invokerControl = null;
        switch (directMode) {
            case BACK: {
                indexBegin = 0;
                indexEnd = this.currentHistotyIndex - 1;
                invokerControl = this.buttonHistoryBackward;
                break;
            }
            case FORWARD: {
                indexBegin = this.currentHistotyIndex + 1;
                indexEnd = this.historyList.size() - 1;
                invokerControl = this.buttonHistoryForward;
            }
        }
        int index = indexBegin;
        while (index <= indexEnd) {
            String historyItem = this.historyList.get(index);
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(historyItem.substring(0, Math.min(historyItem.length(), 50)));
            int findex = index++;
            menuItem.addActionListener(e -> {
                this.currentHistotyIndex = findex;
                this.resetEnabled();
                this.actionListener.actionPerformed(e);
            });
            menu.add(menuItem);
        }
        menu.show(invokerControl, 0, invokerControl.getHeight());
    }

    private void resetEnabled() {
        this.buttonHistoryBackward.setEnabled(this.currentHistotyIndex >= 1);
        this.buttonHistoryBackwardList.setEnabled(this.currentHistotyIndex >= 1);
        this.buttonHistoryForward.setEnabled(this.currentHistotyIndex >= 0 && this.currentHistotyIndex <= this.historyList.size() - 2);
        this.buttonHistoryForwardList.setEnabled(this.currentHistotyIndex >= 0 && this.currentHistotyIndex <= this.historyList.size() - 2);
    }

    public void addToHistory(String item) {
        if (!(item == null || this.historyList.size() != 0 && this.historyList.get(this.historyList.size() - 1).equals(item))) {
            this.historyList.add(item);
            this.currentHistotyIndex = this.historyList.size() - 1;
            if (this.historyList.size() > this.maxHistoryLenght) {
                this.historyList.remove(0);
                --this.currentHistotyIndex;
            }
        }
        this.resetEnabled();
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public String getCurrentItem() {
        String ret = null;
        if (this.currentHistotyIndex != -1) {
            ret = this.historyList.get(this.currentHistotyIndex);
        }
        return ret;
    }

    public void setMaxHistoryLenght(int maxHistoryLenght) {
        this.maxHistoryLenght = maxHistoryLenght;
    }

    private static enum DirectMode {
        BACK,
        FORWARD;

    }
}

