/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean.ip;

import bitel.billing.server.admin.resource.bean.ResourceManager;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRange;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRangeUse;
import bitel.billing.server.util.Iter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public abstract class IPResourceRangeManager
extends ResourceManager<IPResourceRange> {
    public IPResourceRangeManager(Connection con, int mid) {
        super(con, mid);
    }

    @Override
    public void updateResource(IPResourceRange range) throws SQLException {
        Objects.requireNonNull(range);
        boolean update = range.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET date1=?, date2=?, ip1=?, ip2=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)range.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((java.util.Date)range.getDateTo()));
            ps.setLong(index++, range.getIp1());
            ps.setLong(index++, range.getIp2());
            if (update) {
                ps.setInt(index++, range.getId());
            }
            ps.executeUpdate();
            if (!update) {
                range.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public List<IPResourceRange> getResourceList(int categoryId, long ip1, long ip2, boolean mask) throws SQLException {
        ArrayList<IPResourceRange> result = new ArrayList<IPResourceRange>();
        StringBuilder query = new StringBuilder().append("SELECT * FROM ").append(this.tableName).append(" WHERE 1>0 ");
        this.addFilters(categoryId, ip1, ip2, query, mask);
        query.append(" ORDER BY ip1");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getResourceFromRs(rs));
            }
        }
        return result;
    }

    @Override
    protected IPResourceRange getResourceFromRs(ResultSet rs) throws SQLException {
        IPResourceRange result = new IPResourceRange();
        this.loadStandartResourceFromRs(rs, result);
        result.setIp1(rs.getLong("ip1"));
        result.setIp2(rs.getLong("ip2"));
        return result;
    }

    protected void addFilters(int categoryId, long ip1, long ip2, StringBuilder query, boolean mask) {
        if (categoryId > 0) {
            query.append(" AND category_id=");
            query.append(categoryId);
        }
        if (mask) {
            if (ip1 != 0L) {
                query.append(" AND (ip1>>" + (32L - ip2) + ") = (" + ip1 + ">>" + (32L - ip2) + ")");
                query.append(" AND (ip2>>" + (32L - ip2) + ") = (" + ip1 + ">>" + (32L - ip2) + ")");
            }
        } else if (ip2 != 0L) {
            query.append(" AND ip1<=" + ip2 + " AND ip2>=" + ip1);
        }
    }

    @Override
    protected String getTableName() {
        return "ip_resource_range";
    }

    public void checkResource(long ip1, long ip2, Calendar date) throws Exception {
        String query = "SELECT ip1, ip2 FROM " + this.tableName + " WHERE (?<=ip2) AND (?>=ip1) AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setLong(index++, ip1);
            ps.setLong(index++, ip2);
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    long _ip1 = rs.getLong(1);
                    long _ip2 = rs.getLong(2);
                    throw new BGMessageException("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d " + IPUtils.convertLongIpToString((long)ip1) + "-" + IPUtils.convertLongIpToString((long)ip2) + " \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c " + IPUtils.convertLongIpToString((long)_ip1) + "-" + IPUtils.convertLongIpToString((long)_ip2) + " \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443!");
                }
            }
        }
    }

    public void addResources(int categoryId, Calendar date, long ip1, long ip2) {
        try {
            Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ").append(this.tableName).append(" (date1, category_id, ip1, ip2) VALUES (?,?,?,?)");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setDate(1, sqlDate);
            ps.setInt(2, categoryId);
            ps.setLong(3, ip1);
            ps.setLong(4, ip2);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteResource(String id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id IN(" + id + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Iterable<IPResourceRange> getResourceIterator(int categoryId, long ip1, long ip2, boolean mask) {
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append(this.tableName);
            query.append(" WHERE 1>0 ");
            this.addFilters(categoryId, ip1, ip2, query, mask);
            query.append(" ORDER BY ip1");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            return new Iter.ResultSetIterator<IPResourceRange>(rs, new Iter.LoadFromRS<IPResourceRange>(){

                @Override
                public IPResourceRange getFromRS(ResultSet rs) throws SQLException {
                    return IPResourceRangeManager.this.getResourceFromRs(rs);
                }
            }, ps);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public void updateResourcePeriod(String ids, Calendar date1, Calendar date2) {
        try {
            String query = "UPDATE " + this.tableName + " SET date1=?, date2=? WHERE id IN(" + ids + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<IPResourceRange> getResourceListByIds(String ids) throws SQLException {
        ArrayList<IPResourceRange> result = new ArrayList<IPResourceRange>();
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + ids + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getResourceFromRs(rs));
            }
        }
        return result;
    }

    public IPResourceRange getResource(int id) throws SQLException {
        IPResourceRange result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = this.getResourceFromRs(rs);
                }
            }
        }
        return result;
    }

    protected IPResourceRangeUse getResourceUseFromRs(ResultSet rs) throws SQLException {
        IPResourceRangeUse ruse = new IPResourceRangeUse();
        ruse.setResourceId(rs.getInt("resource_id"));
        ruse.setDateFrom(rs.getDate("ruse.date1"));
        ruse.setDateTo(rs.getDate("ruse.date2"));
        ruse.setContractId(rs.getInt("contract.id"));
        ruse.setContractTitle(rs.getString("contract.title"));
        ruse.setContractComment(rs.getString("contract.comment"));
        ruse.setItemId(rs.getInt("item_id"));
        return ruse;
    }

    public void installModule() throws SQLException {
        try (Statement st = this.con.createStatement();){
            String query = "CREATE TABLE  ip_resource_category_" + this.mid + "(id int(11) NOT NULL auto_increment, title varchar(200) NOT NULL, comment varchar(250) NOT NULL, parent_id int(11) NOT NULL, PRIMARY KEY  (id) )";
            st.executeUpdate(query);
            query = "CREATE TABLE  ip_resource_range_" + this.mid + "(id int(11) NOT NULL auto_increment, category_id int(11) NOT NULL, date1 date default NULL, date2 date default NULL, ip1 bigint(20) NOT NULL, ip2 bigint(20) NOT NULL, PRIMARY KEY  (id), KEY idx (category_id, date1, date2, ip1, ip2) )";
            st.executeUpdate(query);
        }
    }

    public void uninstallModule() throws SQLException {
        ServerUtils.dropExistTable(this.con, "ip_resource_category_" + this.mid);
        ServerUtils.dropExistTable(this.con, "ip_resource_range_" + this.mid);
        ServerUtils.dropExistTable(this.con, "ip_resource_" + this.mid);
        ServerUtils.dropExistTable(this.con, "ip_resource_use_" + this.mid);
    }
}

