/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.bean;

import bitel.billing.server.contract.bean.find.SearchContracts;
import com.linuxense.javadbf.DBFReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.integration.common.bean.Register;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterItemManager;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterLoadData;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RegisterLoadPattern {
    private static final Pattern pReplaceDelim = Pattern.compile("\\|");
    private static final Pattern pArrow = Pattern.compile("=>");
    public static final int TYPE_TXT = 1;
    public static final int TYPE_DBF = 2;
    private String key;
    private String handlerClassName;
    private int fileType = 1;
    private String title;
    private Charset charset = StandardCharsets.UTF_8;
    private int[] balanceItemTypes;
    private Pattern pattern;
    private int registerType;
    private int[] summaPositions;
    private int idPos;
    private String summaReplace;
    private int[] commentPositions;
    private String commentDelimiter;
    private int datePos;
    private DateFormat dateFormat;
    private Map<Integer, String> extraParametersMap;
    private Map<String, String> paymentInfoMap = new HashMap<String, String>();
    private int contractId;
    private String balanceItemComment;
    private String uniqueId;
    private BigDecimal[] summas;
    private Date date;
    private String patternTitle;
    private SearchContracts contractFinders;
    private Setup setup = Setup.getSetup();
    private boolean zeroEncoding = true;

    public RegisterLoadPattern(String key, String title, int fileType, String[] balanceItemTypes, int registerType) {
        this.key = key;
        this.title = title;
        this.fileType = fileType;
        int[] types = new int[balanceItemTypes.length];
        for (int i = 0; i < balanceItemTypes.length; ++i) {
            types[i] = Utils.parseInt((String)balanceItemTypes[i]);
        }
        this.balanceItemTypes = types;
        this.registerType = registerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Register loadRegister(Connection con, RegisterLoadData data) throws BGException {
        RegisterManager regman = new RegisterManager(con);
        RegisterItemManager itemman = new RegisterItemManager(con);
        Register register = new Register();
        register.setRegisterType(this.registerType);
        register.setTitle(data.title);
        register.setLoadTime(new GregorianCalendar());
        register.setDate(data.date);
        register.setPatternTitle(this.patternTitle);
        regman.updateRegister(register);
        long startTime = System.currentTimeMillis();
        if (this.fileType == 1) {
            String file = "";
            try {
                file = new String(data.file, this.charset);
            }
            catch (Exception e) {
                data.loadLog.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0441\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0438 \u0444\u0430\u0439\u043b\u0430: " + e.getMessage() + "\n");
            }
            if (this.pattern != null) {
                StringTokenizer st = new StringTokenizer(file, "\n");
                while (st.hasMoreTokens()) {
                    ++data.lineCount;
                    String line = st.nextToken();
                    if (line.startsWith("#")) {
                        data.loadLog.append("(");
                        data.loadLog.append(data.lineCount);
                        data.loadLog.append(") ");
                        data.loadLog.append(line);
                        data.loadLog.append(" => \u043f\u0440\u043e\u043f\u0443\u0441\u043a\n");
                        ++data.commentCount;
                        continue;
                    }
                    Matcher m = this.pattern.matcher(line);
                    if (m.find()) {
                        String[] tokens = new String[m.groupCount()];
                        int size = tokens.length;
                        for (int i = 0; i < size; ++i) {
                            tokens[i] = m.group(i + 1);
                        }
                        String parseResult = this.processString(con, itemman, register, tokens, data.date);
                        this.processParseResult(data, itemman, register, line, parseResult);
                        continue;
                    }
                    data.loadLog.append("(");
                    data.loadLog.append(data.lineCount);
                    data.loadLog.append(") ");
                    data.loadLog.append(line);
                    data.loadLog.append(" => \u0441\u0442\u0440\u043e\u043a\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u043b\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c\n");
                }
            } else {
                data.loadLog.append("\u043f\u0440\u043e\u043f\u0443\u0441\u043a - \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u0440\u0430\u0437\u0431\u043e\u0440\u0430\n");
            }
        } else if (this.fileType == 2) {
            String name = "payment_load_tmp_" + System.currentTimeMillis();
            File tmpFile = new File(this.setup.getTempDirPath() + File.separator + name + ".DBF");
            try {
                Object[] rowObjects;
                if (this.zeroEncoding) {
                    data.file[29] = 0;
                }
                FileOutputStream fos = new FileOutputStream(tmpFile);
                fos.write(data.file);
                fos.close();
                ArrayList<String[]> lines = new ArrayList<String[]>();
                DBFReader read = new DBFReader((InputStream)new FileInputStream(tmpFile), this.charset);
                int columnCount = read.getFieldCount();
                while ((rowObjects = read.nextRecord()) != null) {
                    String[] tokens = new String[columnCount];
                    for (int i = 0; i < rowObjects.length; ++i) {
                        if (rowObjects[i] instanceof BigDecimal) {
                            tokens[i] = ((BigDecimal)rowObjects[i]).toPlainString();
                            continue;
                        }
                        if (rowObjects[i] instanceof Date) {
                            if (this.dateFormat == null) {
                                throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b");
                            }
                            tokens[i] = this.dateFormat.format(rowObjects[i]);
                            continue;
                        }
                        tokens[i] = rowObjects[i].toString();
                    }
                    lines.add(tokens);
                }
                StringBuilder line = new StringBuilder(200);
                for (String[] tokens : lines) {
                    line.setLength(0);
                    String parseResult = this.processString(con, itemman, register, tokens, data.date);
                    if (parseResult != null) {
                        for (String token : tokens) {
                            if (line.length() != 0) {
                                line.append("\t|\t");
                            }
                            line.append(token);
                        }
                    }
                    this.processParseResult(data, itemman, register, line.length() > 0 ? line.toString() : null, parseResult);
                }
            }
            catch (Exception e) {
                data.loadLog.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 DBF: " + e.getMessage() + "\n");
                e.printStackTrace();
            }
            finally {
                tmpFile.delete();
            }
        }
        data.loadLog.append("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0441\u0442\u0440\u043e\u043a => ");
        data.loadLog.append(data.lineCount);
        data.loadLog.append("; \u0438\u0437 \u043d\u0438\u0445 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432 => ");
        data.loadLog.append(data.commentCount);
        data.loadLog.append(", \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0445 => ");
        data.loadLog.append(data.errorCount);
        data.loadLog.append(", \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e => ");
        data.loadLog.append(data.okCount);
        data.loadLog.append("\n");
        data.loadLog.append("\u0418\u0442\u043e\u0433\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + (this.registerType == 1 ? "\u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432" : "\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439") + " => ");
        data.loadLog.append(data.okCount * this.balanceItemTypes.length);
        data.loadLog.append("\n");
        data.loadLog.append("\u0412\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438: ");
        data.loadLog.append(TimeUtils.formatDeltaTime((long)((System.currentTimeMillis() - startTime) / 1000L)));
        register.setStringsCount(data.okCount);
        register.setErrorCount(data.errorCount);
        register.setSumm(data.summa);
        register.setLoadLog(data.loadLog.toString());
        regman.updateRegister(register);
        return register;
    }

    private void processParseResult(RegisterLoadData data, RegisterItemManager rim, Register register, String line, String parseResult) throws BGException {
        if (parseResult != null) {
            data.loadLog.append("(");
            data.loadLog.append(data.lineCount);
            data.loadLog.append(") ");
            data.loadLog.append(line);
            data.loadLog.append("  => ");
            data.loadLog.append(parseResult);
            data.loadLog.append("\n");
            ++data.errorCount;
        } else {
            for (int i = 0; i < this.balanceItemTypes.length; ++i) {
                RegisterItem item = new RegisterItem();
                item.setContractId(this.contractId);
                item.setBalanceItemTypeId(this.balanceItemTypes[i]);
                item.setSumma(this.summas[i]);
                item.setRegisterId(register.getId());
                item.setBalanceItemComment(this.balanceItemComment);
                item.setDate(this.date);
                item.setUniqueId(this.uniqueId);
                item.setExtraParametersMap(this.paymentInfoMap);
                rim.updateRegisterItem(register, item);
                data.summa = data.summa.add(item.getSumma());
            }
            ++data.okCount;
        }
    }

    public String processString(Connection con, RegisterItemManager itemManager, Register register, String[] line, Date pdate) {
        this.contractId = 0;
        this.summas = new BigDecimal[this.summaPositions.length];
        this.balanceItemComment = "";
        this.date = pdate;
        this.uniqueId = "";
        this.paymentInfoMap.clear();
        try {
            for (int i = 0; i < this.summaPositions.length; ++i) {
                if (this.summaPositions[i] > 0 && this.summaPositions[i] <= line.length) {
                    String value = line[this.summaPositions[i] - 1].trim();
                    if (this.summaReplace != null) {
                        for (String replace : pReplaceDelim.split(this.summaReplace)) {
                            if (!pArrow.matcher(replace).find()) continue;
                            String from = null;
                            String to = null;
                            String[] replacePair = pArrow.split(replace);
                            from = replacePair[0];
                            to = replacePair.length == 1 ? "" : replacePair[1];
                            value = value.replaceAll(from, to);
                        }
                    }
                    try {
                        this.summas[i] = Utils.parseBigDecimalSumma((String)value);
                        continue;
                    }
                    catch (Exception e) {
                        return "\u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0443\u043c\u043c\u044b " + value;
                    }
                }
                return "\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u0432\u043b\u0435\u0447\u044c \u0441\u0443\u043c\u043c\u0443 \u0441 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 " + this.summaPositions;
            }
            if (this.datePos > 0 && this.datePos <= line.length) {
                if (this.dateFormat == null) {
                    return "\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u043b\u044f \u0434\u0430\u0442\u044b";
                }
                String value = line[this.datePos - 1];
                try {
                    this.date = this.dateFormat.parse(value);
                }
                catch (Exception e) {
                    return "\u043e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0434\u0430\u0442\u044b " + value;
                }
            }
            StringBuilder report = new StringBuilder();
            List<Contract> findResult = this.contractFinders.findContract(con, TimeUtils.convertDateToCalendar((Date)this.date), line, report);
            if (findResult.size() > 1) {
                return "\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043f\u043e \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u043c \n\t" + report.toString();
            }
            if (findResult.size() == 0) {
                return "\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \n\t" + report.toString();
            }
            if (findResult.size() == 1) {
                this.contractId = findResult.get(0).getId();
            }
            for (int i = 0; i < this.commentPositions.length; ++i) {
                Object value;
                if (this.commentPositions[i] > 0 && this.commentPositions[i] <= line.length) {
                    value = line[this.commentPositions[i] - 1].trim();
                    if (i > 0) {
                        value = this.commentDelimiter + (String)value;
                    }
                } else {
                    return "\u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u0432\u043b\u0435\u0447\u044c \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0441 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 " + this.commentPositions[i];
                }
                this.balanceItemComment = this.balanceItemComment + (String)value;
            }
            if (this.idPos > 0) {
                if (this.idPos <= line.length) {
                    this.uniqueId = line[this.idPos - 1];
                    String error = itemManager.checkItemsWithUniqueId(register, this.uniqueId);
                    if (Utils.notBlankString((String)error)) {
                        return error;
                    }
                } else {
                    return "\u043e\u0448\u0438\u0431\u043a\u0430 \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0430 \u0441 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 " + this.idPos;
                }
            }
            if (this.extraParametersMap != null && this.extraParametersMap.size() > 0) {
                for (Integer pos : this.extraParametersMap.keySet()) {
                    String keyName = this.extraParametersMap.get(pos).trim();
                    String value = line[pos - 1].trim();
                    this.paymentInfoMap.put(keyName, value);
                }
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "\u043e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 " + ex.getMessage();
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        try {
            this.charset = Charset.forName(encoding);
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException("\u043e\u0448\u0438\u0431\u043e\u0447\u043d\u0430\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 \"" + encoding + "\"");
        }
    }

    public void setSummaPos(int[] summaPos) {
        this.summaPositions = summaPos;
    }

    public void setSummaPos(String[] summaPos) {
        int[] summas = new int[summaPos.length];
        for (int i = 0; i < summaPos.length; ++i) {
            summas[i] = Utils.parseInt((String)summaPos[i]);
        }
        this.summaPositions = summas;
    }

    public void setExtraParametersMap(Map<Integer, String> extraParametersMap) {
        this.extraParametersMap = extraParametersMap;
    }

    public void setIdPos(int idPos) {
        this.idPos = idPos;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public void setCommentPositions(String[] commentPositions) {
        int[] comments = new int[commentPositions.length];
        for (int i = 0; i < commentPositions.length; ++i) {
            comments[i] = Utils.parseInt((String)commentPositions[i]);
        }
        this.commentPositions = comments;
    }

    public void setSearchContracts(SearchContracts contractFinders) {
        this.contractFinders = contractFinders;
    }

    public String getPaymentComment() {
        return this.balanceItemComment;
    }

    public void setSummaReplace(String summaReplace) {
        this.summaReplace = summaReplace;
    }

    public void setType(int type) {
        this.fileType = type;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setBalanceItemTypes(int[] paymentType) {
        this.balanceItemTypes = paymentType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDatePos(int datePos) {
        this.datePos = datePos;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setZeroEncoding(boolean zeroEncoding) {
        this.zeroEncoding = zeroEncoding;
    }

    public String getPatternTitle() {
        return this.patternTitle;
    }

    public void setPatternTitle(String patternTitle) {
        this.patternTitle = patternTitle;
    }

    public int getRegisterType() {
        return this.registerType;
    }

    public void setRegisterType(int registerType) {
        this.registerType = registerType;
    }

    public void setCommentDelimiter(String commentDelimiter) {
        this.commentDelimiter = commentDelimiter;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    public void setHandlerClassName(String handlerClassName) {
        this.handlerClassName = handlerClassName;
    }
}

