/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;

public class DatagramChannelListener
extends BGLogger
implements Runnable {
    protected final String host;
    protected final int port;
    protected final DatagramChannel channel;
    protected final Selector selector;
    protected ByteBuffer directByteBuffer;
    protected int maxPacketSize = 65535;
    protected int byteBufferCapacity;
    private final int socketRCVBUF;
    protected boolean inited = false;
    private boolean reuseAddress = false;

    public DatagramChannelListener(int port, int byteBufferCapacity) {
        this(port, byteBufferCapacity, 0);
    }

    public DatagramChannelListener(int port, int byteBufferCapacity, int socketRCVBUF) {
        this(null, port, byteBufferCapacity, socketRCVBUF);
    }

    public DatagramChannelListener(String host, int port, int byteBufferCapacity, int socketRCVBUF) {
        ByteBuffer buffer;
        Selector selector;
        DatagramChannel channel;
        this.host = Utils.isBlankString(host) ? null : host;
        this.port = port;
        this.byteBufferCapacity = Math.max(byteBufferCapacity, 393216);
        this.socketRCVBUF = socketRCVBUF;
        try {
            channel = DatagramChannel.open();
            selector = Selector.open();
            buffer = ByteBuffer.allocateDirect(byteBufferCapacity);
        }
        catch (Exception ex) {
            Object channel2 = null;
            Object selector2 = null;
            Object buffer2 = null;
            this.logError(ex);
            throw new RuntimeException("Error init " + this.getClass().getSimpleName());
        }
        this.channel = channel;
        this.selector = selector;
        this.directByteBuffer = buffer;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    private void initSocket() {
        try {
            if (this.socketRCVBUF > 5120) {
                this.channel.socket().setReceiveBufferSize(this.socketRCVBUF);
            }
            if (this.port >= 0 || Utils.notBlankString(this.host)) {
                InetSocketAddress localport;
                if (this.port >= 0 && this.reuseAddress) {
                    this.channel.socket().setReuseAddress(true);
                }
                if (Utils.isBlankString(this.host)) {
                    localport = new InetSocketAddress(this.port);
                    this.getLogger().info("Open socket [" + localport + "] (anyLocalAddress)");
                } else {
                    localport = new InetSocketAddress(this.host, this.port < 0 ? 0 : this.port);
                    this.getLogger().info("Open socket [" + localport + "]");
                }
                this.channel.socket().bind(localport);
            } else {
                this.getLogger().info("Open socket [anyLocalAddress]");
            }
            this.channel.socket().setBroadcast(true);
            this.channel.configureBlocking(false);
            this.channel.register(this.selector, 1);
            this.getLogger().info(this.getClass().getName() + " socket init ok.");
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new RuntimeException("Error init SocketListener on port=" + this.port, ex);
        }
    }

    public void init() {
        this.initSocket();
        this.inited = true;
    }

    public int select(long timeout) {
        try {
            int n = this.selector.select(timeout);
            if (n > 0) {
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    SelectableChannel c = key.channel();
                    if (!key.isReadable() || c != this.channel) continue;
                    if (this.directByteBuffer.capacity() - this.directByteBuffer.position() < this.maxPacketSize) {
                        this.directByteBuffer = ByteBuffer.allocateDirect(this.byteBufferCapacity);
                    }
                    this.directByteBuffer.mark();
                    SocketAddress clientAddress = this.channel.receive(this.directByteBuffer);
                    if (clientAddress == null) continue;
                    this.directByteBuffer.limit(this.directByteBuffer.position());
                    this.directByteBuffer.reset();
                    ByteBuffer buffer = this.directByteBuffer.slice();
                    this.directByteBuffer.position(this.directByteBuffer.limit());
                    this.directByteBuffer.limit(this.directByteBuffer.capacity());
                    this.onPacket(clientAddress, buffer);
                }
            }
            return n;
        }
        catch (ClosedSelectorException e) {
            this.getLogger().info(this.getClass().getSimpleName() + " shutdown.");
            return 0;
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        catch (Throwable t) {
            this.getLogger().error(t.getMessage(), t);
        }
        return 0;
    }

    @Override
    public void run() {
        if (!this.inited) {
            throw new IllegalStateException("ChannelListener not inited");
        }
        while (true) {
            try {
                block5: while (true) {
                    this.selector.select();
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    Iterator<SelectionKey> iter = keys.iterator();
                    while (true) {
                        if (!iter.hasNext()) continue block5;
                        SelectionKey key = iter.next();
                        iter.remove();
                        SelectableChannel c = key.channel();
                        if (!key.isReadable() || c != this.channel) continue;
                        if (this.directByteBuffer.capacity() - this.directByteBuffer.position() < this.maxPacketSize) {
                            this.directByteBuffer = ByteBuffer.allocateDirect(this.byteBufferCapacity);
                        }
                        this.directByteBuffer.mark();
                        SocketAddress clientAddress = this.channel.receive(this.directByteBuffer);
                        if (clientAddress == null) continue;
                        this.directByteBuffer.limit(this.directByteBuffer.position());
                        this.directByteBuffer.reset();
                        ByteBuffer buffer = this.directByteBuffer.slice();
                        this.directByteBuffer.position(this.directByteBuffer.limit());
                        this.directByteBuffer.limit(this.directByteBuffer.capacity());
                        this.onPacket(clientAddress, buffer);
                    }
                    break;
                }
            }
            catch (ClosedSelectorException e) {
                this.getLogger().info(this.getClass().getSimpleName() + " [" + this.host + ":" + this.port + "] shutdown.");
                return;
            }
            catch (Exception ex) {
                this.logError(ex);
                continue;
            }
            catch (Throwable ex) {
                this.logError(ex);
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        try {
            this.selector.close();
            this.channel.close();
        }
        catch (IOException ex) {
            this.logError(ex);
        }
    }

    public void onPacket(SocketAddress clientAddress, ByteBuffer data) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void sendResponse(SocketAddress address, ByteBuffer response) throws IOException {
        this.channel.send(response, address);
    }

    public void send(SocketAddress address, ByteBuffer response) throws IOException {
        this.channel.send(response, address);
    }
}

