<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:format="xalan://java.text.Format"
    xmlns:iterator="xalan://java.lang.Iterator"
    xmlns:session="xalan://ru.bitel.bgbilling.modules.phone.server.bean.Session"
    xmlns:detail="xalan://ru.bitel.bgbilling.modules.phone.server.bean.SessionDetail"
    xmlns:utils="ru.bitel.common.Utils"
    extension-element-prefixes="session iterator format utils"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:param name="beans"/>
<xsl:param name="format"/>
<xsl:param name="size"/>

<xsl:template match="/">
   <html>
   <head>
   <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
   <style type="text/css"><![CDATA[
   th.thService, th.thAon, th { text-align: left; }
   ]]>
   </style>
   </head>
    <body>
    <center>
        <xsl:call-template name="head"/><br/>
		<xsl:for-each select="/data/sessions">
			<xsl:choose>
				<xsl:when test="@type = 1"><xsl:call-template name="table_point"/>
				</xsl:when>
				<xsl:otherwise><xsl:call-template name="table_point"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<br/>
        <xsl:call-template name="sums"/>
    </center>
    </body>
    </html>
</xsl:template>

<xsl:template name="head">
    <xsl:for-each select="/data/sessions">
         <h2><xsl:value-of select="@reportTitle"/><br/>
         Договор:&#160;<xsl:value-of select="@contractTitle"/>(<xsl:value-of select="@comment"/>)
         </h2><br/>
         Период с: <xsl:value-of select="@date1"/> по <xsl:value-of select="@date2"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="table_point">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">
	   <td>Дата/время звонка</td>
	   <td>Направление</td>
	   <td>Номер телефона B</td>
	   <td>Округленная<br/>длительность, мин.</td>
	   <td>Стоимость звонка,<br/>руб.</td>
     </tr>
     <xsl:for-each select="$size">
     <xsl:variable name="service" select="iterator:next( $beans )"/>
     <xsl:variable name="aons" select="detail:iterator( $service )"/>

		<tr>
			<td colspan="5" class="thService">Услуга: <xsl:value-of select="detail:getTitle( $service )"/></td>
		</tr>

     	<xsl:for-each select="detail:getSize( $service )">
     	<xsl:variable name="aon" select="iterator:next( $aons )"/>
     	<xsl:variable name="sessions" select="detail:iterator( $aon )"/>

			<tr>
				<td colspan="5" class="thAon">Номер телефона А: <xsl:value-of select="detail:getTitle( $aon )"/></td>
			</tr>

     	<xsl:for-each select="detail:getSize( $aon )">
	     	<xsl:variable name="s" select="iterator:next( $sessions )"/>
	         <tr>
	         	<td><xsl:value-of select="format:format( $format, session:getSessionStart( $s ) )"/></td>
	         	<td><xsl:value-of select="session:getDestination( $s )"/></td>
	         	<td><xsl:value-of select="session:getToNumber164( $s )"/></td>
	         	<td><xsl:value-of select="utils:formatSessionTime( session:getSessionTimeRound( $s ) )"/></td>
	         	<td><xsl:value-of select="utils:formatSessionCost( session:getSessionCost( $s ) )"/></td>
	         </tr>
         </xsl:for-each>
         
								<tr>
								<td colspan="2">Итого по номеру:&#160;кол-во&#160;<xsl:value-of select="detail:getTotalNumber( $aon )"/></td>
								<td>
								</td>
								<td>окр. длит. (мин)&#160;<xsl:value-of select="detail:getTotalTimeRoundMinute( $aon )"/>
								</td>
								<td>сумма&#160;<xsl:value-of select="detail:getTotalCostFormat( $aon )"/></td>
							  </tr>

         </xsl:for-each>
         
         					<tr>
								<td colspan="2">Итого по услуге:&#160;кол-во&#160;<xsl:value-of select="detail:getTotalNumber( $service )"/></td>
								<td>
								</td>
								<td>окр. длит. (мин)&#160;<xsl:value-of select="detail:getTotalTimeRoundMinute( $service )"/>
								</td>
								<td>сумма&#160;<xsl:value-of select="detail:getTotalCostFormat( $service )"/></td>
							  </tr>

     </xsl:for-each>

</table>
</xsl:template>

<xsl:template name="table_rule">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">
         <td>Правило</td>
         <td>Время входа</td>
         <td>Длительность[в секундах]</td>
          <td>Длительность окр.[в секундах]</td>
		 <td>Стоимость<br/>минуты</td>
         <td>Стоимость</td>
         <td>С номера / На номер</td>         
     </tr>
     <xsl:for-each select="$size">
     <xsl:variable name="s" select="iterator:next( $beans )"/>
         <tr bgcolor="#ffffff">
	         <td><xsl:value-of select="session:getClientItem( $s )"/></td>
             <td><xsl:value-of select="format:format( $format, session:getSessionStart( $s ) )"/></td>
             <td><xsl:value-of select="utils:formatSessionTime( session:getSessionTime( $s ) )"/></td>
             <td><xsl:value-of select="utils:formatSessionTime( session:getSessionTimeRound( $s ) )"/></td>
             <td><xsl:value-of select="utils:formatCost( session:getMinCost( $s ) )"/></td>
             <td><xsl:value-of select="utils:formatSessionCost( session:getSessionCost( $s ) )"/></td>
             <td><xsl:value-of select="session:getFromNumber164( $s )"/>/<xsl:value-of select="session:getToNumber164( $s )"/></td>
         </tr>
     </xsl:for-each>
</table>
</xsl:template>

<xsl:template name="sums">
    <br/>
	Количество сессий:&#160;<xsl:value-of select="/data/sessions/@total_number"/>&#160;
    Итого [в секундах]:&#160;<xsl:value-of select="/data/sessions/@total_time"/>&#160;
    Итого окр. [в секундах]:&#160;<xsl:value-of select="/data/sessions/@total_time_round"/>&#160;
    Итого [в рублях]:&#160;<xsl:value-of select="/data/sessions/@total_cost"/>&#160;
</xsl:template>

</xsl:stylesheet>
