/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code.importer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.server.bean.code.CostMapItemReader;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class CostMapItemStandartFileReader
implements CostMapItemReader {
    private static final String DATE_FORMAT = "dd.MM.yyyy";

    @Override
    public List<VoiceCostMapItem> getGeocodesFromString(String importString, String result, int costMapId, Period period) {
        ArrayList<VoiceCostMapItem> list = new ArrayList<VoiceCostMapItem>();
        importString = importString.replaceAll("\"", "");
        StringTokenizer tokenizer = new StringTokenizer(importString, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String row = tokenizer.nextToken();
            list.add(this.readCodeFromString(row, result, costMapId, period));
        }
        return list;
    }

    private VoiceCostMapItem readCodeFromString(String row, String result, int costMapId, Period period) {
        String[] rowContent = row.split("\t");
        String code = rowContent[0];
        String destination = null;
        Date dateFrom = null;
        Date dateTo = null;
        BigDecimal cost = null;
        switch (rowContent.length) {
            case 2: {
                cost = Utils.parseBigDecimal((String)rowContent[1], (BigDecimal)BigDecimal.ZERO);
                break;
            }
            case 3: {
                destination = rowContent[1];
                cost = Utils.parseBigDecimal((String)rowContent[2], (BigDecimal)BigDecimal.ZERO);
                break;
            }
            case 4: {
                dateFrom = TimeUtils.parseDate((String)rowContent[1], (String)DATE_FORMAT);
                dateTo = TimeUtils.parseDate((String)rowContent[2], (String)DATE_FORMAT);
                cost = Utils.parseBigDecimal((String)rowContent[3], (BigDecimal)BigDecimal.ZERO);
                break;
            }
            case 5: {
                destination = rowContent[1];
                dateFrom = TimeUtils.parseDate((String)rowContent[2], (String)DATE_FORMAT);
                dateTo = TimeUtils.parseDate((String)rowContent[3], (String)DATE_FORMAT);
                cost = Utils.parseBigDecimal((String)rowContent[4], (BigDecimal)BigDecimal.ZERO);
                break;
            }
        }
        if (dateFrom == null) {
            dateFrom = period.getDateFrom();
        }
        if (dateTo == null) {
            dateTo = period.getDateTo();
        }
        VoiceCostMapItem item = new VoiceCostMapItem();
        item.setCostMapId(costMapId);
        item.setCode(code);
        item.setDestinationTitle(destination);
        item.setItemCost(cost);
        item.setDateFrom(dateFrom);
        item.setDateTo(dateTo);
        return item;
    }

    @Override
    public String getId() {
        return "1";
    }

    @Override
    public String getTitle() {
        return "BGBilling (<code> <dest> <dateFrom> <dateTo> <cost>)";
    }
}

