/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountPort;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountSearchParam;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionDetailOrder;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountState;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceAccountModifiedEvent;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountGenerate;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountPortDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDetailOrderDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceAccountChangingEvent;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountModifyEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.PatternStringGenerator;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService")
public class VoiceAccountServiceImpl
extends AbstractService
implements VoiceAccountService {
    private VoiceAccountDao accountDao;
    private VoiceAccountPortDao voiceAccountPortDao;
    private ContractDao contractDao;
    private ContractUtils contractUtils;
    @Resource
    PhoneResourceService wsResoure;

    @PostConstruct
    private void init() {
        this.accountDao = new VoiceAccountDao(this.getConnection(), this.moduleId);
        this.voiceAccountPortDao = new VoiceAccountPortDao(this.getConnection(), this.moduleId);
        this.contractDao = new ContractDao(this.getConnection(), 0);
        this.contractUtils = new ContractUtils(this.getConnection());
    }

    public List<VoiceAccount> voiceAccountList(int contractId, int contractObjectId, Period period) throws BGException, BGMessageException {
        Contract contract = (Contract)this.contractDao.get(contractId);
        if (contract != null && contract.isIndependSub() && VoiceCommonUtils.agetModeOn((Preferences)Setup.getSetup())) {
            contractId = contract.getSuperCid();
        }
        List<VoiceAccount> list = this.accountDao.list(contractId, -1, period);
        ArrayList<VoiceAccount> result = new ArrayList<VoiceAccount>();
        if (contractObjectId > 0) {
            list.stream().filter(a -> a.getContractObjectId() == contractObjectId).forEach(result::add);
        } else {
            result.addAll(list);
        }
        return result;
    }

    public VoiceAccount voiceAccountGet(int accountId) throws BGException, BGMessageException {
        VoiceAccount account = (VoiceAccount)this.accountDao.get(accountId);
        if (account == null) {
            return null;
        }
        account.setPorts(Utils.toString((Iterable)account.getPortList().stream().map(p -> p.getPort()).collect(Collectors.toList())));
        return account;
    }

    public int voiceAccountUpdate(VoiceAccount account) throws BGException, BGMessageException {
        VoiceAccount oldAccount = null;
        int contractId = account.getContractId();
        if (account.getTypeId() <= 0) {
            throw new BGMessageException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
        }
        VoiceAccountType type = this.voiceAccountTypeGet(account.getTypeId());
        this.setConstDevice(account, type);
        if (account.getDeviceId() <= 0) {
            throw new BGMessageException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
        }
        if (TimeUtils.dateBefore((Date)account.getDateTo(), (Date)account.getDateFrom())) {
            throw new BGMessageException("\u0414\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0447\u0435\u043c \u0434\u0430\u0442\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f");
        }
        if (account.getId() > 0) {
            oldAccount = (VoiceAccount)this.accountDao.get(account.getId());
        }
        account.setTitle(this.getTitlePattern(account, type));
        if (type.isNeedLines() && account.getLineCount() < 1) {
            throw new BGMessageException("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043b\u0438\u043d\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f");
        }
        account = ((VoiceAccountChangingEvent)EventProcessor.getInstance().request((QueueEvent)new VoiceAccountChangingEvent(this.moduleId, this.userId, oldAccount, account))).getVoiceAccount();
        try {
            this.accountDao.update((Entity)account);
            this.updatePorts(account);
            if (type.isNeedPhone()) {
                this.subcribeNumber(account);
            }
            if (type.isNeedLogin()) {
                this.checkLogin(account);
            }
            this.sendEventToDevice(contractId, account, oldAccount);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceAccountModifiedEvent(this.moduleId, contractId, this.userId, oldAccount, account));
            return account.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void voiceAccountPeriodUpdate(int accountId, Date dateFrom, Date dateTo) throws BGException, BGMessageException {
        try {
            VoiceAccount voiceAccountOld = (VoiceAccount)this.accountDao.get(accountId);
            VoiceAccount voiceAccountUpdate = new VoiceAccount();
            voiceAccountOld.copyTo(voiceAccountUpdate);
            voiceAccountUpdate.setDateFrom(dateFrom);
            voiceAccountUpdate.setDateTo(dateTo);
            this.accountDao.update((Entity)voiceAccountUpdate);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceAccountModifiedEvent(this.moduleId, voiceAccountOld.getContractId(), this.userId, voiceAccountOld, voiceAccountUpdate));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void voiceAccountPasswordGenerate(int accountId) throws BGException, BGMessageException {
        VoiceAccount oldVoiceAccount = (VoiceAccount)this.accountDao.get(accountId);
        if (oldVoiceAccount == null) {
            throw new BGMessageException("voiceAccount == null");
        }
        VoiceAccountType voiceAccountType = this.voiceAccountTypeGet(oldVoiceAccount.getTypeId());
        if (voiceAccountType == null) {
            throw new BGMessageException("voiceAccountType == null");
        }
        ModuleSetup config = this.getModuleSetup();
        if (voiceAccountType != null) {
            config = config.inherit((ParameterMap)new Preferences(voiceAccountType.getConfig(), "\n"));
        }
        try {
            VoiceAccount voiceAccount = new VoiceAccount();
            oldVoiceAccount.copyTo(voiceAccount);
            voiceAccount.setPassword(this.voiceAccountUpdateGeneratePassword(oldVoiceAccount, (ParameterMap)config));
            this.accountDao.update((Entity)voiceAccount);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceAccountModifiedEvent(this.moduleId, oldVoiceAccount.getContractId(), this.userId, oldVoiceAccount, voiceAccount));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private String voiceAccountUpdateGeneratePassword(VoiceAccount voiceAccount, ParameterMap config) throws BGException {
        String pswd = null;
        String accountPasswordClass = config.get("account.password.class");
        if (accountPasswordClass != null) {
            try {
                pswd = DynamicClassManager.getInstance().loadClass(accountPasswordClass).asSubclass(VoiceAccountGenerate.class).getConstructor(new Class[0]).newInstance(new Object[0]).generatePassword(voiceAccount.getContractId(), voiceAccount, config);
            }
            catch (Exception e) {
                LogManager.getLogger().error((Object)e);
                return null;
            }
        }
        if (pswd == null) {
            int length = config.getInt("account.password.length.auto", 6);
            String passwordChars = config.get("account.password.chars.auto", config.get("account.password.chars", "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz"));
            pswd = PswdGen.generatePassword((int)length, (String)passwordChars);
        }
        return pswd;
    }

    private void setConstDevice(VoiceAccount account, VoiceAccountType type) {
        Preferences servTypeConfig = new Preferences(type.getConfig(), "\n\r");
        int constDeviceId = servTypeConfig.getInt("const.device.id", -1);
        if (constDeviceId > 0) {
            account.setDeviceId(constDeviceId);
        }
    }

    private void sendEventToDevice(int contractId, VoiceAccount account, VoiceAccount oldAccount) throws BGException, BGMessageException {
        VoiceAccountState newDeviceState = this.getNewDeviceState(account);
        if (oldAccount != null && oldAccount.getDeviceId() != account.getDeviceId()) {
            this.publishOmEvent(contractId, oldAccount, null, VoiceAccountState.STATE_DELETED, false);
            this.publishOmEvent(contractId, null, account, newDeviceState, false);
        } else if (newDeviceState != VoiceAccountState.STATE_DELETED || oldAccount != null) {
            boolean deleteAccount = newDeviceState == VoiceAccountState.STATE_DELETED && oldAccount != null;
            this.publishOmEvent(contractId, oldAccount, deleteAccount ? null : account, newDeviceState, true);
        }
    }

    public void subcribeNumber(VoiceAccount account) throws Exception {
        String subscriberTitle = this.contractUtils.getContractTitle(account.getContractId(), true) + ";" + account.getTitle();
        if (!this.wsResoure.phoneResourceSubscribe(account.getNumber(), account.getId(), subscriberTitle, account.getDateFrom(), account.getDateTo())) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u043e\u043c\u0435\u0440\u0430");
        }
    }

    public void checkLogin(VoiceAccount account) throws BGMessageException, BGException {
        if (Utils.isEmptyString((String)account.getLogin())) {
            throw new BGMessageException("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u0438\u043d");
        }
        boolean loginUnique = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getBoolean("login.unique", true);
        if (!loginUnique) {
            return;
        }
        List<VoiceAccount> logins = this.accountDao.list(account.getLogin(), account.getDateFrom(), account.getDateTo());
        if (logins.size() > 0) {
            for (VoiceAccount ac : logins) {
                if (ac.getId() == account.getId()) continue;
                throw new BGMessageException("\u042d\u0442\u043e\u0442 \u043b\u043e\u0433\u0438\u043d \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u0441 \u043a\u043e\u0434\u043e\u043c " + logins.get(0).getContractId());
            }
        }
    }

    private void updatePorts(VoiceAccount account) throws BGException, BGMessageException {
        try {
            ArrayList<VoiceAccountPort> fromPorts = new ArrayList();
            if (!Utils.isEmptyString((String)account.getPorts())) {
                fromPorts = Arrays.stream(account.getPorts().split(",")).map(p -> new VoiceAccountPort(account.getId(), p, false)).collect(Collectors.toList());
                this.voiceAccountPortDao.update(account.getId(), fromPorts);
            }
            account.setPortList(fromPorts);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private VoiceAccountState getNewDeviceState(VoiceAccount account) throws BGException, BGMessageException {
        VoiceAccountState newDeviceState;
        Date now = new Date();
        if (!TimeUtils.dateInRange((Date)now, (Date)account.getDateFrom(), (Date)account.getDateTo())) {
            newDeviceState = VoiceAccountState.STATE_DELETED;
        } else if (account.getStatus().getCode() != VoiceAccountStatus.STATUS_ON.getCode()) {
            newDeviceState = VoiceAccountState.STATE_DISABLE;
        } else {
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(account.getContractId()));
            StatusCache statusCache = StatusCache.getInstance();
            newDeviceState = !statusCache.isModuleActiveStatus(this.moduleId, contractRuntime.getStatus()) ? VoiceAccountState.STATE_DISABLE : VoiceAccountState.STATE_ENABLE;
        }
        return newDeviceState;
    }

    protected void publishOmEvent(int contractId, VoiceAccount oldAccount, VoiceAccount newAccount, VoiceAccountState newDeviceState, boolean fireDeviceStateCnanged) throws BGException, BGMessageException {
        int deviceId = 0;
        OmVoiceAccountModifyEvent event = new OmVoiceAccountModifyEvent(this.moduleId, deviceId, contractId, oldAccount, newAccount, newDeviceState);
        event.setFireDeviceStateCnanged(fireDeviceStateCnanged);
        EventProcessor.getInstance().publishAfterCommit((Event)event);
    }

    public int voiceAccountDelete(int accountId) throws BGException, BGMessageException {
        try {
            VoiceAccount oldAccount = (VoiceAccount)this.accountDao.get(accountId);
            this.wsResoure.phoneResourceUnsubscribe(accountId);
            if (oldAccount == null) {
                return 0;
            }
            int result = this.accountDao.delete(accountId);
            VoiceAccountState deviceState = oldAccount.getDeviceState();
            if (deviceState != VoiceAccountState.STATE_DELETED) {
                this.checkVoiceAccountIsActive(oldAccount);
                this.publishOmEvent(oldAccount.getContractId(), oldAccount, null, VoiceAccountState.STATE_DELETED, true);
            }
            for (BGModule bgModule : ModuleCache.getInstance().getModulesList("npay")) {
                EventProcessor.getInstance().doCrossComponentQuery("npay", bgModule.getId(), "serviceObjectDelete", new Object[]{oldAccount.getContractId(), this.moduleId, accountId});
            }
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceAccountModifiedEvent(this.moduleId, oldAccount.getContractId(), this.userId, oldAccount, null));
            return result;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void voiceAccountListDelete(List<Integer> ids) throws BGException, BGMessageException {
        for (int accountId : ids) {
            this.voiceAccountDelete(accountId);
        }
    }

    public void checkVoiceAccountIsActive(VoiceAccount oldAccount) throws BGException, BGMessageException {
        if (TimeUtils.dateInRange((Date)new Date(), (Date)oldAccount.getDateFrom(), (Date)oldAccount.getDateTo())) {
            throw new BGMessageException("\u0412\u044b \u043f\u044b\u0442\u0430\u0435\u0442\u0435\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u043c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
        }
    }

    public List<VoiceAccount> getVoiceAccounts(int deviceId) throws BGException, BGMessageException {
        return this.accountDao.list(-1, deviceId, null);
    }

    private String getTitlePattern(VoiceAccount account, VoiceAccountType type) throws BGException, BGMessageException {
        Preferences config = new Preferences(type.getConfig(), "\n\r");
        String titlePattern = config.get("title.pattern", "${number}");
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"login", (String)account.getLogin());
        titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"number", (String)String.valueOf(account.getNumber()));
        return titlePattern;
    }

    public List<VoiceAccountType> voiceAccountTypeList() throws Exception {
        return this.context.getDirectory(VoiceAccountType.class, this.moduleId).list();
    }

    public List<IdTitle> voiceAccountSpecTitleList() throws Exception {
        return this.context.getDirectory(VoiceAccountType.class, this.moduleId).list().stream().map(IdTitle::toIdTitle).toList();
    }

    public VoiceAccountType voiceAccountTypeGet(int accountTypeId) throws BGException, BGMessageException {
        return (VoiceAccountType)this.context.getDirectory(VoiceAccountType.class, this.moduleId).get(accountTypeId);
    }

    public int voiceAccountTypeUpdate(VoiceAccountType accountType) throws BGException, BGMessageException {
        try {
            this.context.getDirectory(VoiceAccountType.class, this.moduleId).update((Id)accountType);
            return accountType.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int voiceAccountTypeDelete(int accountTypeId) throws BGException, BGMessageException {
        try {
            return this.context.getDirectory(VoiceAccountType.class, this.moduleId).delete(accountTypeId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public Result<VoiceAccount> voiceSearchAccount(VoiceAccountSearchParam searchParam, Page page) throws Exception {
        return this.accountDao.list(searchParam, page);
    }

    public void voiceAccountRelocate(int accountId, int toContractId) throws BGException, BGMessageException {
        this.accountDao.relocate(accountId, toContractId);
    }

    public List<VoiceSessionDetailOrder> voiceSessionDetailOrderList(int accountId, int contractId) throws BGException, BGMessageException {
        try (VoiceSessionDetailOrderDao voiceSessionDetailOrderDao = new VoiceSessionDetailOrderDao(this.getConnection(), this.moduleId);){
            List<VoiceSessionDetailOrder> list = voiceSessionDetailOrderDao.list(accountId, contractId);
            return list;
        }
    }

    public void voiceSessionDetailOrderUpdate(VoiceSessionDetailOrder order) throws BGException, BGMessageException {
        try (VoiceSessionDetailOrderDao voiceSessionDetailOrderDao = new VoiceSessionDetailOrderDao(this.getConnection(), this.moduleId);){
            voiceSessionDetailOrderDao.update(order);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int voiceSessionDetailOrderDelete(VoiceSessionDetailOrder order) throws BGException, BGMessageException {
        int n;
        VoiceSessionDetailOrderDao voiceSessionDetailOrderDao = new VoiceSessionDetailOrderDao(this.getConnection(), this.moduleId);
        try {
            n = voiceSessionDetailOrderDao.delete(order);
        }
        catch (Throwable throwable) {
            try {
                try {
                    voiceSessionDetailOrderDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        voiceSessionDetailOrderDao.close();
        return n;
    }
}

