/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.common.service;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.MTOM;
import java.math.BigDecimal;
import java.util.List;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.DocTypes;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentPosition;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.InvoiceDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.NumerationPool;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.BillPositionType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.LoggableService;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@MTOM
@WebService
@XmlSeeAlso(value={BillDocument.class, DocType.class, BankAccount.class, DocumentPosition.class, IdTitle.class, KeyValue.class})
public interface BillService
extends LoggableService {
    public Result<BillDocument> billDocumentListForContract(@WebParam(name="contractId") int var1, @WebParam(name="page") Page var2) throws Exception;

    public void billDocumentDelete(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2, @WebParam(name="customer") boolean var3) throws Exception;

    public List<DocType> documentSpecListForCustomer(@WebParam(name="contractId") int var1) throws Exception;

    public List<BankAccount> bankAccountList() throws Exception;

    public List<DocumentPosition> templateDocumentPositionList(@WebParam(name="contractId") int var1, @WebParam(name="documentSpecId") int var2, @WebParam(name="year") int var3, @WebParam(name="month") int var4) throws Exception;

    public int billDocumentCreate(@WebParam(name="contractId") int var1, @WebParam(name="documentSpecId") int var2, @WebParam(name="bankAccountId") int var3, @WebParam(name="year") int var4, @WebParam(name="month") int var5, @WebParam(name="documentPositionList") List<DocumentPosition> var6) throws Exception;

    public FileDto billDocumentDownload(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2) throws Exception;

    public Result<InvoiceDocument> invoiceDocumentListForContract(@WebParam(name="contractId") int var1, @WebParam(name="onlyReady") boolean var2, @WebParam(name="page") Page var3) throws Exception;

    public FileDto invoiceDocumentDownload(@WebParam(name="contractId") int var1, @WebParam(name="id") int var2) throws Exception;

    @WebMethod
    public List<BankAccount> getBankAccountList(int var1, Boolean var2) throws Exception;

    @WebMethod
    public BankAccount getDefaultBankAccount(int var1) throws Exception;

    @WebMethod
    public void setDefaultBankAccount(BankAccount var1) throws Exception;

    @WebMethod
    public List<IdTitle> getBankAccountTitleList(int var1, int var2, Boolean var3, Holder<Integer> var4) throws Exception;

    @WebMethod
    public void setBankAccount(int var1, int var2) throws Exception;

    @WebMethod
    public void updateBankAccount(BankAccount var1) throws Exception;

    @WebMethod
    public void deleteBankAccount(int var1) throws Exception;

    @WebMethod
    public BankAccount getBankAccount(int var1) throws Exception;

    @WebMethod
    public List<Organization> getOrganizationList() throws Exception;

    @WebMethod
    public Organization getDefaultOrganization() throws Exception;

    @WebMethod
    public Organization getOrganization(int var1) throws Exception;

    @WebMethod
    public void updateOrganization(Organization var1) throws Exception;

    @WebMethod
    public void deleteOrganization(int var1) throws Exception;

    @WebMethod
    public void setDefaultOrganization(int var1) throws Exception;

    @WebMethod
    public List<IdTitle> getOrganizationTitleList(int var1, Boolean var2, Holder<Integer> var3) throws Exception;

    @WebMethod
    public void setOrganization(int var1, int var2) throws Exception;

    @WebMethod
    public List<DocType> docTypeList(DocumentType var1) throws Exception;

    @WebMethod
    public List<DocType> docTypeListForContract(int var1, DocumentType var2) throws Exception;

    @WebMethod
    public DocType docTypeGet(int var1) throws Exception;

    @WebMethod
    public void docTypeUpdate(DocType var1) throws Exception;

    @WebMethod
    public void docTypeDelete(int var1) throws Exception;

    @WebMethod
    public List<IdTitle> positionList(DocumentType var1) throws Exception;

    @WebMethod
    public MapHolder<Integer, List<IdTitle>> xmlComposition() throws Exception;

    @WebMethod
    public SearchResult<Position> searchPositionList(DocumentType var1, Page var2) throws Exception;

    @WebMethod
    public Position positionGet(@WebParam(name="documentType") DocumentType var1, @WebParam(name="positionId") int var2) throws Exception;

    @WebMethod
    public Position positionUpdate(DocumentType var1, Position var2) throws Exception;

    @WebMethod
    public boolean positionDelete(@WebParam(name="documentType") DocumentType var1, @WebParam(name="positionId") int var2) throws Exception;

    @WebMethod
    public void sendDocsForAll(@WebParam(name="senderTaskParameters") DocumentSendParameters var1) throws Exception;

    @WebMethod
    public void sendDocs(@WebParam(name="senderTaskParameters") DocumentSendParameters var1) throws Exception;

    public List<AttributeType> attributeTypeList() throws Exception;

    public void attributeTypeUpdate(@WebParam(name="attributeType") AttributeType var1) throws Exception;

    public void attributeTypeDelete(@WebParam(name="attributeTypeId") int var1) throws Exception;

    public List<Attribute> attributeList(@WebParam(name="contractId") int var1) throws Exception;

    public void attributeUpdate(@WebParam(name="contractId") int var1, @WebParam(name="attribute") Attribute var2) throws Exception;

    public void attributeDelete(@WebParam(name="contractId") int var1, @WebParam(name="attributeId") int var2) throws Exception;

    @WebMethod
    public List<String> positionSearch(@WebParam(name="billPositionType") BillPositionType var1, @WebParam(name="page") Page var2) throws Exception;

    @WebMethod
    public void positionDataUpdate(@WebParam(name="billPositionType") BillPositionType var1, @WebParam(name="positionData") String var2) throws Exception;

    @WebMethod
    public void positionDataDelete(@WebParam(name="billPositionType") BillPositionType var1, @WebParam(name="key") String var2) throws Exception;

    @WebMethod
    public void numerationPoolUpdate(@WebParam(name="numerationPool") NumerationPool var1) throws Exception;

    @WebMethod
    public void numerationPoolDelete(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public NumerationPool numerationPoolGet(@WebParam(name="id") int var1) throws Exception;

    @WebMethod
    public List<NumerationPool> numerationPoolList() throws Exception;

    @WebMethod
    public DocTypes documentTypes(@WebParam(name="contractId") int var1, @WebParam(name="documentType") DocumentType var2) throws Exception;

    @WebMethod
    public List<IdTitle> docTypeTitles(@WebParam(name="contractId") int var1, @WebParam(name="documentType") DocumentType var2) throws Exception;

    @WebMethod
    public List<IdTitle> contractParameters() throws Exception;

    @WebMethod
    public BigDecimal rateVATGet() throws Exception;

    @WebMethod
    public List<KeyValue> exportFormats(@WebParam(name="docType") String var1) throws Exception;
}

