/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.BGTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.license.client.contract.LicenceBGUTable;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class LicensesPanel
extends BGUPanel {
    private int copyId = -1;
    private PackageView editor = new PackageView();
    private PackagesTableModel packagesModel = new PackagesTableModel();

    public void setCopyId(int id) {
        this.copyId = id;
    }

    public void jbInit() {
        BGUTable packagesTable = new BGUTable((TableModel)((Object)this.packagesModel));
        packagesTable.setSelectionMode(0);
        packagesTable.getSelectionModel().addListSelectionListener(e -> this.setPackageItems());
        this.editor.setVisible(true);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)packagesTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JPanel)this.editor, (String)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438"), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId()).setAction("GetPackages").setAttribute("copy_id", this.copyId);
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ArrayList<Element> packages = new ArrayList<Element>();
                for (Element rowElement : XMLUtils.selectElements((Node)doc, (String)"/data/table/data/row")) {
                    packages.add(rowElement);
                }
                this.packagesModel.setData(packages);
            }
            this.editor.licenseItemsModel.setData(new ArrayList());
            this.editor.cost.setText("");
            this.editor.encryptedText.setText("");
        });
    }

    public void setNewPackageSelected(int packageId) {
        if (this.packagesModel.getRowCount() > 0) {
            this.packagesModel.setSelectedRow((Element)this.packagesModel.getRows().get(0));
        }
        this.setPackageItems();
    }

    private void setPackageItems() {
        this.tryCall(() -> {
            Element packagesRowElement = (Element)this.packagesModel.getSelectedRow();
            if (packagesRowElement != null) {
                String id = packagesRowElement.getAttribute("id");
                Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId()).setContractId(((ClientContext)this.getContext()).getContractId()).setAction("GetPackageItems").setAttribute("package_id", id);
                Document doc = ((ClientContext)this.getContext()).getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    String licText = XMLUtils.selectElement((Node)doc, (String)"/data/originalLic").getAttribute("value");
                    ArrayList<Element> items = new ArrayList<Element>();
                    for (Element rowElement : XMLUtils.selectElements((Node)doc, (String)"/data/table/data/row")) {
                        items.add(rowElement);
                    }
                    this.editor.licenseItemsModel.setData(this.putDeletedComponentsIfHave(items, licText, doc));
                    this.editor.encryptedText.setText(XMLUtils.selectElement((Node)doc, (String)"/data/lic").getAttribute("value"));
                    this.editor.originalText.setText(licText);
                    this.editor.cost.setText(XMLUtils.selectElement((Node)doc, (String)"/data/cost").getAttribute("value"));
                    this.editor.email = XMLUtils.selectElement((Node)doc, (String)"/data/emails").getAttribute("value");
                    this.editor.repaint();
                }
            }
        });
    }

    private List<Element> putDeletedComponentsIfHave(List<Element> items, String licText, Document doc) {
        ArrayList<Order> listOrder = new ArrayList<Order>();
        ArrayList<Order> listOrderPars = new ArrayList<Order>();
        ArrayList<Order> difList = new ArrayList<Order>();
        if (Utils.notBlankString((String)licText)) {
            for (String row : licText.split("\n")) {
                int index = row.lastIndexOf("bgbilling_module_");
                if (index <= 0) continue;
                String[] el = row.substring(index + 17).split("_");
                Order order = new Order();
                order.setComponentName(el[2]);
                order.setCount(Utils.parseInt((String)el[3], (int)-5));
                order.setCreateDate(TimeUtils.parseDate((String)el[4], (String)"dd.MM.yyyy"));
                listOrderPars.add(order);
            }
        }
        for (Element el : items) {
            Order order = new Order();
            int count = Utils.parseInt((String)el.getAttribute("count"), (int)-5);
            order.setCount(count == -5 ? 0 : count);
            order.setCreateDate(TimeUtils.parseDate((String)el.getAttribute("to_date"), (String)"dd.MM.yyyy"));
            order.setComponentName(el.getAttribute("product_item_name"));
            listOrder.add(order);
        }
        block2: for (Order ord : listOrderPars) {
            for (Order ord2 : listOrder) {
                if (!ord2.getComponentName().equals(ord.getComponentName()) || ord2.getCount() != ord.getCount()) continue;
                continue block2;
            }
            difList.add(ord);
        }
        Calendar time = Calendar.getInstance();
        time.set(1, 2030);
        Date date = time.getTime();
        for (Order ord : difList) {
            Element row = doc.createElement("row");
            row.setAttribute("index", "\u221e");
            row.setAttribute("product_item_name", ord.getComponentName());
            row.setAttribute("to_date", TimeUtils.format((Date)ord.getCreateDate(), (String)"dd.MM.yyyy"));
            row.setAttribute("type", TimeUtils.dateBefore((Date)ord.getCreateDate(), (Date)date) ? "\u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439*" : "\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439");
            row.setAttribute("count", ord.getCount() == 0 ? "\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e" : Integer.toString(ord.getCount()));
            items.add(row);
        }
        return items;
    }

    class PackageView
    extends JPanel {
        private String email;
        private BGTextArea encryptedText;
        private BGTextArea originalText;
        private BGTextField cost;
        BGTableModel<Element> licenseItemsModel;

        public PackageView() {
            super(new GridBagLayout());
            this.email = "";
            this.encryptedText = new BGTextArea();
            this.originalText = new BGTextArea();
            this.cost = new BGTextField(15);
            this.licenseItemsModel = new BGTableModel<Element>("licensePackageItems"){

                protected void initColumns() {
                    this.addColumn("\u2116", 30, 30, 30, "index", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
                    this.addColumn("IDS", 0, 0, 0, "ids", false);
                    this.addColumn("PIID", 0, 0, 0, "product_item_id", false);
                    this.addColumn("\u0422\u0438\u043f", 150, 150, 150, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                    this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 300, 300, 300, "product_item_name", true);
                    this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "product_item_title", true);
                    this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 120, 120, 120, "count", true);
                    this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", 120, 120, 120, "to_date", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                    this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", 150, 150, 150, "cost", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
                }
            };
            this.encryptedText.setEditable(false);
            this.originalText.setEditable(false);
            this.cost.setHorizontalAlignment(4);
            this.cost.setEditable(false);
            BGTabbedPane tabbedPane = new BGTabbedPane();
            tabbedPane.add((Component)this.getLicenseComponentsPanel(), (Object)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
            tabbedPane.add((Component)this.getLicenseTextPanel(), (Object)"\u0421\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438");
            this.add((Component)tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private JPanel getLicenseComponentsPanel() {
            LicTable licenseItems = new LicTable((TableModel)this.licenseItemsModel, new String[]{"count"});
            JPanel licenseComponentsPanel = new JPanel(new GridBagLayout());
            licenseComponentsPanel.add((Component)new JScrollPane((Component)((Object)licenseItems)), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            licenseComponentsPanel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438: "), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
            licenseComponentsPanel.add((Component)this.cost, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 20), 0, 0));
            return licenseComponentsPanel;
        }

        private JPanel getLicenseTextPanel() {
            BGButton emailButton = new BGButton("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0430 E-mail...");
            emailButton.addActionListener(actionEvent -> {
                BGEmailDialog dialog = new BGEmailDialog();
                dialog.addPropertyChangeListener(propertyChangeEvent -> {
                    if (propertyChangeEvent.getPropertyName().equals("selectEmail")) {
                        dialog.setVisible(false);
                        dialog.dispose();
                        this.sendLicenseTextByEmail(String.valueOf(propertyChangeEvent.getNewValue()));
                    }
                });
                dialog.setEmailList(Utils.toList((String)this.email, (String)";"));
                dialog.setVisible(true);
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)emailButton, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0417\u0430\u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.encryptedText), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
            panel.add((Component)new JLabel("\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442"), new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.originalText), new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private void sendLicenseTextByEmail(String email) {
            if (email.length() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a");
            } else {
                try {
                    ClientUtils.showMessageDialog((Object)((LicenseService)((ClientContext)LicensesPanel.this.getContext()).getWebService(LicenseService.class, ((ClientContext)LicensesPanel.this.getContext()).getModuleId())).sendLicenseTextByEmail(((ClientContext)LicensesPanel.this.getContext()).getContractId(), LicensesPanel.this.copyId, email, this.encryptedText.getText()));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        }
    }

    class PackagesTableModel
    extends BGTableModel<Element> {
        public PackagesTableModel() {
            super("licensePackages");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", -1, -1, -1, "create_date", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", -1, -1, -1, "user_name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        public MyTableCellRenderer(int horizontalAlignment) {
            this.setHorizontalAlignment(horizontalAlignment);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            c.setBackground(Color.YELLOW);
            return c;
        }
    }

    class LicTable
    extends LicenceBGUTable {
        MyTableCellRenderer renR;
        MyTableCellRenderer renL;
        MyTableCellRenderer renC;

        public LicTable(TableModel model, String[] columnIdentifiers) {
            super(model, columnIdentifiers);
            this.renR = new MyTableCellRenderer(4);
            this.renL = new MyTableCellRenderer(2);
            this.renC = new MyTableCellRenderer(0);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (this.getModel().getValueAt(row, 0).equals("\u221e")) {
                switch (column) {
                    case 0: 
                    case 6: {
                        return this.renR;
                    }
                    case 3: 
                    case 7: {
                        return this.renC;
                    }
                }
                return this.renL;
            }
            return super.getCellRenderer(row, column);
        }
    }
}

