/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.card;

import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Card
extends BGJasperReport {
    private String _query;

    public Report_Card() {
        this.id = "card_dealer_card";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        BGReportFilter filter = this.createBGReportFilter();
        int mid = Utils.parseInt((String)filter.getStringParam("mid"), (int)-1);
        String dealer = filter.getStringParam("dealer");
        String services = filter.getStringParam("services");
        Date date1 = TimeUtils.parseDate((String)filter.getStringParam("date1"), (String)"dd.MM.yyyy");
        Date date2 = TimeUtils.parseDate((String)filter.getStringParam("date2"), (String)"dd.MM.yyyy");
        float summa1 = Utils.parseFloat((String)filter.getStringParam("summa_from"), (float)-1.0f);
        float summa2 = Utils.parseFloat((String)filter.getStringParam("summa_to"), (float)-1.0f);
        if (mid > 0 && date1 != null && date2 != null) {
            try {
                java.sql.Date sqlDate1 = TimeUtils.convertDateToSqlDate((Date)date1);
                java.sql.Date sqlDate2 = TimeUtils.convertDateToSqlDate((Date)date2);
                BGDataSource bgDataSource = new BGDataSource();
                StringBuffer buf = new StringBuffer();
                buf.append("SELECT count(*) FROM card_data_");
                buf.append(mid);
                buf.append(" WHERE did=?");
                String queryStart = buf.toString();
                buf = new StringBuffer();
                if (summa1 > 0.0f) {
                    buf.append(" AND summa>=");
                    buf.append(summa1);
                }
                if (summa2 > 0.0f) {
                    buf.append(" AND summa<=");
                    buf.append(summa2);
                }
                if (services != null && services.length() > 0) {
                    buf.append(" AND ( sid_act IN ( ");
                    buf.append(services);
                    buf.append(" ) OR sid_pay IN ( ");
                    buf.append(services);
                    buf.append(" ) ) ");
                }
                String queryEnd = buf.toString();
                this._query = "SELECT id, title FROM card_dealer_" + mid;
                if (dealer != null && dealer.length() > 0) {
                    this._query = this._query + " WHERE id IN ( " + dealer + " ) ";
                }
                this._query = this._query + " ORDER BY title";
                PreparedStatement ps = this.con.prepareStatement(this._query);
                ResultSet rs = ps.executeQuery();
                int vhod_ost_sum = 0;
                int prihod_sum = 0;
                int activated_sum = 0;
                int ish_ost_sum = 0;
                while (rs.next()) {
                    int vhod_ost = 0;
                    int prihod = 0;
                    int activated = 0;
                    int ish_ost = 0;
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    int dealer_id = rs.getInt(1);
                    String dealer_title = rs.getString(2);
                    buf = new StringBuffer(queryStart);
                    buf.append(" AND d_date<=? AND ( isNull( date ) OR date>=? )");
                    buf.append(queryEnd);
                    int i = 1;
                    ps = this.con.prepareStatement(buf.toString());
                    ps.setInt(i++, dealer_id);
                    ps.setDate(i++, sqlDate1);
                    ps.setDate(i++, sqlDate1);
                    ResultSet rs1 = ps.executeQuery();
                    if (rs1.next()) {
                        vhod_ost = rs1.getInt(1);
                    }
                    rs1.close();
                    buf = new StringBuffer(queryStart);
                    buf.append(" AND d_date>=?");
                    buf.append(" AND d_date<=?");
                    buf.append(queryEnd);
                    i = 1;
                    ps = this.con.prepareStatement(buf.toString());
                    ps.setInt(i++, dealer_id);
                    ps.setDate(i++, sqlDate1);
                    ps.setDate(i++, sqlDate2);
                    rs1 = ps.executeQuery();
                    if (rs1.next()) {
                        prihod = rs1.getInt(1);
                    }
                    rs1.close();
                    buf = new StringBuffer(queryStart);
                    buf.append(" AND status>1 AND date>?");
                    buf.append(" AND date<DATE_ADD( ?, INTERVAL 1 DAY )");
                    buf.append(queryEnd);
                    i = 1;
                    ps = this.con.prepareStatement(buf.toString());
                    ps.setInt(i++, dealer_id);
                    ps.setDate(i++, sqlDate1);
                    ps.setDate(i++, sqlDate2);
                    rs1 = ps.executeQuery();
                    if (rs1.next()) {
                        activated = rs1.getInt(1);
                    }
                    rs1.close();
                    ish_ost = vhod_ost + prihod - activated;
                    row.put("col1", dealer_title);
                    row.put("col2", String.valueOf(vhod_ost));
                    row.put("col3", String.valueOf(prihod));
                    row.put("col4", String.valueOf(activated));
                    row.put("col5", String.valueOf(ish_ost));
                    bgDataSource.addRow(row);
                    vhod_ost_sum += vhod_ost;
                    prihod_sum += prihod;
                    activated_sum += activated;
                    ish_ost_sum += ish_ost;
                }
                rs.close();
                ps.close();
                String reportTitle = "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0430\u043c";
                StringBuffer addInfo = new StringBuffer("\u041f\u0435\u0440\u0438\u043e\u0434: ");
                addInfo.append(TimeUtils.format((Date)date1, (String)"dd.MM.yyy"));
                addInfo.append(" - ");
                addInfo.append(TimeUtils.format((Date)date2, (String)"dd.MM.yyy"));
                if (summa1 > 0.0f || summa2 > 0.0f) {
                    addInfo.append(" c\u0443\u043c\u043c\u0430 ");
                    if (summa1 > 0.0f) {
                        addInfo.append(summa1);
                    }
                    addInfo.append(" - ");
                    if (summa2 > 0.0f) {
                        addInfo.append(summa2);
                    }
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("reportTitle", reportTitle);
                params.put("addInfo", addInfo.toString());
                params.put("sum1", String.valueOf(vhod_ost_sum));
                params.put("sum2", String.valueOf(prihod_sum));
                params.put("sum3", String.valueOf(activated_sum));
                params.put("sum4", String.valueOf(ish_ost_sum));
                this.fillReportToStream("card_dealer_card", out, params, bgDataSource);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

