/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;

public abstract class CDRConfigurePanel
extends BGUPanel {
    private SormProject sormProject;
    protected Preferences config = new Preferences();
    private final CDRFieldPanel serviceIdField = new CDRFieldPanel("sorm.upload.cdr.serviceId", "ID \u0443\u0441\u043b\u0443\u0433\u0438 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438");
    private final CDRFieldPanel regex = new CDRFieldPanel("sorm.upload.cdr.regex", "\u0420\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c \u043f\u043e\u043b\u0435\u0439");
    private final CDRFieldPanel callDate = new CDRFieldPanel("sorm.upload.cdr.calldate", "\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0432\u043e\u043d\u043a\u0430");
    private final CDRFieldPanel callType = new CDRFieldPanel("sorm.upload.cdr.calltype", "\u0422\u0438\u043f \u0432\u044b\u0437\u043e\u0432\u0430 (\u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0439/\u0438\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439/\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439)");
    private final CDRFieldPanel duration = new CDRFieldPanel("sorm.upload.cdr.callduration", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
    private final CDRFieldPanel rejectReason = new CDRFieldPanel("sorm.upload.cdr.rejectreason", "\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u0440\u0430\u0437\u044a\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
    private final CDRFieldPanel callingNumber = new CDRFieldPanel("sorm.upload.cdr.callingnumber", "\u041d\u043e\u043c\u0435\u0440 \u0432\u044b\u0437\u044b\u0432\u0430\u044e\u0449\u0435\u0433\u043e");
    private final CDRFieldPanel calledNumber = new CDRFieldPanel("sorm.upload.cdr.callednumber", "\u041d\u043e\u043c\u0435\u0440 \u0432\u044b\u0437\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e");
    private final CDRFieldPanel bunchFrom = new CDRFieldPanel("sorm.upload.cdr.callednumber", "\u041f\u043e\u0440\u0442 1");
    private final CDRFieldPanel bunchTo = new CDRFieldPanel("sorm.upload.cdr.callednumber", "\u041f\u043e\u0440\u0442 2");
    private final CDRFieldPanel commutatorId = new CDRFieldPanel("sorm.upload.cdr.commutatorid", "ID \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u0430");
    private final CDRFieldPanel contractId = new CDRFieldPanel("sorm.upload.cdr.cid", "ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
    private final List<CDRFieldPanel> cdrFieldPanels = List.of(this.serviceIdField, this.regex, this.callDate, this.callType, this.duration, this.rejectReason, this.callingNumber, this.calledNumber, this.bunchFrom, this.bunchTo, this.commutatorId, this.contractId);

    public CDRConfigurePanel(SormProject sormProject) {
        this.sormProject = sormProject;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0441\u043e\u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u0435\u0439");
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0);
        this.add(BGSwingUtilites.createHelpLabel((String)"<html>\u041d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 0 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0432 \u043a\u0430\u043a\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0432 CDR \u0437\u0430\u043f\u0438\u0441\u0438 \u043d\u0430\u0445\u043e\u0434\u044f\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u044b\u0435<br>(\u041d\u0435 \u0432\u0441\u0435 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b \u043a \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044e)<br>\u0412 \u043f\u043e\u043b\u0435 \"\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\" \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u0435\u0444\u043e\u043b\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.</html>", (int)1), constraints);
        this.cdrFieldPanels.forEach(p -> this.add((Component)p, constraints));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, -1, 0, 0, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.sormProject == null || Utils.isBlankString((String)this.sormProject.getConfig())) {
                return;
            }
            this.config = this.sormProject.getLoadedConfig();
            if (this.config == null || this.config.getMap().isEmpty()) {
                return;
            }
            JSONArray cdrSettings = new JSONArray(this.config.get("sorm.upload.cdr.config", "[]"));
            for (int i = 0; i < cdrSettings.length(); ++i) {
                JSONObject o = cdrSettings.getJSONObject(i);
                for (CDRFieldPanel panel : this.cdrFieldPanels) {
                    if (!panel.sormConfigKey.equals(o.optString("configKey"))) continue;
                    panel.setFieldValue(o.optString("value"));
                    panel.setCustomValue(o.optString("customValue"));
                }
            }
        });
    }

    public void buildConfig(Preferences config) {
        JSONArray cdrSettings = new JSONArray();
        this.cdrFieldPanels.forEach(p -> cdrSettings.put((Object)p.toJson()));
        config.set("sorm.upload.cdr.config", cdrSettings.toString());
    }

    public SormProject getSormProject() {
        return this.sormProject;
    }

    public void setSormProject(SormProject sormProject) {
        this.sormProject = sormProject;
    }

    protected static final class CDRFieldPanel
    extends JPanel {
        private final IntTextField userValueField = new IntTextField(3);
        private final JTextField customValue = new JTextField(3);
        private final String sormConfigKey;

        public CDRFieldPanel(String sormConfigKey, String descriptionField) {
            this.sormConfigKey = sormConfigKey;
            this.setLayout(new GridBagLayout());
            BGSwingUtilites.wrapBorder((JPanel)this, (String)descriptionField);
            this.add((Component)new JLabel("#:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
            this.add((Component)this.userValueField, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
            this.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
            this.add((Component)this.customValue, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
        }

        public int getFieldValue() {
            return Utils.parseInt((String)this.userValueField.getText(), (int)-1);
        }

        public String getSormConfigKey() {
            return this.sormConfigKey;
        }

        public void setFieldValue(String value) {
            this.userValueField.setText(value);
        }

        public void setCustomValue(String v) {
            this.customValue.setText(v);
        }

        public String getCustomValue() {
            return Utils.maskBlank((String)this.customValue.getText(), (String)"");
        }

        public JSONObject toJson() {
            JSONObject json = new JSONObject();
            json.put("configKey", (Object)this.sormConfigKey);
            json.put("value", this.getFieldValue());
            json.put("customValue", (Object)this.getCustomValue());
            return json;
        }
    }
}

