/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.utils;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class InternalUserAddressUtils {
    private final EntityAttrAddress entityAttrAddress;
    private final House house;

    public InternalUserAddressUtils(EntityAttrAddress entityAttrAddress, Connection connection) throws BGException {
        this.entityAttrAddress = entityAttrAddress;
        this.house = new HouseDao(connection).get(entityAttrAddress.getHouseId());
    }

    public String getIndex() throws BGException {
        return this.house == null ? "" : Utils.maskBlank((String)this.house.getPostIndex(), (String)"");
    }

    public String getCountry() throws BGException {
        return this.house == null ? "" : this.house.optCountry().map(IdTitle::getTitle).orElse("");
    }

    public String getArea() {
        return this.house == null ? "" : this.house.optArea().map(IdTitle::getTitle).orElse("");
    }

    public String getCity() {
        return this.house == null ? "" : this.house.optCity().map(IdTitle::getTitle).orElse("");
    }

    public String getStreet() {
        return this.house == null ? "" : this.house.optStreet().map(IdTitle::getTitle).orElse("");
    }

    public String getHouse() {
        return this.house == null ? "" : String.valueOf(this.house.getHouse());
    }

    public String getFrac() {
        return this.house == null ? "" : Utils.maskBlank((String)this.house.getFrac(), (String)"");
    }

    public String getFlat() {
        return Utils.maskBlank((String)this.entityAttrAddress.getFlat(), (String)"");
    }

    public String toString() {
        return "InternalUserAddressUtils{addressParamValue=" + this.entityAttrAddress.getTitle() + "}";
    }
}

