/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.modules.hd.server.bean.CPDomain;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackageManager;
import ru.bitel.common.Utils;

public class CPDomainManager {
    private Connection con;
    private int mid;
    private String tableName;

    public CPDomainManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = "hd_cp_domain_" + mid;
    }

    public CPDomain getDomain(int cpid) {
        CPDomain result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE cpid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cpid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getHdServiceDomainFromRS(rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int checkDomain(String packages, int cpid, String domain) {
        int result = 0;
        try {
            String contractPackageTable = ContractPackageManager.getTableName(this.mid);
            String query = "SELECT cp.cid FROM " + this.tableName + " AS domain INNER JOIN " + contractPackageTable + " AS cp ON domain.cpid=cp.id AND cp.status=? WHERE pid IN ( " + packages + ") AND domain.cpid!=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, 1);
            ps.setInt(2, cpid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private CPDomain getHdServiceDomainFromRS(ResultSet rs) throws SQLException {
        CPDomain result = new CPDomain();
        result.setContractPackageId(rs.getInt("cpid"));
        result.setDomain(rs.getString("domain"));
        result.setAdminMail(rs.getString("admin_mail"));
        result.setRecords(Utils.stringToPairs((String)rs.getString("records")));
        return result;
    }

    public void deleteDomain(int cpid) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cpid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateDomain(CPDomain domain) {
        try {
            this.deleteDomain(domain.getContractPackageId());
            String query = "INSERT INTO " + this.tableName + " (cpid, domain, admin_mail, records) VALUES (?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, domain.getContractPackageId());
            ps.setString(2, domain.getDomain());
            ps.setString(3, domain.getAdminMail());
            ps.setString(4, Utils.pairToString(domain.getRecords()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

