/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.editor;

import bitel.billing.module.common.BGControlPanelDate;
import bitel.billing.module.common.CheckTree;
import bitel.billing.module.common.ModTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.editor.ContractRuleEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class TreePanel
extends BGPanel {
    protected CheckTree addressTree;
    protected ModTreeNode addressRootNode;
    protected CheckTree netTree;
    protected ModTreeNode netRootNode;
    private JCheckBox dateCheck = new JCheckBox();
    private BGControlPanelDate datePanel = new BGControlPanelDate();
    private ContractRuleEditorPanel parent;

    public TreePanel(ContractRuleEditorPanel parent) {
        this.initGUI();
        this.parent = parent;
    }

    private void initGUI() {
        JTabbedPane pane = new JTabbedPane();
        JPanel addressPanel = this.createAddressPanel();
        pane.add((Component)addressPanel, "\u0410\u0434\u0440\u0435\u0441\u0430");
        JPanel netPanel = this.createNetPanel();
        pane.add((Component)netPanel, "\u0421\u0435\u0442\u0438");
        this.setLayout(new GridBagLayout());
        JPanel sourcePanel = this.createSourcePanel();
        this.add(pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(sourcePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel createSourcePanel() {
        this.datePanel.setBorder(null);
        this.dateCheck.setToolTipText("");
        this.dateCheck.setText("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043d\u0430 \u043c\u043e\u043c\u0435\u043d\u0442:");
        this.dateCheck.addActionListener(e -> this.parent.trySetData());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.dateCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this.datePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createAddressPanel() {
        this.addressRootNode = this.initRootNode();
        this.addressRootNode.setText("\u0410\u0434\u0440\u0435\u0441\u0430");
        this.addressTree = new CheckTree(this.addressRootNode);
        JPanel addressPanel = new JPanel();
        addressPanel.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane((Component)this.addressTree);
        addressPanel.add((Component)scroll, "Center");
        return addressPanel;
    }

    private ModTreeNode initRootNode() {
        ModTreeNode node = new ModTreeNode();
        node.setAttribute("id", (Object)"0");
        node.setEn(false);
        node.setAttribute("type", (Object)"1");
        node.setIcon("closed");
        return node;
    }

    private JPanel createNetPanel() {
        this.netRootNode = this.initRootNode();
        this.netRootNode.setText("\u0421\u0435\u0442\u0438");
        this.netTree = new CheckTree(this.netRootNode);
        JPanel netPanel = new JPanel();
        netPanel.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane((Component)this.netTree);
        netPanel.add((Component)scroll, "Center");
        return netPanel;
    }

    public void setData() throws Exception {
        this.addressRootNode.removeAllChildren();
        this.netRootNode.removeAllChildren();
        Request req = new Request();
        if (this.dateCheck.isSelected() && !Utils.isEmptyString((String)this.datePanel.getDateString())) {
            req.setAttribute("date", this.datePanel.getDateString());
        }
        this.updateAddresses(false, req);
        this.updateAddresses(true, req);
    }

    private void updateAddresses(boolean isNet, Request req) throws Exception {
        Document doc;
        req.setModule(this.module);
        req.setAction("AddressContractInfo");
        req.setModuleId(this.getModuleId());
        req.setContractId(this.getContractId());
        if (isNet) {
            req.setAttribute("net", "true");
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(req)))) {
            for (Element row : XMLUtils.selectElements((Node)doc.getDocumentElement(), (String)"/data/table/data/row")) {
                String addressRange = row.getAttribute("address_range");
                String comment = row.getAttribute("comment");
                if (!isNet) {
                    String[] addresses = addressRange.split("\\s+\\-\\s+");
                    if (addresses.length != 2) continue;
                    long address1 = IPUtils.convertStringIPtoLong((String)addresses[0].trim(), (long)0L);
                    long address2 = IPUtils.convertStringIPtoLong((String)addresses[1].trim(), (long)0L);
                    if (addresses[0].trim().equals("0.0.0.0") || addresses[1].trim().equals("255.255.255.255")) continue;
                    ModTreeNode rangeNode = new ModTreeNode();
                    rangeNode.setAttribute("id", (Object)"0");
                    rangeNode.setEn(true);
                    rangeNode.setText(addressRange + " [" + comment + "]");
                    rangeNode.setIcon("closed");
                    this.addressRootNode.add((MutableTreeNode)rangeNode);
                    if (address2 - address1 > 255L) {
                        address2 = address1 + 255L;
                    }
                    for (long address = address1; address <= address2; ++address) {
                        ModTreeNode addressNode = new ModTreeNode();
                        addressNode.setAttribute("id", (Object)String.valueOf(address));
                        addressNode.setEn(true);
                        addressNode.setText(IPUtils.convertLongIpToString((long)address));
                        rangeNode.add((MutableTreeNode)addressNode);
                    }
                    continue;
                }
                String[] parts = addressRange.split("/");
                if (parts.length != 2) continue;
                String ip = parts[0];
                String mask = parts[1];
                ModTreeNode rangeNode = new ModTreeNode();
                rangeNode.setAttribute("id", (Object)(IPUtils.convertStringIPtoLong((String)ip, (long)0L) + "/" + mask));
                rangeNode.setEn(true);
                rangeNode.setText(addressRange + " [" + comment + "]");
                rangeNode.setIcon("closed");
                this.netRootNode.add((MutableTreeNode)rangeNode);
            }
            if (!isNet) {
                this.addressTree.setTreeTopNode(this.addressRootNode);
                this.addressTree.expandPath(new TreePath(this.addressRootNode.getPath()));
            } else {
                this.netTree.setTreeTopNode(this.netRootNode);
                this.netTree.expandPath(new TreePath(this.netRootNode.getPath()));
            }
        }
    }

    public void setAddressCodes(String data) {
        this.addressTree.setCodes(data);
    }

    public String getAddressCodes() {
        return this.addressTree.getCodes();
    }

    public void setNetCodes(String data) {
        this.netTree.setCodes(data);
    }

    public String getNetCodes() {
        return this.netTree.getCodes();
    }

    public void addMouseListener(MouseListener listener) {
        this.addressTree.addMouseListener(listener);
        this.netTree.addMouseListener(listener);
    }

    public void setRule(String data) {
        String[] parts = data.split(";");
        String addresses = "";
        String nets = "";
        if (parts.length > 0) {
            addresses = parts[0];
        }
        if (parts.length > 1) {
            nets = parts[1];
        }
        this.setAddressCodes(addresses);
        this.setNetCodes(nets);
    }

    public String getRule() {
        return this.getAddressCodes() + ";" + this.getNetCodes();
    }
}

