/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.util.Calendar;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class LogUploader
extends Thread {
    private int sourceId;
    private Calendar hour;
    private FileWriter fileWriter;
    private Writer writer;
    private Setup setup;

    public LogUploader(Setup setup, String params) throws BGException {
        this.setup = setup;
        StringTokenizer st = new StringTokenizer(params, " ");
        if (st.countTokens() != 3) {
            throw new BGException("Wrong param count. Command param count must be 3");
        }
        this.sourceId = Utils.parseInt((String)st.nextToken().trim(), (int)-1);
        if (this.sourceId <= 0) {
            throw new BGException("Wrong param. Param sourceId must be positive integer");
        }
        this.hour = TimeUtils.parseCalendar((String)st.nextToken().trim(), (String)"yyyy-MM-dd-HH");
        if (this.hour == null) {
            throw new BGException("Wrong param. Param hour must be yyyy-MM-dd-HH date");
        }
        String path = st.nextToken().trim();
        File file = new File(path);
        try {
            if (!(file.exists() && file.canWrite() || file.createNewFile())) {
                throw new BGException("Can't create file: " + path);
            }
            this.fileWriter = new FileWriter(file);
            this.writer = new BufferedWriter(this.fileWriter, 1000000);
        }
        catch (IOException e) {
            throw new BGException("File create error! " + e.getMessage());
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            FlowReader reader;
            Source source = new SourceManager(con).getSource(this.sourceId);
            IPHourlyDataLog dataLog = new IPHourlyDataLog((ParameterMap)this.setup, source.getId(), this.hour);
            this.writer.write("Timestamp\tFromIp\tFromPort\tToIp\tToPort\tBytes\tFromIface\tToIface\n");
            while ((reader = (FlowReader)dataLog.nextReader(null, false)) != null) {
                FlowArray f;
                while ((f = reader.readChunk()) != null) {
                    int size = f.size;
                    for (int i = 0; i < size; ++i) {
                        Data flow = f.array[i];
                        this.writer.write(String.valueOf(flow.getMilliseconds()));
                        this.writer.write("\t");
                        this.writer.write(IPUtils.convertLongIpToString((long)flow.getSrcAddress()));
                        this.writer.write("\t");
                        this.writer.write(String.valueOf(flow.getSrcPort()));
                        this.writer.write("\t");
                        this.writer.write(IPUtils.convertLongIpToString((long)flow.getDstAddress()));
                        this.writer.write("\t");
                        this.writer.write(String.valueOf(flow.getDstPort()));
                        this.writer.write("\t");
                        this.writer.write(String.valueOf(flow.getOctets()));
                        this.writer.write("\t");
                        this.writer.write(String.valueOf(flow.getInputInterface()));
                        this.writer.write("\t");
                        this.writer.write(String.valueOf(flow.getOutputInterface()));
                        this.writer.write("\n");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
            try {
                this.writer.close();
                this.fileWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

