/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.dlink;

import java.util.ArrayList;
import ru.bitel.bgbilling.modules.ipn.server.DlinkGateWorker;
import ru.bitel.bgbilling.modules.ipn.server.dlink.PortMask;
import ru.bitel.bgbilling.modules.ipn.server.dlink.Rule;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.varbind;

public class EthernetRule
extends Rule {
    private String OID;
    private String OID_TYPE;
    private String OID_SRC_MAC;
    private String OID_DST_MAC;
    private String OID_ETHERNET_TYPE;
    public static final String ETHERNET_TYPE_ARP = "08 06";
    private String OID_MANAGE;
    public static final int MANAGE_CREATE = 4;
    public static final int MANAGE_DELETE = 6;
    public static final int TYPE_DENY = 1;
    public static final int TYPE_PERMIT = 2;
    private String OID_PORT;
    private int type;
    private String srcMask;
    private String dstMask;
    private String ethernetType;
    private int port;

    public static final String getOid(int model) {
        String OID = null;
        switch (model) {
            case 1: {
                OID = "1.3.6.1.4.1.171.12.9.2.1.1";
                break;
            }
            case 2: {
                OID = "1.3.6.1.4.1.171.12.9.3.1.1";
            }
        }
        return OID;
    }

    public EthernetRule(int model) {
        this.OID = EthernetRule.getOid(model);
        this.OID_TYPE = this.OID + ".13";
        this.OID_SRC_MAC = this.OID + ".4";
        this.OID_DST_MAC = this.OID + ".5";
        this.OID_ETHERNET_TYPE = this.OID + ".7";
        this.OID_MANAGE = this.OID + ".15";
        this.OID_PORT = this.OID + ".14";
    }

    public EthernetRule(int model, int id, int port, int type, String srcMask, String dstMask, String ethernetType) {
        this(model);
        this.id = id;
        this.port = port;
        this.type = type;
        this.srcMask = srcMask;
        this.dstMask = dstMask;
        this.ethernetType = ethernetType;
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof EthernetRule;
        if (result) {
            EthernetRule cmp = (EthernetRule)obj;
            result = result && cmp.port == this.port;
            result = result && cmp.srcMask.equals(this.srcMask);
            result = result && cmp.dstMask.equals(this.dstMask);
            result = result && cmp.ethernetType == this.ethernetType;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("EthernetRule port=");
        result.append(this.port);
        result.append("; srcMask=");
        result.append(this.srcMask);
        result.append("; dstMask=");
        result.append(this.dstMask);
        result.append("; ethernetType=");
        result.append(this.ethernetType);
        return result.toString();
    }

    @Override
    public void takeData(PortMask pm, String oid, varbind var) {
        if (oid.startsWith(this.OID_PORT)) {
            this.port = pm.maskToPort(this.getBytes(var));
        } else if (oid.startsWith(this.OID_ETHERNET_TYPE)) {
            this.ethernetType = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_SRC_MAC)) {
            this.srcMask = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_DST_MAC)) {
            this.dstMask = Utils.bytesToString((byte[])this.getBytes(var));
        } else if (oid.startsWith(this.OID_TYPE)) {
            this.type = this.getInt(var);
        }
    }

    @Override
    public void createRule(int profile, DlinkGateWorker gateWorker, PortMask pm) throws Exception {
        String id = profile + "." + this.id;
        ArrayList<Object[]> pairs = new ArrayList<Object[]>(5);
        String oid = null;
        oid = this.OID_SRC_MAC + "." + id;
        pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.srcMask))});
        oid = this.OID_DST_MAC + "." + id;
        pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.dstMask))});
        oid = this.OID_PORT + "." + id;
        pairs.add(new Object[]{oid, new AsnOctets(pm.portToMask(this.port))});
        oid = this.OID_TYPE + "." + id;
        pairs.add(new Object[]{oid, new AsnInteger(this.type)});
        oid = this.OID_ETHERNET_TYPE + "." + id;
        pairs.add(new Object[]{oid, new AsnOctets(Utils.hexStringToBytes((String)this.ethernetType))});
        oid = this.OID_MANAGE + "." + id;
        pairs.add(new Object[]{oid, new AsnInteger(4)});
        gateWorker.sendSetPdu(pairs);
    }

    @Override
    public void deleteRule(int profile, DlinkGateWorker gateWorker) throws Exception {
        String oid = this.OID_MANAGE + "." + profile + "." + this.id;
        gateWorker.sendSetPdu(oid, (AsnObject)new AsnInteger(6));
    }
}

